/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.filters.io;

import java.io.IOException;
import java.util.Arrays;
import org.verapdf.as.io.ASInputStream;

public class COSFilterASCIIReader {
    private boolean isASCIIHex;
    private ASInputStream stream;
    private byte[] buf;
    private int bufPointer;
    private static final byte ASCII_HEX_EOD = 62;
    private static final byte ASCII85_EOD = 126;
    private static final byte Z = 122;
    private static final byte EXCLAM_MARK = 33;
    private boolean isEOD;
    private int ascii85ZeroRemains;

    public COSFilterASCIIReader(ASInputStream stream, boolean isASCIIHex) throws IOException {
        this.stream = stream;
        this.isASCIIHex = isASCIIHex;
        this.buf = new byte[2048];
        this.bufPointer = 0;
        if (this.buf[0] == 60 && this.buf[1] == 126) {
            this.bufPointer += 2;
        }
        this.isEOD = false;
        this.ascii85ZeroRemains = 0;
    }

    public byte[] getNextBytes() throws IOException {
        int i;
        byte b;
        int i2;
        if (this.isEOD) {
            return null;
        }
        if (this.isASCIIHex) {
            byte b2;
            byte[] twoBytes = new byte[2];
            while (COSFilterASCIIReader.isWS(b2 = this.readByte()) && b2 != -1) {
            }
            if (b2 == -1 || b2 == 62) {
                this.isEOD = true;
                return null;
            }
            if (!COSFilterASCIIReader.isValidASCIIHexByte(b2)) {
                throw new IOException("Can not read ASCII Hex string.");
            }
            twoBytes[0] = b2;
            while (COSFilterASCIIReader.isWS(b2 = this.readByte()) && b2 != -1) {
            }
            if (b2 == -1 || b2 == 62) {
                this.isEOD = true;
                twoBytes[1] = 0;
            } else {
                if (!COSFilterASCIIReader.isValidASCIIHexByte(b2)) {
                    throw new IOException("Can not read ASCII Hex string.");
                }
                twoBytes[1] = b2;
            }
            return twoBytes;
        }
        byte[] fiveBytes = new byte[5];
        for (i2 = 0; i2 < 5; ++i2) {
            fiveBytes[i2] = 0;
        }
        for (i2 = 0; i2 < this.ascii85ZeroRemains; ++i2) {
            fiveBytes[i2] = 33;
        }
        if (this.ascii85ZeroRemains == 0) {
            while (COSFilterASCIIReader.isWS(b = this.readByte()) && b != -1) {
            }
            if (b == -1 || b == 126) {
                this.isEOD = true;
                return null;
            }
            if (b == 122) {
                this.processCaseOfZ(fiveBytes, 0);
                return fiveBytes;
            }
            if (!COSFilterASCIIReader.isValidASCII85Byte(b)) {
                throw new IOException("Can not read ASCII85 string.");
            }
            fiveBytes[0] = b;
        }
        int n = i = this.ascii85ZeroRemains == 0 ? 1 : this.ascii85ZeroRemains;
        while (i < 5) {
            while (COSFilterASCIIReader.isWS(b = this.readByte()) && b != -1) {
            }
            if (b == -1 || b == 126) {
                this.isEOD = true;
                return Arrays.copyOf(fiveBytes, i);
            }
            if (b == 122) {
                this.processCaseOfZ(fiveBytes, i);
                return fiveBytes;
            }
            if (!COSFilterASCIIReader.isValidASCII85Byte(b)) {
                throw new IOException("Can not read ASCII85 string.");
            }
            fiveBytes[i] = b;
            ++i;
        }
        this.ascii85ZeroRemains = 0;
        return fiveBytes;
    }

    private static boolean isWS(byte c) {
        return c == 0 || c == 9 || c == 10 || c == 12 || c == 13 || c == 32;
    }

    private static boolean isValidASCIIHexByte(byte c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static boolean isValidASCII85Byte(byte c) {
        return c >= 33 && c <= 117 || c == 122;
    }

    private byte readByte() throws IOException {
        if (this.bufPointer == this.buf.length) {
            if (this.stream.read(this.buf, this.buf.length) == -1) {
                return -1;
            }
            this.bufPointer = 0;
        }
        return this.buf[this.bufPointer++];
    }

    private void processCaseOfZ(byte[] fiveBytes, int i) {
        for (int j = i; j < 5; ++j) {
            fiveBytes[j] = 33;
        }
        this.ascii85ZeroRemains = i;
    }
}

