/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.xref.COSXRefInfo;

public class COSXRefTableReader {
    private long startXRef = 0L;
    private Map<COSKey, Long> offsets = new HashMap<COSKey, Long>();
    private COSTrailer trailer = new COSTrailer();
    private COSTrailer firstTrailer;
    private COSTrailer lastTrailer;

    public COSXRefTableReader() {
    }

    public COSXRefTableReader(List<COSXRefInfo> info) {
        this();
        this.set(info);
    }

    public COSXRefTableReader(COSXRefInfo info) {
        this();
        this.set(info);
    }

    public void set(List<COSXRefInfo> infos) {
        this.startXRef = 0L;
        this.offsets.clear();
        this.trailer.clear();
        if (infos == null || infos.isEmpty()) {
            return;
        }
        COSXRefInfo lastInfo = infos.get(infos.size() - 1);
        this.startXRef = lastInfo.getStartXRef();
        this.trailer = lastInfo.getTrailer();
        HashMap<Long, COSTrailer> trailers = new HashMap<Long, COSTrailer>();
        for (COSXRefInfo info : infos) {
            trailers.put(info.getStartXRef(), info.getTrailer());
            info.getXRefSection().addTo(this.offsets);
        }
        this.setFirstLastTrailers(trailers);
        infos.clear();
    }

    public void setFirstLastTrailers(Map<Long, COSTrailer> trailers) {
        if (trailers.isEmpty()) {
            return;
        }
        Set<Long> offsets = trailers.keySet();
        TreeSet<Long> sortedOffset = new TreeSet<Long>(offsets);
        this.firstTrailer = trailers.get(sortedOffset.first());
        this.lastTrailer = trailers.get(sortedOffset.last());
    }

    public void set(COSXRefInfo info) {
        this.startXRef = info.getStartXRef();
        this.offsets.clear();
        info.getXRefSection().addTo(this.offsets);
        this.trailer = info.getTrailer();
    }

    public long getStartXRef() {
        return this.startXRef;
    }

    public List<COSKey> getKeys() {
        ArrayList<COSKey> result = new ArrayList<COSKey>();
        for (Map.Entry<COSKey, Long> entry : this.offsets.entrySet()) {
            result.add(entry.getKey());
        }
        return result;
    }

    public long getOffset(COSKey key) {
        Long value = this.offsets.get(key);
        return value != null ? value : 0L;
    }

    public boolean containsKey(COSKey key) {
        return this.offsets.containsKey(key);
    }

    public COSTrailer getTrailer() {
        return this.trailer;
    }

    public COSTrailer getFirstTrailer() {
        return this.firstTrailer;
    }

    public COSTrailer getLastTrailer() {
        return this.lastTrailer;
    }
}

