/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSDictionary;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.truetype.AdobeGlyphList;

public abstract class PDSimpleFont
extends PDFont {
    private static final Logger LOGGER = Logger.getLogger(PDSimpleFont.class.getCanonicalName());

    public PDSimpleFont(COSDictionary dictionary) {
        super(dictionary);
    }

    @Override
    public String toUnicode(int code) {
        String glyphName;
        String unicodeString = super.toUnicode(code);
        if (unicodeString != null) {
            return unicodeString;
        }
        Encoding fontEncoding = this.getEncodingMapping();
        if (fontEncoding != null && (glyphName = fontEncoding.getName(code)) != null) {
            AdobeGlyphList.AGLUnicode unicode = AdobeGlyphList.get(glyphName);
            if (unicode != AdobeGlyphList.empty()) {
                return unicode.getUnicodeString();
            }
            LOGGER.log(Level.FINE, "Cannot find glyph " + glyphName + " in Adobe Glyph List.");
            return null;
        }
        LOGGER.log(Level.FINE, "Cannot find encoding for glyph with code" + code + " in font " + this.getName());
        return null;
    }
}

