/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDObject;
import org.verapdf.pd.actions.PDFormFieldActions;
import org.verapdf.pd.form.PDSignatureField;

public class PDFormField
extends PDObject {
    protected PDFormField(COSObject obj) {
        super(obj);
    }

    public static PDFormField createTypedFormField(COSObject obj) {
        ASAtom fieldType = PDFormField.getFieldTypeCOSObject(obj);
        if (fieldType == ASAtom.SIG) {
            return new PDSignatureField(obj);
        }
        return new PDFormField(obj);
    }

    public ASAtom getFT() {
        return PDFormField.getInheritedFT(this.getObject());
    }

    private static ASAtom getInheritedFT(COSObject obj) {
        COSObject currObject = obj;
        HashSet<COSKey> checkedObjects = new HashSet<COSKey>();
        while (currObject != null) {
            COSObject parent;
            ASAtom currFT = currObject.getNameKey(ASAtom.FT);
            if (currFT != null) {
                return currFT;
            }
            COSKey currKey = currObject.getKey();
            if (currKey != null) {
                checkedObjects.add(currKey);
            }
            if ((parent = currObject.getKey(ASAtom.PARENT)) != null && parent.getType().isDictionaryBased() && !checkedObjects.contains(parent.getKey())) {
                currObject = parent;
                continue;
            }
            currObject = null;
        }
        return null;
    }

    public PDFormFieldActions getActions() {
        COSObject object = this.getKey(ASAtom.AA);
        if (object != null && object.getType().isDictionaryBased()) {
            return new PDFormFieldActions(object);
        }
        return null;
    }

    public List<PDFormField> getChildFormFields() {
        if (this.isNonTerminalField()) {
            ArrayList<PDFormField> res = new ArrayList<PDFormField>();
            for (COSObject elem : (COSArray)this.getKey(ASAtom.KIDS).getDirectBase()) {
                res.add(new PDFormField(elem));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private boolean isNonTerminalField() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && kids.getType() == COSObjType.COS_ARRAY) {
            for (COSObject elem : (COSArray)kids.getDirectBase()) {
                if (elem != null && elem.getType().isDictionaryBased() && !ASAtom.ANNOT.equals(elem.getNameKey(ASAtom.TYPE))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static ASAtom getFieldTypeCOSObject(COSObject field) {
        ASAtom res = field.getNameKey(ASAtom.FT);
        if (res != null) {
            return res;
        }
        COSObject parent = field.getKey(ASAtom.PARENT);
        if (parent != null) {
            return PDFormField.getFieldTypeCOSObject(parent);
        }
        return null;
    }
}

