/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.RowEncodingIterator;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.VertexIterator;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;
import org.vertexium.accumulo.iterator.util.DataInputStreamUtils;
import org.vertexium.accumulo.iterator.util.DataOutputStreamUtils;

public class ConnectedVertexIdsIterator
extends RowEncodingIterator {
    public static final String SETTING_LABEL_PREFIX = "label:";
    public static final String SETTING_EXCLUDED_LABEL_PREFIX = "excludedLabel:";
    private Set<String> labels;
    private Set<String> excludedLabels;

    public static void setLabels(IteratorSetting settings, String[] labels) {
        ConnectedVertexIdsIterator.addLabelsToSettings(settings, SETTING_LABEL_PREFIX, labels);
    }

    public static void setExcludedLabels(IteratorSetting settings, String[] labels) {
        ConnectedVertexIdsIterator.addLabelsToSettings(settings, SETTING_EXCLUDED_LABEL_PREFIX, labels);
    }

    private static void addLabelsToSettings(IteratorSetting settings, String settingPrefix, String[] labels) {
        if (labels == null) {
            return;
        }
        for (int i = 0; i < labels.length; ++i) {
            settings.addOption(settingPrefix + i, labels[i]);
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        HashSet<String> labels = new HashSet<String>();
        HashSet<String> excludedLabels = new HashSet<String>();
        for (Map.Entry<String, String> option : options.entrySet()) {
            if (option.getKey().startsWith(SETTING_LABEL_PREFIX)) {
                labels.add(option.getValue());
                continue;
            }
            if (!option.getKey().startsWith(SETTING_EXCLUDED_LABEL_PREFIX)) continue;
            excludedLabels.add(option.getValue());
        }
        this.labels = labels.size() == 0 ? null : labels;
        this.excludedLabels = excludedLabels.size() == 0 ? null : excludedLabels;
    }

    public static Set<String> decodeValue(Value value) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(value.get());
        DataInputStream in = new DataInputStream(bais);
        return DataInputStreamUtils.decodeSetOfStrings(in);
    }

    public SortedMap<Key, Value> rowDecoder(Key rowKey, Value rowValue) throws IOException {
        throw new VertexiumAccumuloIteratorException("not implemented");
    }

    public Value rowEncoder(List<Key> keys, List<Value> values) throws IOException {
        HashMap<Text, String> inVertexIds = new HashMap<Text, String>();
        HashMap<Text, String> outVertexIds = new HashMap<Text, String>();
        for (int i = 0; i < keys.size(); ++i) {
            EdgeInfo edgeInfo;
            Key key = keys.get(i);
            Value value = values.get(i);
            if (key.getColumnFamily().equals((Object)VertexIterator.CF_OUT_EDGE)) {
                edgeInfo = new EdgeInfo(value.get(), key.getTimestamp());
                if (!this.isMatch(edgeInfo)) continue;
                outVertexIds.put(key.getColumnQualifier(), edgeInfo.getVertexId());
                continue;
            }
            if (key.getColumnFamily().equals((Object)VertexIterator.CF_OUT_EDGE_HIDDEN) || key.getColumnFamily().equals((Object)VertexIterator.CF_OUT_EDGE_SOFT_DELETE)) {
                outVertexIds.remove(key.getColumnQualifier());
                continue;
            }
            if (key.getColumnFamily().equals((Object)VertexIterator.CF_IN_EDGE)) {
                edgeInfo = new EdgeInfo(value.get(), key.getTimestamp());
                if (!this.isMatch(edgeInfo)) continue;
                inVertexIds.put(key.getColumnQualifier(), edgeInfo.getVertexId());
                continue;
            }
            if (!key.getColumnFamily().equals((Object)VertexIterator.CF_IN_EDGE_HIDDEN) && !key.getColumnFamily().equals((Object)VertexIterator.CF_IN_EDGE_SOFT_DELETE)) continue;
            inVertexIds.remove(key.getColumnQualifier());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        HashSet<String> vertexIds = new HashSet<String>();
        vertexIds.addAll(inVertexIds.values());
        vertexIds.addAll(outVertexIds.values());
        DataOutputStreamUtils.encodeSetOfStrings(out, vertexIds);
        return new Value(baos.toByteArray());
    }

    private boolean isMatch(EdgeInfo edgeInfo) {
        if (this.excludedLabels != null && this.excludedLabels.contains(edgeInfo.getLabel())) {
            return false;
        }
        return this.labels == null || this.labels.contains(edgeInfo.getLabel());
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new ConnectedVertexIdsIterator();
    }
}

