/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.hadoop.io.Text;
import org.vertexium.ElementFilter;
import org.vertexium.accumulo.iterator.EdgeIterator;
import org.vertexium.accumulo.iterator.VertexIterator;
import org.vertexium.accumulo.iterator.util.SetOfStringsEncoder;

public class HasAuthorizationFilter
extends Filter {
    private static final String SETTING_AUTHORIZATION_TO_MATCH = "authorizationToMatch";
    private static final String SETTING_FILTERS = "filters";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("[^A-Za-z0-9_\\-\\.]");
    private String authorizationToMatch;
    private EnumSet<ElementFilter> filters;
    private Map<Text, Boolean> matchCache;

    public static void setAuthorizationToMatch(IteratorSetting settings, String authorizationToMatch) {
        settings.addOption(SETTING_AUTHORIZATION_TO_MATCH, authorizationToMatch);
    }

    public static void setFilters(IteratorSetting settings, EnumSet<ElementFilter> filters) {
        HashSet<String> filterStrings = new HashSet<String>();
        for (ElementFilter filter : filters) {
            filterStrings.add(filter.name());
        }
        settings.addOption(SETTING_FILTERS, SetOfStringsEncoder.encodeToString(filterStrings));
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.authorizationToMatch = options.get(SETTING_AUTHORIZATION_TO_MATCH);
        Set<String> filterStrings = SetOfStringsEncoder.decodeFromString(options.get(SETTING_FILTERS));
        ArrayList<ElementFilter> filtersCollection = new ArrayList<ElementFilter>();
        for (String filterString : filterStrings) {
            filtersCollection.add(ElementFilter.valueOf(filterString));
        }
        this.filters = EnumSet.copyOf(filtersCollection);
        this.matchCache = new HashMap<Text, Boolean>();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        HasAuthorizationFilter filter = (HasAuthorizationFilter)super.deepCopy(env);
        filter.authorizationToMatch = this.authorizationToMatch;
        filter.filters = this.filters;
        filter.matchCache = new HashMap<Text, Boolean>();
        return filter;
    }

    public boolean accept(Key k, Value v) {
        if (this.filters.contains((Object)ElementFilter.ELEMENT) && (k.getColumnFamily().equals((Object)EdgeIterator.CF_SIGNAL) || k.getColumnFamily().equals((Object)VertexIterator.CF_SIGNAL)) && this.isMatch(k)) {
            return true;
        }
        if (this.filters.contains((Object)ElementFilter.PROPERTY) && k.getColumnFamily().equals((Object)EdgeIterator.CF_PROPERTY) && this.isMatch(k)) {
            return true;
        }
        return this.filters.contains((Object)ElementFilter.PROPERTY_METADATA) && k.getColumnFamily().equals((Object)EdgeIterator.CF_PROPERTY_METADATA) && this.isMatch(k);
    }

    private boolean isMatch(Key k) {
        String[] parts;
        Text columnVisibilityText = k.getColumnVisibility();
        if (columnVisibilityText.getLength() == 0) {
            return false;
        }
        Boolean match = this.matchCache.get(columnVisibilityText);
        if (match != null) {
            return match;
        }
        for (String part : parts = SPLIT_PATTERN.split(k.getColumnVisibilityParsed().toString())) {
            if (!part.equals(this.authorizationToMatch)) continue;
            this.matchCache.put(columnVisibilityText, true);
            return true;
        }
        this.matchCache.put(columnVisibilityText, false);
        return false;
    }
}

