/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.util.ArrayList;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;
import org.vertexium.accumulo.iterator.model.VertexiumInvalidKeyException;

public abstract class KeyBase {
    public static final char VALUE_SEPARATOR = '\u001f';

    public static String[] splitOnValueSeparator(String s) {
        ArrayList<String> results = new ArrayList<String>();
        int last = 0;
        int i = s.indexOf(31);
        while (i > 0) {
            results.add(s.substring(last, i));
            last = i + 1;
            i = s.indexOf(31, last);
        }
        results.add(s.substring(last));
        return results.toArray(new String[results.size()]);
    }

    public static String[] splitOnValueSeparator(String s, int partCount) {
        String[] results = new String[partCount];
        int last = 0;
        int i = s.indexOf(31);
        int partIndex = 0;
        while (i > 0) {
            results[partIndex++] = s.substring(last, i);
            if (partIndex >= partCount) {
                throw new VertexiumAccumuloIteratorException("Invalid number of parts for '" + s + "'. Expected " + partCount + " found " + partIndex);
            }
            last = i + 1;
            i = s.indexOf(31, last);
        }
        results[partIndex++] = s.substring(last);
        if (partIndex != partCount) {
            throw new VertexiumAccumuloIteratorException("Invalid number of parts for '" + s + "'. Expected " + partCount + " found " + partIndex);
        }
        return results;
    }

    public static void assertNoValueSeparator(String str) {
        if (str.indexOf(31) >= 0) {
            throw new VertexiumInvalidKeyException("String cannot contain '\u001f' (0x1f): " + str);
        }
    }
}

