/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.RowDeletingIterator;
import org.apache.accumulo.core.iterators.user.RowEncodingIterator;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.iterator.model.HiddenProperty;
import org.vertexium.accumulo.iterator.model.IteratorFetchHints;
import org.vertexium.accumulo.iterator.model.IteratorMetadataEntry;
import org.vertexium.accumulo.iterator.model.PropertyColumnQualifier;
import org.vertexium.accumulo.iterator.model.PropertyHiddenColumnQualifier;
import org.vertexium.accumulo.iterator.model.PropertyMetadataColumnQualifier;
import org.vertexium.accumulo.iterator.model.SoftDeletedProperty;

public abstract class ElementIterator<T extends ElementData>
extends RowEncodingIterator {
    public static final String CF_PROPERTY_STRING = "PROP";
    public static final Text CF_PROPERTY = new Text("PROP");
    public static final String CF_PROPERTY_HIDDEN_STRING = "PROPH";
    public static final Text CF_PROPERTY_HIDDEN = new Text("PROPH");
    public static final String CF_PROPERTY_SOFT_DELETE_STRING = "PROPD";
    public static final Text CF_PROPERTY_SOFT_DELETE = new Text("PROPD");
    public static final String CF_PROPERTY_METADATA_STRING = "PROPMETA";
    public static final Text CF_PROPERTY_METADATA = new Text("PROPMETA");
    public static final String CF_HIDDEN_STRING = "H";
    public static final Text CF_HIDDEN = new Text("H");
    public static final Text CQ_HIDDEN = new Text("H");
    public static final String CF_SOFT_DELETE_STRING = "D";
    public static final Text CF_SOFT_DELETE = new Text("D");
    public static final Text CQ_SOFT_DELETE = new Text("D");
    public static final String CF_EXTENDED_DATA_STRING = "EXTDATA";
    public static final Text CF_EXTENDED_DATA = new Text("EXTDATA");
    public static final Value HIDDEN_VALUE = new Value("".getBytes());
    public static final Value HIDDEN_VALUE_DELETED = new Value("X".getBytes());
    public static final Value SOFT_DELETE_VALUE = new Value("".getBytes());
    public static final String DELETE_ROW_COLUMN_FAMILY_STRING = "";
    public static final Text DELETE_ROW_COLUMN_FAMILY = new Text("");
    public static final String DELETE_ROW_COLUMN_QUALIFIER_STRING = "";
    public static final Text DELETE_ROW_COLUMN_QUALIFIER = new Text("");
    public static final String METADATA_COLUMN_FAMILY_STRING = "";
    public static final Text METADATA_COLUMN_FAMILY = new Text("");
    public static final String METADATA_COLUMN_QUALIFIER_STRING = "";
    public static final Text METADATA_COLUMN_QUALIFIER = new Text("");
    private static final String SETTING_FETCH_HINTS_PREFIX = "fetchHints.";
    private static final String RECORD_SEPARATOR = "\u001f";
    private static final Pattern RECORD_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("\u001f"));
    private IteratorFetchHints fetchHints;
    private T elementData;

    public ElementIterator(SortedKeyValueIterator<Key, Value> source, IteratorFetchHints fetchHints) {
        this.sourceIter = source;
        this.fetchHints = fetchHints;
        this.elementData = this.createElementData();
    }

    public SortedMap<Key, Value> rowDecoder(Key rowKey, Value rowValue) throws IOException {
        throw new IOException("Not implemented");
    }

    protected final boolean filter(Text currentRow, List<Key> keys, List<Value> values) {
        return this.populateElementData(keys, values);
    }

    protected boolean populateElementData(List<Key> keys, List<Value> values) {
        ((ElementData)this.elementData).clear();
        Text columnFamily = new Text();
        for (int i = 0; i < keys.size(); ++i) {
            Key key = keys.get(i);
            Value value = values.get(i);
            key.getColumnFamily(columnFamily);
            if (this.processKeyValue(key, columnFamily, value)) continue;
            return false;
        }
        if (((ElementData)this.elementData).visibility == null) {
            return false;
        }
        return ((ElementData)this.elementData).softDeleteTimestamp < ((ElementData)this.elementData).timestamp;
    }

    public final Value rowEncoder(List<Key> keys, List<Value> values) throws IOException {
        return ((ElementData)this.elementData).encode(this.fetchHints);
    }

    private boolean processKeyValue(Key key, Text columnFamily, Value value) {
        if (((ElementData)this.elementData).id == null) {
            ((ElementData)this.elementData).id = key.getRow();
        }
        if (CF_PROPERTY_METADATA.equals((Object)columnFamily)) {
            this.extractPropertyMetadata(key.getColumnQualifier(), key.getColumnVisibility(), key.getTimestamp(), value);
            return true;
        }
        if (CF_PROPERTY.equals((Object)columnFamily)) {
            this.extractPropertyData(key, value);
            return true;
        }
        if (CF_EXTENDED_DATA.equals((Object)columnFamily)) {
            ((ElementData)this.elementData).extendedTableNames.add(value.toString());
            return true;
        }
        if (this.getVisibilitySignal().equals((Object)columnFamily) && key.getTimestamp() > ((ElementData)this.elementData).timestamp) {
            ((ElementData)this.elementData).visibility = key.getColumnVisibility();
            ((ElementData)this.elementData).timestamp = key.getTimestamp();
            this.processSignalColumn(key.getColumnQualifier());
            return true;
        }
        if (this.processColumn(key, value, columnFamily, key.getColumnQualifier())) {
            return true;
        }
        if (DELETE_ROW_COLUMN_FAMILY.equals((Object)columnFamily) && DELETE_ROW_COLUMN_QUALIFIER.equals((Object)key.getColumnQualifier()) && RowDeletingIterator.DELETE_ROW_VALUE.equals((Object)value)) {
            return false;
        }
        if (CF_SOFT_DELETE.equals((Object)columnFamily) && CQ_SOFT_DELETE.equals((Object)key.getColumnQualifier()) && SOFT_DELETE_VALUE.equals((Object)value)) {
            ((ElementData)this.elementData).softDeleteTimestamp = key.getTimestamp();
            return true;
        }
        if (CF_PROPERTY_SOFT_DELETE.equals((Object)columnFamily)) {
            this.extractPropertySoftDelete(key.getColumnQualifier(), key.getTimestamp(), key.getColumnVisibility());
            return true;
        }
        if (CF_HIDDEN.equals((Object)columnFamily)) {
            if (this.fetchHints.isIncludeHidden()) {
                ((ElementData)this.elementData).hiddenVisibilities.add(key.getColumnVisibility());
                return true;
            }
            return false;
        }
        if (CF_PROPERTY_HIDDEN.equals((Object)columnFamily)) {
            this.extractPropertyHidden(key.getColumnQualifier(), key.getColumnVisibility(), value);
            return true;
        }
        return true;
    }

    protected abstract boolean processColumn(Key var1, Value var2, Text var3, Text var4);

    protected void processSignalColumn(Text columnQualifier) {
    }

    public T getElementData() {
        return this.elementData;
    }

    protected abstract Text getVisibilitySignal();

    private void extractPropertySoftDelete(Text columnQualifier, long timestamp, Text columnVisibility) {
        PropertyColumnQualifier propertyColumnQualifier = new PropertyColumnQualifier(columnQualifier);
        SoftDeletedProperty softDeletedProperty = new SoftDeletedProperty(propertyColumnQualifier.getPropertyKey(), propertyColumnQualifier.getPropertyName(), timestamp, columnVisibility);
        ((ElementData)this.elementData).softDeletedProperties.add(softDeletedProperty);
    }

    private void extractPropertyMetadata(Text columnQualifier, Text columnVisibility, long timestamp, Value value) {
        PropertyMetadataColumnQualifier propertyMetadataColumnQualifier = new PropertyMetadataColumnQualifier(columnQualifier);
        if (this.shouldIncludeMetadata(propertyMetadataColumnQualifier)) {
            String discriminator = propertyMetadataColumnQualifier.getPropertyDiscriminator(timestamp);
            List propertyMetadata = ((ElementData)this.elementData).propertyMetadata.computeIfAbsent(discriminator, k -> new ArrayList());
            IteratorMetadataEntry pme = new IteratorMetadataEntry(propertyMetadataColumnQualifier.getMetadataKey(), columnVisibility.toString(), value.get());
            int pos = ((ElementData)this.elementData).metadataEntries.indexOf(pme);
            if (pos < 0) {
                pos = ((ElementData)this.elementData).metadataEntries.size();
                ((ElementData)this.elementData).metadataEntries.add(pme);
            }
            propertyMetadata.add(pos);
        }
    }

    private void extractPropertyHidden(Text columnQualifier, Text columnVisibility, Value value) {
        if (value.equals((Object)HIDDEN_VALUE_DELETED)) {
            return;
        }
        PropertyHiddenColumnQualifier propertyHiddenColumnQualifier = new PropertyHiddenColumnQualifier(columnQualifier);
        HiddenProperty hiddenProperty = new HiddenProperty(propertyHiddenColumnQualifier.getPropertyKey(), propertyHiddenColumnQualifier.getPropertyName(), propertyHiddenColumnQualifier.getPropertyVisibilityString(), columnVisibility);
        ((ElementData)this.elementData).hiddenProperties.add(hiddenProperty);
    }

    private void extractPropertyData(Key key, Value value) {
        PropertyColumnQualifier propertyColumnQualifier = new PropertyColumnQualifier(key.getColumnQualifier());
        String mapKey = propertyColumnQualifier.getDiscriminator(key.getColumnVisibility().toString(), key.getTimestamp());
        long timestamp = key.getTimestamp();
        if (this.shouldIncludeProperty(propertyColumnQualifier.getPropertyName())) {
            ((ElementData)this.elementData).propertyColumnQualifiers.put(mapKey, propertyColumnQualifier);
            ((ElementData)this.elementData).propertyValues.put(mapKey, value.get());
            ((ElementData)this.elementData).propertyVisibilities.put(mapKey, key.getColumnVisibility());
            ((ElementData)this.elementData).propertyTimestamps.put(mapKey, timestamp);
        }
    }

    private boolean shouldIncludeProperty(String propertyName) {
        if (this.fetchHints.isIncludeAllProperties()) {
            return true;
        }
        return this.fetchHints.getPropertyNamesToInclude() != null && this.fetchHints.getPropertyNamesToInclude().contains(propertyName);
    }

    private boolean shouldIncludeMetadata(PropertyMetadataColumnQualifier propertyMetadataColumnQualifier) {
        if (!this.shouldIncludeProperty(propertyMetadataColumnQualifier.getPropertyName())) {
            return false;
        }
        if (this.fetchHints.isIncludeAllPropertyMetadata()) {
            return true;
        }
        String metadataKey = propertyMetadataColumnQualifier.getMetadataKey();
        return this.fetchHints.getMetadataKeysToInclude() != null && this.fetchHints.getMetadataKeysToInclude().contains(metadataKey);
    }

    public abstract SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment var1);

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.fetchHints = new IteratorFetchHints(Boolean.parseBoolean(options.get("fetchHints.includeAllProperties")), this.parseSet(options.get("fetchHints.propertyNamesToInclude")), Boolean.parseBoolean(options.get("fetchHints.includeAllPropertyMetadata")), this.parseSet(options.get("fetchHints.metadataKeysToInclude")), Boolean.parseBoolean(options.get("fetchHints.includeHidden")), Boolean.parseBoolean(options.get("fetchHints.includeAllEdgeRefs")), Boolean.parseBoolean(options.get("fetchHints.includeOutEdgeRefs")), Boolean.parseBoolean(options.get("fetchHints.includeInEdgeRefs")), this.parseSet(options.get("fetchHints.edgeLabelsOfEdgeRefsToInclude")), Boolean.parseBoolean(options.get("fetchHints.includeEdgeLabelsAndCounts")), Boolean.parseBoolean(options.get("fetchHints.includeExtendedDataTableNames")));
        this.elementData = this.createElementData();
    }

    protected abstract T createElementData();

    public static void setFetchHints(IteratorSetting iteratorSettings, IteratorFetchHints fetchHints) {
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeAllProperties", Boolean.toString(fetchHints.isIncludeAllProperties()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.propertyNamesToInclude", ElementIterator.setToString(fetchHints.getPropertyNamesToInclude()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeAllPropertyMetadata", Boolean.toString(fetchHints.isIncludeAllPropertyMetadata()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.metadataKeysToInclude", ElementIterator.setToString(fetchHints.getMetadataKeysToInclude()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeHidden", Boolean.toString(fetchHints.isIncludeHidden()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeAllEdgeRefs", Boolean.toString(fetchHints.isIncludeAllEdgeRefs()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeOutEdgeRefs", Boolean.toString(fetchHints.isIncludeOutEdgeRefs()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeInEdgeRefs", Boolean.toString(fetchHints.isIncludeInEdgeRefs()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.edgeLabelsOfEdgeRefsToInclude", ElementIterator.setToString(fetchHints.getEdgeLabelsOfEdgeRefsToInclude()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeEdgeLabelsAndCounts", Boolean.toString(fetchHints.isIncludeEdgeLabelsAndCounts()));
        ElementIterator.addOption(iteratorSettings, "fetchHints.includeExtendedDataTableNames", Boolean.toString(fetchHints.isIncludeExtendedDataTableNames()));
    }

    private static void addOption(IteratorSetting iteratorSettings, String key, String value) {
        if (value == null) {
            return;
        }
        iteratorSettings.addOption(key, value);
    }

    private Set<String> parseSet(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = RECORD_SEPARATOR_PATTERN.split(str);
        HashSet<String> results = new HashSet<String>();
        Collections.addAll(results, parts);
        return results;
    }

    public static String setToString(Set<String> set) {
        if (set == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : set) {
            if (!first) {
                sb.append(RECORD_SEPARATOR);
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    public IteratorFetchHints getFetchHints() {
        return this.fetchHints;
    }

    public T createElementDataFromRows(Iterator<Map.Entry<Key, Value>> rows) {
        ArrayList<Key> keys = new ArrayList<Key>();
        ArrayList<Value> values = new ArrayList<Value>();
        while (rows.hasNext()) {
            Map.Entry<Key, Value> row = rows.next();
            keys.add(row.getKey());
            values.add(row.getValue());
        }
        if (this.populateElementData(keys, values)) {
            return this.getElementData();
        }
        return null;
    }
}

