/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.accumulo.core.data.Value;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;

public class EdgeInfo {
    public static final String CHARSET_NAME = "UTF-8";
    private byte[] bytes;
    private transient long timestamp;
    private transient String label;
    private transient String vertexId;
    private transient boolean decoded;

    protected EdgeInfo() {
    }

    public EdgeInfo(String label, String vertexId) {
        this(label, vertexId, System.currentTimeMillis());
    }

    public EdgeInfo(String label, String vertexId, long timestamp) {
        if (label == null) {
            throw new IllegalArgumentException("label cannot be null");
        }
        if (vertexId == null) {
            throw new IllegalArgumentException("vertexId cannot be null");
        }
        this.label = label;
        this.vertexId = vertexId;
        this.timestamp = timestamp;
        this.decoded = true;
    }

    public EdgeInfo(byte[] bytes, long timestamp) {
        this.timestamp = timestamp;
        this.bytes = bytes;
    }

    public String getLabel() {
        this.decodeBytes();
        return this.label;
    }

    public String getVertexId() {
        this.decodeBytes();
        return this.vertexId;
    }

    public static String getVertexId(Value value) {
        byte[] buffer = value.get();
        int offset = 0;
        int strLen = EdgeInfo.readInt(buffer, offset);
        offset += 4;
        if (strLen > 0) {
            offset += strLen;
        }
        strLen = EdgeInfo.readInt(buffer, offset);
        return EdgeInfo.readString(buffer, offset, strLen);
    }

    private void decodeBytes() {
        if (!this.decoded) {
            int offset = 0;
            int strLen = EdgeInfo.readInt(this.bytes, offset);
            this.label = EdgeInfo.readString(this.bytes, offset += 4, strLen);
            offset += strLen;
            strLen = EdgeInfo.readInt(this.bytes, offset);
            this.vertexId = EdgeInfo.readString(this.bytes, offset += 4, strLen);
            this.decoded = true;
        }
    }

    public byte[] getLabelBytes() {
        int labelBytesLength = EdgeInfo.readInt(this.bytes, 0);
        return Arrays.copyOfRange(this.bytes, 4, 4 + labelBytesLength);
    }

    public static EdgeInfo parse(Value value, long timestamp) {
        return new EdgeInfo(value.get(), timestamp);
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                byte[] labelBytes = this.label.getBytes(CHARSET_NAME);
                int labelBytesLength = labelBytes.length;
                byte[] vertexIdBytes = this.vertexId.getBytes(CHARSET_NAME);
                int vertexIdBytesLength = vertexIdBytes.length;
                int len = 4 + labelBytesLength + 4 + vertexIdBytesLength;
                byte[] buffer = new byte[len];
                int offset = 0;
                this.writeInt(labelBytesLength, buffer, offset);
                offset += 4;
                if (labelBytes != null) {
                    System.arraycopy(labelBytes, 0, buffer, offset, labelBytesLength);
                    offset += labelBytesLength;
                }
                this.writeInt(vertexIdBytesLength, buffer, offset);
                offset += 4;
                if (vertexIdBytes != null) {
                    System.arraycopy(vertexIdBytes, 0, buffer, offset, vertexIdBytesLength);
                }
                this.bytes = buffer;
            }
            catch (UnsupportedEncodingException ex) {
                throw new VertexiumAccumuloIteratorException("Could not encode edge info", ex);
            }
        }
        return this.bytes;
    }

    private void writeInt(int value, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(value >> 24 & 0xFF);
        buffer[offset++] = (byte)(value >> 16 & 0xFF);
        buffer[offset++] = (byte)(value >> 8 & 0xFF);
        buffer[offset] = (byte)(value & 0xFF);
    }

    private static int readInt(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    private static String readString(byte[] buffer, int offset, int length) {
        byte[] d = new byte[length];
        System.arraycopy(buffer, offset, d, 0, length);
        try {
            return new String(d, CHARSET_NAME);
        }
        catch (IOException ex) {
            throw new VertexiumAccumuloIteratorException("Could not decode edge info", ex);
        }
    }

    public Value toValue() {
        return new Value(this.getBytes());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "EdgeInfo{vertexId='" + this.vertexId + '\'' + ", label='" + this.label + '\'' + '}';
    }
}

