/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.Edges;

public class EdgesWithEdgeInfo
extends Edges {
    private List<Map.Entry<Text, EdgeInfo>> pairs = new ArrayList<Map.Entry<Text, EdgeInfo>>();

    public void add(Text edgeId, EdgeInfo edgeInfo) {
        this.pairs.add(new Pair(edgeId, edgeInfo));
    }

    public void add(String edgeId, EdgeInfo edgeInfo) {
        this.add(new Text(edgeId), edgeInfo);
    }

    public void remove(Text edgeId) {
        int i = this.indexOf(edgeId);
        if (i >= 0) {
            this.pairs.remove(i);
        }
    }

    private int indexOf(Text edgeId) {
        for (int i = 0; i < this.pairs.size(); ++i) {
            if (!this.pairs.get(i).getKey().equals((Object)edgeId)) continue;
            return i;
        }
        return -1;
    }

    public void remove(String edgeId) {
        this.remove(new Text(edgeId));
    }

    public void clear() {
        this.pairs.clear();
    }

    public EdgeInfo get(Text edgeId) {
        int i = this.indexOf(edgeId);
        if (i >= 0) {
            return this.pairs.get(i).getValue();
        }
        return null;
    }

    public Iterable<EdgeInfo> getEdgeInfos() {
        return new Iterable<EdgeInfo>(){

            @Override
            public Iterator<EdgeInfo> iterator() {
                final Iterator it = EdgesWithEdgeInfo.this.pairs.iterator();
                return new Iterator<EdgeInfo>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public EdgeInfo next() {
                        return (EdgeInfo)((Map.Entry)it.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("not supported");
                    }
                };
            }
        };
    }

    public Iterable<Map.Entry<Text, EdgeInfo>> getEntries() {
        return this.pairs;
    }

    private static class Pair
    implements Map.Entry<Text, EdgeInfo> {
        private final Text edgeId;
        private final EdgeInfo edgeInfo;

        public Pair(Text edgeId, EdgeInfo edgeInfo) {
            this.edgeId = edgeId;
            this.edgeInfo = edgeInfo;
        }

        @Override
        public Text getKey() {
            return this.edgeId;
        }

        @Override
        public EdgeInfo getValue() {
            return this.edgeInfo;
        }

        @Override
        public EdgeInfo setValue(EdgeInfo value) {
            throw new RuntimeException("not supported");
        }
    }
}

