/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.HiddenProperty;
import org.vertexium.accumulo.iterator.model.IteratorFetchHints;
import org.vertexium.accumulo.iterator.model.IteratorMetadataEntry;
import org.vertexium.accumulo.iterator.model.Property;
import org.vertexium.accumulo.iterator.model.PropertyColumnQualifier;
import org.vertexium.accumulo.iterator.model.SoftDeletedProperty;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;
import org.vertexium.accumulo.iterator.util.DataOutputStreamUtils;

public abstract class ElementData {
    public static final byte[] HEADER = new byte[]{86, 69, 82, 84, 49};
    public static final byte TYPE_ID_VERTEX = 1;
    public static final byte TYPE_ID_EDGE = 2;
    public static final int PROP_START = 1;
    public static final int PROP_END = 2;
    public static final int METADATA_START = 3;
    public static final int METADATA_END = 4;
    public Text id;
    public long timestamp;
    public Text visibility;
    public final List<Text> hiddenVisibilities = new ArrayList<Text>();
    public long softDeleteTimestamp;
    public final List<SoftDeletedProperty> softDeletedProperties = new ArrayList<SoftDeletedProperty>();
    public final List<HiddenProperty> hiddenProperties = new ArrayList<HiddenProperty>();
    public final List<IteratorMetadataEntry> metadataEntries = new ArrayList<IteratorMetadataEntry>();
    public final Map<String, List<Integer>> propertyMetadata = new HashMap<String, List<Integer>>();
    public final Map<String, PropertyColumnQualifier> propertyColumnQualifiers = new HashMap<String, PropertyColumnQualifier>();
    public final Map<String, byte[]> propertyValues = new HashMap<String, byte[]>();
    public final Map<String, Text> propertyVisibilities = new HashMap<String, Text>();
    public final Map<String, Long> propertyTimestamps = new HashMap<String, Long>();
    public final Set<String> extendedTableNames = new HashSet<String>();

    public void clear() {
        this.id = null;
        this.visibility = null;
        this.timestamp = 0L;
        this.softDeleteTimestamp = 0L;
        this.hiddenVisibilities.clear();
        this.softDeletedProperties.clear();
        this.hiddenProperties.clear();
        this.metadataEntries.clear();
        this.propertyMetadata.clear();
        this.propertyColumnQualifiers.clear();
        this.propertyValues.clear();
        this.propertyVisibilities.clear();
        this.propertyTimestamps.clear();
        this.extendedTableNames.clear();
    }

    public final Value encode(IteratorFetchHints fetchHints) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        this.encode(dout, fetchHints);
        return new Value(out.toByteArray());
    }

    protected void encode(DataOutputStream out, IteratorFetchHints fetchHints) throws IOException {
        this.encodeHeader(out);
        DataOutputStreamUtils.encodeText(out, this.id);
        out.writeLong(this.timestamp);
        DataOutputStreamUtils.encodeText(out, this.visibility);
        DataOutputStreamUtils.encodeTextList(out, this.hiddenVisibilities);
        this.encodePropertyMetadataLookup(out);
        this.encodeProperties(out, fetchHints);
        DataOutputStreamUtils.encodeStringSet(out, this.extendedTableNames);
    }

    private void encodeHeader(DataOutputStream out) throws IOException {
        out.write(HEADER);
        out.write(this.getTypeId());
    }

    protected abstract byte getTypeId();

    private void encodePropertyMetadataLookup(DataOutputStream out) throws IOException {
        out.write(3);
        DataOutputStreamUtils.encodePropertyMetadataEntry(out, this.metadataEntries);
        out.write(4);
    }

    private void encodeProperties(DataOutputStream out, IteratorFetchHints fetchHints) throws IOException {
        this.iterateProperties((propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata) -> {
            out.write(1);
            DataOutputStreamUtils.encodeString(out, propertyKey);
            DataOutputStreamUtils.encodeString(out, propertyName);
            DataOutputStreamUtils.encodeText(out, propertyVisibility);
            out.writeLong(propertyTimestamp);
            out.writeInt(propertyValue.length);
            out.write(propertyValue);
            DataOutputStreamUtils.encodeTextList(out, propertyHiddenVisibilities);
            DataOutputStreamUtils.encodeIntArray(out, metadata);
        }, fetchHints);
        out.write(2);
    }

    private void iterateProperties(PropertyDataHandler propertyDataHandler, IteratorFetchHints fetchHints) throws IOException {
        boolean includeHidden = fetchHints.isIncludeHidden();
        for (Map.Entry<String, byte[]> propertyValueEntry : this.propertyValues.entrySet()) {
            String key = propertyValueEntry.getKey();
            PropertyColumnQualifier propertyColumnQualifier = this.propertyColumnQualifiers.get(key);
            String propertyKey = propertyColumnQualifier.getPropertyKey();
            String propertyName = propertyColumnQualifier.getPropertyName();
            byte[] propertyValue = propertyValueEntry.getValue();
            Text propertyVisibility = this.propertyVisibilities.get(key);
            String propertyVisibilityString = propertyVisibility.toString();
            long propertyTimestamp = this.propertyTimestamps.get(key);
            if (propertyTimestamp < this.softDeleteTimestamp) continue;
            Set<Text> propertyHiddenVisibilities = this.getPropertyHiddenVisibilities(propertyKey, propertyName, propertyVisibilityString);
            if (!includeHidden && this.isHidden(propertyKey, propertyName, propertyVisibilityString) || this.isPropertyDeleted(propertyKey, propertyName, propertyTimestamp, propertyVisibility)) continue;
            List<Integer> metadata = this.propertyMetadata.get(key);
            propertyDataHandler.handle(propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata);
        }
    }

    public Iterable<Property> getProperties(IteratorFetchHints fetchHints) {
        ArrayList<Property> results = new ArrayList<Property>();
        try {
            this.iterateProperties((propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata) -> results.add(new Property(propertyKey, propertyName, propertyValue, propertyVisibility.toString(), propertyTimestamp, propertyHiddenVisibilities, metadata)), fetchHints);
        }
        catch (IOException ex) {
            throw new VertexiumAccumuloIteratorException("Could not get properties", ex);
        }
        return results;
    }

    private Set<Text> getPropertyHiddenVisibilities(String propertyKey, String propertyName, String propertyVisibility) {
        HashSet<Text> hiddenVisibilities = null;
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            if (hiddenVisibilities == null) {
                hiddenVisibilities = new HashSet<Text>();
            }
            hiddenVisibilities.add(hiddenProperty.getHiddenVisibility());
        }
        return hiddenVisibilities;
    }

    private boolean isHidden(String propertyKey, String propertyName, String propertyVisibility) {
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyDeleted(String propertyKey, String propertyName, long propertyTimestamp, Text propertyVisibility) {
        for (SoftDeletedProperty softDeletedProperty : this.softDeletedProperties) {
            if (!softDeletedProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return softDeletedProperty.getTimestamp() >= propertyTimestamp;
        }
        return false;
    }

    private static interface PropertyDataHandler {
        public void handle(String var1, String var2, byte[] var3, Text var4, long var5, Set<Text> var7, List<Integer> var8) throws IOException;
    }
}

