/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.vertexium.DateOnly;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilderBase;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumSerializer;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloElement;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloVertex;
import org.vertexium.accumulo.HdfsLargeDataStore;
import org.vertexium.accumulo.KeyValuePair;
import org.vertexium.accumulo.StreamingPropertyValueHdfsRef;
import org.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.keys.DataTableRowKey;
import org.vertexium.accumulo.keys.KeyHelper;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertyPropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.util.IncreasingTime;
import org.vertexium.util.LimitOutputStream;
import org.vertexium.util.Preconditions;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public abstract class ElementMutationBuilder {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElementMutationBuilder.class);
    public static final Text EMPTY_TEXT = new Text("");
    public static final Value EMPTY_VALUE = new Value("".getBytes());
    private final FileSystem fileSystem;
    private final VertexiumSerializer vertexiumSerializer;
    private final long maxStreamingPropertyValueTableDataSize;
    private final String dataDir;
    private static final Cache<String, Text> propertyMetadataColumnQualifierTextCache = CacheBuilder.newCache(String.class, Text.class).name(ElementMutationBuilder.class, "propertyMetadataColumnQualifierTextCache").maxSize(10000).build();

    protected ElementMutationBuilder(FileSystem fileSystem, VertexiumSerializer vertexiumSerializer, long maxStreamingPropertyValueTableDataSize, String dataDir) {
        this.fileSystem = fileSystem;
        this.vertexiumSerializer = vertexiumSerializer;
        this.maxStreamingPropertyValueTableDataSize = maxStreamingPropertyValueTableDataSize;
        this.dataDir = dataDir;
    }

    public void saveVertexBuilder(AccumuloGraph graph, VertexBuilder vertexBuilder, long timestamp) {
        Mutation m = this.createMutationForVertexBuilder(graph, vertexBuilder, timestamp);
        this.saveVertexMutation(m);
    }

    protected abstract void saveVertexMutation(Mutation var1);

    private Mutation createMutationForVertexBuilder(AccumuloGraph graph, VertexBuilder vertexBuilder, long timestamp) {
        String vertexRowKey = vertexBuilder.getVertexId();
        Mutation m = new Mutation((CharSequence)vertexRowKey);
        m.put(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, this.visibilityToAccumuloVisibility(vertexBuilder.getVisibility()), timestamp, EMPTY_VALUE);
        for (PropertyDeleteMutation propertyDeleteMutation : vertexBuilder.getPropertyDeletes()) {
            this.addPropertyDeleteToMutation(m, propertyDeleteMutation);
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : vertexBuilder.getPropertySoftDeletes()) {
            this.addPropertySoftDeleteToMutation(m, propertySoftDeleteMutation);
        }
        for (Property property : vertexBuilder.getProperties()) {
            this.addPropertyToMutation(graph, m, vertexRowKey, property);
        }
        return m;
    }

    public Iterable<KeyValuePair> getKeyValuePairsForVertex(AccumuloVertex vertex) {
        ArrayList<KeyValuePair> results = new ArrayList<KeyValuePair>();
        Text vertexRowKey = new Text(vertex.getId());
        results.add(new KeyValuePair(new Key(vertexRowKey, AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, this.visibilityToAccumuloVisibility(vertex.getVisibility()), vertex.getTimestamp()), EMPTY_VALUE));
        if (vertex.getPropertyDeleteMutations().iterator().hasNext()) {
            throw new VertexiumException("Cannot get key/value pairs for property deletions");
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : vertex.getPropertySoftDeleteMutations()) {
            this.addPropertySoftDeleteToKeyValuePairs(results, vertexRowKey, propertySoftDeleteMutation);
        }
        for (Property property : vertex.getProperties()) {
            this.addPropertyToKeyValuePairs(results, vertexRowKey, property);
        }
        return results;
    }

    public Iterable<KeyValuePair> getEdgeTableKeyValuePairsEdge(AccumuloEdge edge) {
        ArrayList<KeyValuePair> results = new ArrayList<KeyValuePair>();
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        Text edgeRowKey = new Text(edge.getId());
        String edgeLabel = edge.getLabel();
        if (edge.getNewEdgeLabel() != null) {
            throw new VertexiumException("Cannot get key/value pairs for label changes");
        }
        results.add(new KeyValuePair(new Key(edgeRowKey, AccumuloEdge.CF_SIGNAL, new Text(edgeLabel), edgeColumnVisibility, edge.getTimestamp()), EMPTY_VALUE));
        results.add(new KeyValuePair(new Key(edgeRowKey, AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), edgeColumnVisibility, edge.getTimestamp()), EMPTY_VALUE));
        results.add(new KeyValuePair(new Key(edgeRowKey, AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), edgeColumnVisibility, edge.getTimestamp()), EMPTY_VALUE));
        if (edge.getPropertyDeleteMutations().iterator().hasNext()) {
            throw new VertexiumException("Cannot get key/value pairs for property deletions");
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : edge.getPropertySoftDeleteMutations()) {
            this.addPropertySoftDeleteToKeyValuePairs(results, edgeRowKey, propertySoftDeleteMutation);
        }
        for (Property property : edge.getProperties()) {
            this.addPropertyToKeyValuePairs(results, edgeRowKey, property);
        }
        return results;
    }

    public Iterable<KeyValuePair> getVertexTableKeyValuePairsEdge(AccumuloEdge edge) {
        ArrayList<KeyValuePair> results = new ArrayList<KeyValuePair>();
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        String edgeLabel = edge.getNewEdgeLabel() != null ? edge.getNewEdgeLabel() : edge.getLabel();
        Text edgeIdText = new Text(edge.getId());
        long timestamp = edge.getTimestamp();
        Text vertexOutIdRowKey = new Text(edge.getVertexId(Direction.OUT));
        EdgeInfo edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), edge.getVertexId(Direction.IN));
        results.add(new KeyValuePair(new Key(vertexOutIdRowKey, AccumuloVertex.CF_OUT_EDGE, edgeIdText, edgeColumnVisibility, timestamp), edgeInfo.toValue()));
        Text vertexInIdRowKey = new Text(edge.getVertexId(Direction.IN));
        edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), edge.getVertexId(Direction.OUT));
        results.add(new KeyValuePair(new Key(vertexInIdRowKey, AccumuloVertex.CF_IN_EDGE, edgeIdText, edgeColumnVisibility, timestamp), edgeInfo.toValue()));
        return results;
    }

    private void addPropertyToKeyValuePairs(List<KeyValuePair> results, Text elementRowKey, Property property) {
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            throw new VertexiumException("StreamingPropertyValue are not supported");
        }
        if (propertyValue instanceof DateOnly) {
            propertyValue = ((DateOnly)propertyValue).getDate();
        }
        Value value = new Value(this.vertexiumSerializer.objectToBytes(propertyValue));
        results.add(new KeyValuePair(new Key(elementRowKey, AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility, property.getTimestamp()), value));
        this.addPropertyMetadataToKeyValuePairs(results, elementRowKey, property);
    }

    private void addPropertyMetadataToKeyValuePairs(List<KeyValuePair> results, Text vertexRowKey, Property property) {
        Metadata metadata = property.getMetadata();
        for (Metadata.Entry metadataItem : metadata.entrySet()) {
            this.addPropertyMetadataItemToKeyValuePairs(results, vertexRowKey, property, metadataItem);
        }
    }

    private void addPropertyMetadataItemToKeyValuePairs(List<KeyValuePair> results, Text vertexRowKey, Property property, Metadata.Entry metadataItem) {
        Text columnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataItem);
        ColumnVisibility metadataVisibility = this.visibilityToAccumuloVisibility(metadataItem.getVisibility());
        if (metadataItem.getValue() == null) {
            throw new VertexiumException("Property metadata deletes are not supported");
        }
        this.addPropertyMetadataItemAddToKeyValuePairs(results, vertexRowKey, columnQualifier, metadataVisibility, property.getTimestamp(), metadataItem.getValue());
    }

    private void addPropertyMetadataItemAddToKeyValuePairs(List<KeyValuePair> results, Text vertexRowKey, Text columnQualifier, ColumnVisibility metadataVisibility, long propertyTimestamp, Object value) {
        Value metadataValue = new Value(this.vertexiumSerializer.objectToBytes(value));
        results.add(new KeyValuePair(new Key(vertexRowKey, AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility, propertyTimestamp), metadataValue));
    }

    private void addPropertySoftDeleteToKeyValuePairs(List<KeyValuePair> results, Text elementRowKey, PropertySoftDeleteMutation propertySoftDeleteMutation) {
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(propertySoftDeleteMutation.getKey(), propertySoftDeleteMutation.getName(), this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(propertySoftDeleteMutation.getVisibility());
        results.add(new KeyValuePair(new Key(elementRowKey, AccumuloElement.CF_PROPERTY_SOFT_DELETE, columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis()), AccumuloElement.SOFT_DELETE_VALUE));
    }

    public void saveEdgeBuilder(AccumuloGraph graph, EdgeBuilderBase edgeBuilder, long timestamp) {
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edgeBuilder.getVisibility());
        Mutation m = this.createMutationForEdgeBuilder(graph, edgeBuilder, edgeColumnVisibility, timestamp);
        this.saveEdgeMutation(m);
        String edgeLabel = edgeBuilder.getNewEdgeLabel() != null ? edgeBuilder.getNewEdgeLabel() : edgeBuilder.getLabel();
        this.saveEdgeInfoOnVertex(edgeBuilder.getEdgeId(), edgeBuilder.getOutVertexId(), edgeBuilder.getInVertexId(), edgeLabel, edgeColumnVisibility);
    }

    private void saveEdgeInfoOnVertex(String edgeId, String outVertexId, String inVertexId, String edgeLabel, ColumnVisibility edgeColumnVisibility) {
        Text edgeIdText = new Text(edgeId);
        Mutation addEdgeToOutMutation = new Mutation((CharSequence)outVertexId);
        EdgeInfo edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), inVertexId);
        addEdgeToOutMutation.put(AccumuloVertex.CF_OUT_EDGE, edgeIdText, edgeColumnVisibility, edgeInfo.toValue());
        this.saveVertexMutation(addEdgeToOutMutation);
        Mutation addEdgeToInMutation = new Mutation((CharSequence)inVertexId);
        edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edgeLabel), outVertexId);
        addEdgeToInMutation.put(AccumuloVertex.CF_IN_EDGE, edgeIdText, edgeColumnVisibility, edgeInfo.toValue());
        this.saveVertexMutation(addEdgeToInMutation);
    }

    public void alterEdgeLabel(Edge edge, String newEdgeLabel) {
        ColumnVisibility edgeColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        Mutation m = this.createAlterEdgeLabelMutation(edge, newEdgeLabel, edgeColumnVisibility);
        this.saveEdgeMutation(m);
        this.saveEdgeInfoOnVertex(edge.getId(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), newEdgeLabel, edgeColumnVisibility);
    }

    private ColumnVisibility visibilityToAccumuloVisibility(Visibility visibility) {
        return new ColumnVisibility(visibility.getVisibilityString());
    }

    protected abstract void saveEdgeMutation(Mutation var1);

    private Mutation createMutationForEdgeBuilder(AccumuloGraph graph, EdgeBuilderBase edgeBuilder, ColumnVisibility edgeColumnVisibility, long timestamp) {
        String edgeRowKey = edgeBuilder.getEdgeId();
        Mutation m = new Mutation((CharSequence)edgeRowKey);
        String edgeLabel = edgeBuilder.getLabel();
        if (edgeBuilder.getNewEdgeLabel() != null) {
            edgeLabel = edgeBuilder.getNewEdgeLabel();
            m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edgeBuilder.getLabel()), edgeColumnVisibility, IncreasingTime.currentTimeMillis());
        }
        m.put(AccumuloEdge.CF_SIGNAL, new Text(edgeLabel), edgeColumnVisibility, timestamp, EMPTY_VALUE);
        m.put(AccumuloEdge.CF_OUT_VERTEX, new Text(edgeBuilder.getOutVertexId()), edgeColumnVisibility, timestamp, EMPTY_VALUE);
        m.put(AccumuloEdge.CF_IN_VERTEX, new Text(edgeBuilder.getInVertexId()), edgeColumnVisibility, timestamp, EMPTY_VALUE);
        for (PropertyDeleteMutation propertyDeleteMutation : edgeBuilder.getPropertyDeletes()) {
            this.addPropertyDeleteToMutation(m, propertyDeleteMutation);
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : edgeBuilder.getPropertySoftDeletes()) {
            this.addPropertySoftDeleteToMutation(m, propertySoftDeleteMutation);
        }
        for (Property property : edgeBuilder.getProperties()) {
            this.addPropertyToMutation(graph, m, edgeRowKey, property);
        }
        return m;
    }

    private Mutation createAlterEdgeLabelMutation(Edge edge, String newEdgeLabel, ColumnVisibility edgeColumnVisibility) {
        String edgeRowKey = edge.getId();
        Mutation m = new Mutation((CharSequence)edgeRowKey);
        m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), edgeColumnVisibility, IncreasingTime.currentTimeMillis());
        m.put(AccumuloEdge.CF_SIGNAL, new Text(newEdgeLabel), edgeColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        return m;
    }

    public boolean alterElementVisibility(Mutation m, AccumuloElement element, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(element.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        if (element instanceof AccumuloEdge) {
            AccumuloEdge edge = (AccumuloEdge)element;
            m.putDelete(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put(AccumuloEdge.CF_SIGNAL, new Text(edge.getLabel()), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
            m.putDelete(AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put(AccumuloEdge.CF_OUT_VERTEX, new Text(edge.getVertexId(Direction.OUT)), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
            m.putDelete(AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put(AccumuloEdge.CF_IN_VERTEX, new Text(edge.getVertexId(Direction.IN)), newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        } else if (element instanceof AccumuloVertex) {
            m.putDelete(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, currentColumnVisibility, IncreasingTime.currentTimeMillis());
            m.put(AccumuloVertex.CF_SIGNAL, EMPTY_TEXT, newColumnVisibility, IncreasingTime.currentTimeMillis(), EMPTY_VALUE);
        } else {
            throw new IllegalArgumentException("Invalid element type: " + element);
        }
        return true;
    }

    public boolean alterEdgeVertexOutVertex(Mutation vertexOutMutation, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        EdgeInfo edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edge.getLabel()), edge.getVertexId(Direction.IN));
        vertexOutMutation.putDelete(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), currentColumnVisibility);
        vertexOutMutation.put(AccumuloVertex.CF_OUT_EDGE, new Text(edge.getId()), newColumnVisibility, edgeInfo.toValue());
        return true;
    }

    public boolean alterEdgeVertexInVertex(Mutation vertexInMutation, Edge edge, Visibility newVisibility) {
        ColumnVisibility newColumnVisibility;
        ColumnVisibility currentColumnVisibility = this.visibilityToAccumuloVisibility(edge.getVisibility());
        if (currentColumnVisibility.equals(newColumnVisibility = this.visibilityToAccumuloVisibility(newVisibility))) {
            return false;
        }
        EdgeInfo edgeInfo = new EdgeInfo(this.getNameSubstitutionStrategy().deflate(edge.getLabel()), edge.getVertexId(Direction.OUT));
        vertexInMutation.putDelete(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), currentColumnVisibility);
        vertexInMutation.put(AccumuloVertex.CF_IN_EDGE, new Text(edge.getId()), newColumnVisibility, edgeInfo.toValue());
        return true;
    }

    public void addPropertyToMutation(AccumuloGraph graph, Mutation m, String rowKey, Property property) {
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            propertyValue = this.saveStreamingPropertyValue(rowKey, property, (StreamingPropertyValue)propertyValue);
        }
        if (propertyValue instanceof DateOnly) {
            propertyValue = ((DateOnly)propertyValue).getDate();
        }
        if (graph != null) {
            graph.ensurePropertyDefined(property.getName(), propertyValue);
        }
        Value value = new Value(this.vertexiumSerializer.objectToBytes(propertyValue));
        m.put(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility, property.getTimestamp(), value);
        this.addPropertyMetadataToMutation(m, property);
    }

    protected abstract NameSubstitutionStrategy getNameSubstitutionStrategy();

    public void addPropertyDeleteToMutation(Mutation m, PropertyDeleteMutation propertyDelete) {
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(propertyDelete.getKey(), propertyDelete.getName(), this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(propertyDelete.getVisibility());
        m.putDelete(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis());
        this.addPropertyDeleteMetadataToMutation(m, propertyDelete);
    }

    public void addPropertyMetadataToMutation(Mutation m, Property property) {
        Metadata metadata = property.getMetadata();
        for (Metadata.Entry metadataItem : metadata.entrySet()) {
            this.addPropertyMetadataItemToMutation(m, property, metadataItem);
        }
    }

    private void addPropertyMetadataItemToMutation(Mutation m, Property property, Metadata.Entry metadataItem) {
        Text columnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataItem);
        ColumnVisibility metadataVisibility = this.visibilityToAccumuloVisibility(metadataItem.getVisibility());
        if (metadataItem.getValue() == null) {
            this.addPropertyMetadataItemDeleteToMutation(m, columnQualifier, metadataVisibility);
        } else {
            this.addPropertyMetadataItemAddToMutation(m, columnQualifier, metadataVisibility, property.getTimestamp(), metadataItem.getValue());
        }
    }

    private void addPropertyMetadataItemAddToMutation(Mutation m, Text columnQualifier, ColumnVisibility metadataVisibility, long propertyTimestamp, Object value) {
        Value metadataValue = new Value(this.vertexiumSerializer.objectToBytes(value));
        m.put(AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility, propertyTimestamp, metadataValue);
    }

    private void addPropertyMetadataItemDeleteToMutation(Mutation m, Text columnQualifier, ColumnVisibility metadataVisibility) {
        m.putDelete(AccumuloElement.CF_PROPERTY_METADATA, columnQualifier, metadataVisibility, IncreasingTime.currentTimeMillis());
    }

    private Text getPropertyMetadataColumnQualifierText(Property property, Metadata.Entry metadataItem) {
        String propertyName = property.getName();
        String propertyKey = property.getKey();
        String visibilityString = property.getVisibility().getVisibilityString();
        String metadataKey = metadataItem.getKey();
        StringBuilder keyBuilder = new StringBuilder(propertyName.length() + propertyKey.length() + visibilityString.length() + metadataKey.length());
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(propertyName));
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(propertyKey));
        keyBuilder.append(visibilityString);
        keyBuilder.append(this.getNameSubstitutionStrategy().deflate(metadataKey));
        String key = keyBuilder.toString();
        Text r = (Text)propertyMetadataColumnQualifierTextCache.peek((Object)key);
        if (r == null) {
            r = KeyHelper.getColumnQualifierFromPropertyMetadataColumnQualifier(propertyName, propertyKey, visibilityString, metadataKey, this.getNameSubstitutionStrategy());
            propertyMetadataColumnQualifierTextCache.put((Object)key, (Object)r);
        }
        return r;
    }

    public void addPropertyDeleteMetadataToMutation(Mutation m, PropertyDeleteMutation propertyDeleteMutation) {
        if (propertyDeleteMutation instanceof PropertyPropertyDeleteMutation) {
            Property property = ((PropertyPropertyDeleteMutation)propertyDeleteMutation).getProperty();
            Metadata metadata = property.getMetadata();
            for (Metadata.Entry metadataItem : metadata.entrySet()) {
                Text columnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataItem);
                ColumnVisibility metadataVisibility = this.visibilityToAccumuloVisibility(metadataItem.getVisibility());
                this.addPropertyMetadataItemDeleteToMutation(m, columnQualifier, metadataVisibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamingPropertyValueRef saveStreamingPropertyValue(String rowKey, Property property, StreamingPropertyValue propertyValue) {
        try {
            HdfsLargeDataStore largeDataStore = new HdfsLargeDataStore(this.fileSystem, this.dataDir, rowKey, property);
            try (LimitOutputStream out = new LimitOutputStream((LimitOutputStream.LargeDataStore)largeDataStore, this.maxStreamingPropertyValueTableDataSize);){
                StreamUtils.copy((InputStream)propertyValue.getInputStream(), (OutputStream)out);
            }
            if (out.hasExceededSizeLimit()) {
                LOGGER.debug("saved large file to \"%s\" (length: %d)", new Object[]{largeDataStore.getFullHdfsPath(), out.getLength()});
                return new StreamingPropertyValueHdfsRef(largeDataStore.getRelativeFileName(), propertyValue);
            }
            return this.saveStreamingPropertyValueSmall(rowKey, property, out.getSmall(), propertyValue);
        }
        catch (IOException ex) {
            throw new VertexiumException((Exception)ex);
        }
    }

    public void addPropertyDeleteToMutation(Mutation m, Property property) {
        Preconditions.checkNotNull((Object)m, (Object)"mutation cannot be null");
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        m.putDelete(AccumuloElement.CF_PROPERTY, columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis());
        for (Metadata.Entry metadataEntry : property.getMetadata().entrySet()) {
            Text metadataEntryColumnQualifier = this.getPropertyMetadataColumnQualifierText(property, metadataEntry);
            ColumnVisibility metadataEntryVisibility = this.visibilityToAccumuloVisibility(metadataEntry.getVisibility());
            this.addPropertyMetadataItemDeleteToMutation(m, metadataEntryColumnQualifier, metadataEntryVisibility);
        }
    }

    public void addPropertySoftDeleteToMutation(Mutation m, Property property) {
        Preconditions.checkNotNull((Object)m, (Object)"mutation cannot be null");
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(property, this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(property.getVisibility());
        m.put(AccumuloElement.CF_PROPERTY_SOFT_DELETE, columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis(), AccumuloElement.SOFT_DELETE_VALUE);
    }

    public void addPropertySoftDeleteToMutation(Mutation m, PropertySoftDeleteMutation propertySoftDelete) {
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier(propertySoftDelete.getKey(), propertySoftDelete.getName(), this.getNameSubstitutionStrategy());
        ColumnVisibility columnVisibility = this.visibilityToAccumuloVisibility(propertySoftDelete.getVisibility());
        m.put(AccumuloElement.CF_PROPERTY_SOFT_DELETE, columnQualifier, columnVisibility, IncreasingTime.currentTimeMillis(), AccumuloElement.SOFT_DELETE_VALUE);
    }

    private StreamingPropertyValueRef saveStreamingPropertyValueSmall(String rowKey, Property property, byte[] data, StreamingPropertyValue propertyValue) {
        String dataTableRowKey = new DataTableRowKey(rowKey, property).getRowKey();
        Mutation dataMutation = new Mutation((CharSequence)dataTableRowKey);
        dataMutation.put(EMPTY_TEXT, EMPTY_TEXT, new Value(data));
        this.saveDataMutation(dataMutation);
        return new StreamingPropertyValueTableRef(dataTableRowKey, propertyValue, data);
    }

    protected abstract void saveDataMutation(Mutation var1);
}

