/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.VertexiumSerializer;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.LazyPropertyMetadata;
import org.vertexium.property.MutableProperty;
import org.vertexium.property.StreamingPropertyValueRef;

public class LazyMutableProperty
extends MutableProperty {
    private final AccumuloGraph graph;
    private final VertexiumSerializer vertexiumSerializer;
    private final String propertyKey;
    private final String propertyName;
    private long timestamp;
    private Set<Visibility> hiddenVisibilities;
    private byte[] propertyValue;
    private LazyPropertyMetadata metadata;
    private Visibility visibility;
    private transient Object cachedPropertyValue;
    private transient Metadata cachedMetadata;

    public LazyMutableProperty(AccumuloGraph graph, VertexiumSerializer vertexiumSerializer, String propertyKey, String propertyName, byte[] propertyValue, LazyPropertyMetadata metadata, Set<Visibility> hiddenVisibilities, Visibility visibility, long timestamp) {
        this.graph = graph;
        this.vertexiumSerializer = vertexiumSerializer;
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.metadata = metadata;
        this.visibility = visibility;
        this.hiddenVisibilities = hiddenVisibilities;
        this.timestamp = timestamp;
    }

    public void setValue(Object value) {
        this.cachedPropertyValue = value;
        this.propertyValue = null;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void addHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.add(visibility);
    }

    public void removeHiddenVisibility(Visibility visibility) {
        if (this.hiddenVisibilities == null) {
            this.hiddenVisibilities = new HashSet<Visibility>();
        }
        this.hiddenVisibilities.remove(visibility);
    }

    protected void updateMetadata(Property property) {
        this.cachedMetadata = null;
        if (property instanceof LazyMutableProperty) {
            this.metadata = ((LazyMutableProperty)property).metadata;
        } else {
            ArrayList entries = new ArrayList(property.getMetadata().entrySet());
            this.metadata = new LazyPropertyMetadata();
            for (Metadata.Entry metadataEntry : entries) {
                this.getMetadata().add(metadataEntry.getKey(), metadataEntry.getValue(), metadataEntry.getVisibility());
            }
        }
    }

    public String getKey() {
        return this.propertyKey;
    }

    public String getName() {
        return this.propertyName;
    }

    public Object getValue() {
        if (this.cachedPropertyValue == null) {
            if (this.propertyValue == null || this.propertyValue.length == 0) {
                return null;
            }
            this.cachedPropertyValue = this.vertexiumSerializer.bytesToObject(this.propertyValue);
            if (this.cachedPropertyValue instanceof StreamingPropertyValueRef) {
                this.cachedPropertyValue = ((StreamingPropertyValueRef)this.cachedPropertyValue).toStreamingPropertyValue((Graph)this.graph);
            }
        }
        return this.cachedPropertyValue;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public Metadata getMetadata() {
        if (this.cachedMetadata == null) {
            this.cachedMetadata = this.metadata == null ? new Metadata() : this.metadata.toMetadata(this.vertexiumSerializer, this.graph.getNameSubstitutionStrategy());
        }
        return this.cachedMetadata;
    }

    public Iterable<Visibility> getHiddenVisibilities() {
        if (this.hiddenVisibilities == null) {
            return new ArrayList<Visibility>();
        }
        return this.hiddenVisibilities;
    }

    public boolean isHidden(Authorizations authorizations) {
        if (this.hiddenVisibilities != null) {
            for (Visibility v : this.getHiddenVisibilities()) {
                if (!authorizations.canRead(v)) continue;
                return true;
            }
        }
        return false;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

