/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Range;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloAuthorizations;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloElement;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.accumulo.AccumuloResource;
import org.vertexium.accumulo.AccumuloVertex;
import org.vertexium.accumulo.EdgeBuilderWithKeyValuePairs;
import org.vertexium.accumulo.ElementMutationBuilder;
import org.vertexium.accumulo.KeyValuePair;
import org.vertexium.accumulo.StreamingPropertyValueTableRef;
import org.vertexium.accumulo.VertexBuilderWithKeyValuePairs;
import org.vertexium.accumulo.iterator.model.EdgeInfo;
import org.vertexium.accumulo.iterator.model.VertexiumInvalidKeyException;
import org.vertexium.accumulo.keys.DataTableRowKey;
import org.vertexium.accumulo.keys.KeyHelper;
import org.vertexium.accumulo.tools.DeleteHistoricalLegacyStreamingPropertyValueData;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.property.MutablePropertyImpl;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.test.GraphTestBase;
import org.vertexium.util.IterableUtils;

public abstract class AccumuloGraphTestBase
extends GraphTestBase {
    @Before
    public void before() throws Exception {
        this.getAccumuloResource().dropGraph();
        super.before();
    }

    protected Graph createGraph() throws AccumuloSecurityException, AccumuloException, VertexiumException, InterruptedException, IOException, URISyntaxException {
        return AccumuloGraph.create((AccumuloGraphConfiguration)new AccumuloGraphConfiguration(this.getAccumuloResource().createConfig()));
    }

    public abstract AccumuloResource getAccumuloResource();

    protected Authorizations createAuthorizations(String ... auths) {
        return new AccumuloAuthorizations(auths);
    }

    protected void addAuthorizations(String ... authorizations) {
        this.getAccumuloResource().addAuthorizations(this.getGraph(), authorizations);
    }

    protected boolean isFetchHintNoneVertexQuerySupported() {
        return false;
    }

    protected boolean isAdvancedGeoQuerySupported() {
        return false;
    }

    @Test
    public void testFilterHints() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        v1.addPropertyValue("k1", "n1", (Object)"value1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_A, this.AUTHORIZATIONS_A);
        Edge e1 = this.graph.addEdge("e1", v1, v2, "label1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        e1.addPropertyValue("k1", "n1", (Object)"value1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.addEdge("e2", v2, v1, "label1", VISIBILITY_A, this.AUTHORIZATIONS_A);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.NONE, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", EnumSet.of(FetchHint.PROPERTIES), this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", FetchHint.EDGE_REFS, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", EnumSet.of(FetchHint.IN_EDGE_REFS), this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        v1 = this.graph.getVertex("v1", EnumSet.of(FetchHint.OUT_EDGE_REFS), this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getProperties()));
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.IN, this.AUTHORIZATIONS_A)));
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)v1.getEdges(Direction.OUT, this.AUTHORIZATIONS_A)));
        e1 = this.graph.getEdge("e1", FetchHint.NONE, this.AUTHORIZATIONS_A);
        Assert.assertNotNull((Object)e1);
        Assert.assertEquals((long)0L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        Assert.assertEquals((Object)"v1", (Object)e1.getVertexId(Direction.OUT));
        Assert.assertEquals((Object)"v2", (Object)e1.getVertexId(Direction.IN));
        e1 = this.graph.getEdge("e1", this.graph.getDefaultFetchHints(), this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        Assert.assertEquals((Object)"v1", (Object)e1.getVertexId(Direction.OUT));
        Assert.assertEquals((Object)"v2", (Object)e1.getVertexId(Direction.IN));
        e1 = this.graph.getEdge("e1", EnumSet.of(FetchHint.PROPERTIES), this.AUTHORIZATIONS_A);
        Assert.assertEquals((long)1L, (long)IterableUtils.count((Iterable)e1.getProperties()));
        Assert.assertEquals((Object)"v1", (Object)e1.getVertexId(Direction.OUT));
        Assert.assertEquals((Object)"v2", (Object)e1.getVertexId(Direction.IN));
    }

    @Test
    public void testStoringEmptyMetadata() {
        Vertex v1 = this.graph.addVertex("v1", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        Metadata metadata = new Metadata();
        v1.addPropertyValue("prop1", "prop1", (Object)"val1", metadata, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        Vertex v2 = this.graph.addVertex("v2", VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        metadata = new Metadata();
        metadata.add("meta1", (Object)"metavalue1", VISIBILITY_EMPTY);
        v2.addPropertyValue("prop1", "prop1", (Object)"val1", metadata, VISIBILITY_EMPTY, this.AUTHORIZATIONS_A_AND_B);
        this.graph.flush();
        v1 = this.graph.getVertex("v1", FetchHint.ALL, this.AUTHORIZATIONS_EMPTY);
        Assert.assertEquals((long)0L, (long)v1.getProperty("prop1", "prop1").getMetadata().entrySet().size());
        v2 = this.graph.getVertex("v2", FetchHint.ALL, this.AUTHORIZATIONS_EMPTY);
        metadata = v2.getProperty("prop1", "prop1").getMetadata();
        Assert.assertEquals((long)1L, (long)metadata.entrySet().size());
        Assert.assertEquals((Object)"metavalue1", (Object)metadata.getEntry("meta1", VISIBILITY_EMPTY).getValue());
        AccumuloGraph accumuloGraph = (AccumuloGraph)this.graph;
        ScannerBase vertexScanner = accumuloGraph.createVertexScanner(this.graph.getDefaultFetchHints(), Integer.valueOf(1), null, null, new org.apache.accumulo.core.data.Range((CharSequence)"V", (CharSequence)"W"), this.AUTHORIZATIONS_EMPTY);
        RowIterator rows = new RowIterator(vertexScanner.iterator());
        while (rows.hasNext()) {
            Iterator row = rows.next();
            while (row.hasNext()) {
                Map.Entry col = (Map.Entry)row.next();
                if (!((Key)col.getKey()).getColumnFamily().equals((Object)AccumuloElement.CF_PROPERTY_METADATA)) continue;
                if (((Key)col.getKey()).getRow().toString().equals("Vv1")) {
                    Assert.assertEquals((Object)"", (Object)((Value)col.getValue()).toString());
                    continue;
                }
                if (((Key)col.getKey()).getRow().toString().equals("Vv2")) {
                    Assert.assertNotEquals((Object)"", (Object)((Value)col.getValue()).toString());
                    continue;
                }
                TestCase.fail((String)"invalid vertex");
            }
        }
    }

    @Test
    public void testGetKeyValuePairsForVertexMutation() {
        VertexBuilder m = this.graph.prepareVertex("v1", Long.valueOf(100L), VISIBILITY_A);
        Metadata metadata = new Metadata();
        metadata.add("key1_prop2_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key1_prop2_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key1", "author", (Object)"value_key1_author", metadata, Long.valueOf(400L), VISIBILITY_A_AND_B);
        metadata = new Metadata();
        metadata.add("key1_prop1_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key1_prop1_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key1", "prop1", (Object)"value_key1_prop1", metadata, Long.valueOf(200L), VISIBILITY_A);
        metadata = new Metadata();
        metadata.add("key2_prop1_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key2_prop1_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key2", "prop1", (Object)"value_key2_prop1", metadata, Long.valueOf(300L), VISIBILITY_B);
        List keyValuePairs = IterableUtils.toList((Iterable)((VertexBuilderWithKeyValuePairs)m).getKeyValuePairs());
        Collections.sort(keyValuePairs);
        Assert.assertEquals((long)10L, (long)keyValuePairs.size());
        String authorDeflated = this.substitutionDeflate("author");
        int i = 0;
        KeyValuePair pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY, new Text(authorDeflated + "\u001fkey1"), new Text("a&b"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key1_author"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY, new Text("prop1\u001fkey1"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key1_prop1"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY, new Text("prop1\u001fkey2"), new Text("b"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key2_prop1"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text(authorDeflated + "\u001fkey1\u001fa&b\u001fkey1_prop2_m1"), new Text("a"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text(authorDeflated + "\u001fkey1\u001fa&b\u001fkey1_prop2_m2"), new Text("a"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey1\u001fa\u001fkey1_prop1_m1"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey1\u001fa\u001fkey1_prop1_m2"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey2\u001fb\u001fkey2_prop1_m1"), new Text("a"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey2\u001fb\u001fkey2_prop1_m2"), new Text("a"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloVertex.CF_SIGNAL, ElementMutationBuilder.EMPTY_TEXT, new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)ElementMutationBuilder.EMPTY_VALUE, (Object)pair.getValue());
    }

    @Test
    public void testGetKeyValuePairsForEdgeMutation() {
        EdgeBuilderByVertexId m = this.graph.prepareEdge("e1", "v1", "v2", "label1", Long.valueOf(100L), VISIBILITY_A);
        Metadata metadata = new Metadata();
        metadata.add("key1_prop2_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key1_prop2_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key1", "author", (Object)"value_key1_author", metadata, Long.valueOf(400L), VISIBILITY_A_AND_B);
        metadata = new Metadata();
        metadata.add("key1_prop1_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key1_prop1_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key1", "prop1", (Object)"value_key1_prop1", metadata, Long.valueOf(200L), VISIBILITY_A);
        metadata = new Metadata();
        metadata.add("key2_prop1_m1", (Object)"m1_value", VISIBILITY_A);
        metadata.add("key2_prop1_m2", (Object)"m2_value", VISIBILITY_A);
        m.addPropertyValue("key2", "prop1", (Object)"value_key2_prop1", metadata, Long.valueOf(300L), VISIBILITY_B);
        List keyValuePairs = IterableUtils.toList((Iterable)((EdgeBuilderWithKeyValuePairs)m).getEdgeTableKeyValuePairs());
        Collections.sort(keyValuePairs);
        Assert.assertEquals((long)12L, (long)keyValuePairs.size());
        String authorDeflated = this.substitutionDeflate("author");
        int i = 0;
        KeyValuePair pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloEdge.CF_SIGNAL, new Text("label1"), new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)ElementMutationBuilder.EMPTY_VALUE, (Object)pair.getValue());
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloEdge.CF_IN_VERTEX, new Text("v2"), new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)ElementMutationBuilder.EMPTY_VALUE, (Object)pair.getValue());
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloEdge.CF_OUT_VERTEX, new Text("v1"), new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)ElementMutationBuilder.EMPTY_VALUE, (Object)pair.getValue());
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY, new Text(authorDeflated + "\u001fkey1"), new Text("a&b"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key1_author"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY, new Text("prop1\u001fkey1"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key1_prop1"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY, new Text("prop1\u001fkey2"), new Text("b"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("value_key2_prop1"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text(authorDeflated + "\u001fkey1\u001fa&b\u001fkey1_prop2_m1"), new Text("a"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text(authorDeflated + "\u001fkey1\u001fa&b\u001fkey1_prop2_m2"), new Text("a"), 400L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey1\u001fa\u001fkey1_prop1_m1"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey1\u001fa\u001fkey1_prop1_m2"), new Text("a"), 200L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey2\u001fb\u001fkey2_prop1_m1"), new Text("a"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m1_value"));
        pair = (KeyValuePair)keyValuePairs.get(i++);
        Assert.assertEquals((Object)new Key(new Text("e1"), AccumuloElement.CF_PROPERTY_METADATA, new Text("prop1\u001fkey2\u001fb\u001fkey2_prop1_m2"), new Text("a"), 300L), (Object)pair.getKey());
        Assert.assertTrue((boolean)pair.getValue().toString().contains("m2_value"));
        i = 0;
        keyValuePairs = IterableUtils.toList((Iterable)((EdgeBuilderWithKeyValuePairs)m).getVertexTableKeyValuePairs());
        Collections.sort(keyValuePairs);
        Assert.assertEquals((long)2L, (long)keyValuePairs.size());
        pair = (KeyValuePair)keyValuePairs.get(i++);
        EdgeInfo edgeInfo = new EdgeInfo(this.getGraph().getNameSubstitutionStrategy().deflate("label1"), "v2");
        Assert.assertEquals((Object)new Key(new Text("v1"), AccumuloVertex.CF_OUT_EDGE, new Text("e1"), new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)edgeInfo.toValue(), (Object)pair.getValue());
        pair = (KeyValuePair)keyValuePairs.get(i++);
        edgeInfo = new EdgeInfo(this.getGraph().getNameSubstitutionStrategy().deflate("label1"), "v1");
        Assert.assertEquals((Object)new Key(new Text("v2"), AccumuloVertex.CF_IN_EDGE, new Text("e1"), new Text("a"), 100L), (Object)pair.getKey());
        Assert.assertEquals((Object)edgeInfo.toValue(), (Object)pair.getValue());
    }

    protected abstract String substitutionDeflate(String var1);

    @Test
    public void testPropertyWithValueSeparator() {
        try {
            this.graph.prepareVertex("v1", VISIBILITY_EMPTY).addPropertyValue("prop1\u001f", "name1", (Object)"test", VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
            throw new RuntimeException("Should have thrown a bad character exception");
        }
        catch (VertexiumInvalidKeyException vertexiumInvalidKeyException) {
            return;
        }
    }

    @Test
    public void testListSplits() throws AccumuloSecurityException, TableNotFoundException, AccumuloException {
        TreeSet<Text> keys = new TreeSet<Text>();
        keys.add(new Text("j"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getVerticesTableName(), keys);
        keys = new TreeSet();
        keys.add(new Text("k"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getEdgesTableName(), keys);
        keys = new TreeSet();
        keys.add(new Text("l"));
        this.getGraph().getConnector().tableOperations().addSplits(this.getGraph().getDataTableName(), keys);
        List verticesTableSplits = IterableUtils.toList((Iterable)this.getGraph().listVerticesTableSplits());
        Assert.assertEquals((long)2L, (long)verticesTableSplits.size());
        Assert.assertEquals(null, (Object)((Range)verticesTableSplits.get(0)).getInclusiveStart());
        Assert.assertEquals((Object)"j", (Object)((Range)verticesTableSplits.get(0)).getExclusiveEnd());
        Assert.assertEquals((Object)"j", (Object)((Range)verticesTableSplits.get(1)).getInclusiveStart());
        Assert.assertEquals(null, (Object)((Range)verticesTableSplits.get(1)).getExclusiveEnd());
        List edgesTableSplits = IterableUtils.toList((Iterable)this.getGraph().listEdgesTableSplits());
        Assert.assertEquals((long)2L, (long)edgesTableSplits.size());
        Assert.assertEquals(null, (Object)((Range)edgesTableSplits.get(0)).getInclusiveStart());
        Assert.assertEquals((Object)"k", (Object)((Range)edgesTableSplits.get(0)).getExclusiveEnd());
        Assert.assertEquals((Object)"k", (Object)((Range)edgesTableSplits.get(1)).getInclusiveStart());
        Assert.assertEquals(null, (Object)((Range)edgesTableSplits.get(1)).getExclusiveEnd());
        List dataTableSplits = IterableUtils.toList((Iterable)this.getGraph().listDataTableSplits());
        Assert.assertEquals((long)2L, (long)dataTableSplits.size());
        Assert.assertEquals(null, (Object)((Range)dataTableSplits.get(0)).getInclusiveStart());
        Assert.assertEquals((Object)"l", (Object)((Range)dataTableSplits.get(0)).getExclusiveEnd());
        Assert.assertEquals((Object)"l", (Object)((Range)dataTableSplits.get(1)).getInclusiveStart());
        Assert.assertEquals(null, (Object)((Range)dataTableSplits.get(1)).getExclusiveEnd());
    }

    @Test
    public void testLegacyStreamingPropertyValuesWithTimestampInRowKey() throws Exception {
        String vertexId = "v1";
        this.graph.prepareVertex(vertexId, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        long timestamp = new Date().getTime();
        String propertyKey = "k1";
        String propertyName = "prop1";
        String propertyValue = "Hello";
        this.addLegacySPVData(vertexId, timestamp, propertyKey, propertyName, propertyValue);
        this.getGraph().flush();
        Vertex v1 = this.graph.getVertex(vertexId, this.AUTHORIZATIONS_EMPTY);
        StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue(propertyKey, propertyName);
        Assert.assertNotNull((String)"spv should not be null", (Object)spv);
        Assert.assertEquals((Object)propertyValue, (Object)IOUtils.toString((InputStream)spv.getInputStream()));
    }

    @Test
    public void testDeleteHistoricalLegacyStreamingPropertyValueData_keysWithCommonPrefix() throws Exception {
        String vertexId = "v1";
        this.graph.prepareVertex(vertexId, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        long timestamp = new Date().getTime();
        String propertyKey1 = "prefix";
        String propertyKey2 = "prefixSuffix";
        String propertyName = "prop1";
        String propertyValue = "Hello";
        this.addLegacySPVData(vertexId, timestamp, propertyKey1, propertyName, propertyValue);
        this.addLegacySPVData(vertexId, timestamp, propertyKey2, propertyName, propertyValue);
        this.getGraph().flush();
        new DeleteHistoricalLegacyStreamingPropertyValueData(this.getGraph()).execute(new DeleteHistoricalLegacyStreamingPropertyValueData.Options().setDryRun(false).setVersionsToKeep(1), this.AUTHORIZATIONS_EMPTY);
        Vertex v1 = this.graph.getVertex(vertexId, this.AUTHORIZATIONS_EMPTY);
        StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue(propertyKey1, propertyName);
        Assert.assertNotNull((String)"spv should not be null", (Object)spv);
        Assert.assertEquals((Object)propertyValue, (Object)IOUtils.toString((InputStream)spv.getInputStream()));
        spv = (StreamingPropertyValue)v1.getPropertyValue(propertyKey2, propertyName);
        Assert.assertNotNull((String)"spv should not be null", (Object)spv);
        Assert.assertEquals((Object)propertyValue, (Object)IOUtils.toString((InputStream)spv.getInputStream()));
    }

    @Test
    public void testDeleteHistoricalLegacyStreamingPropertyValueData_mixOfOldAndNew() throws Exception {
        String vertexId = "v1";
        this.graph.prepareVertex(vertexId, VISIBILITY_EMPTY).save(this.AUTHORIZATIONS_EMPTY);
        this.graph.flush();
        long timestamp = new Date().getTime();
        String propertyKey = "prefix";
        String propertyName = "prop1";
        String propertyValue1 = "Hello1";
        String propertyValue2 = "Hello2";
        this.addLegacySPVData(vertexId, timestamp - 100L, propertyKey, propertyName, propertyValue1);
        StreamingPropertyValue newSpv = StreamingPropertyValue.create((String)propertyValue2);
        this.getGraph().getVertex("v1", this.AUTHORIZATIONS_EMPTY).addPropertyValue(propertyKey, propertyName, (Object)newSpv, VISIBILITY_EMPTY, this.AUTHORIZATIONS_EMPTY);
        this.getGraph().flush();
        new DeleteHistoricalLegacyStreamingPropertyValueData(this.getGraph()).execute(new DeleteHistoricalLegacyStreamingPropertyValueData.Options().setDryRun(false).setVersionsToKeep(1), this.AUTHORIZATIONS_EMPTY);
        Vertex v1 = this.graph.getVertex(vertexId, this.AUTHORIZATIONS_EMPTY);
        StreamingPropertyValue spv = (StreamingPropertyValue)v1.getPropertyValue(propertyKey, propertyName);
        Assert.assertNotNull((String)"spv should not be null", (Object)spv);
        Assert.assertEquals((Object)propertyValue2, (Object)IOUtils.toString((InputStream)spv.getInputStream()));
    }

    private void addLegacySPVData(String vertexId, long timestamp, String propertyKey, String propertyName, String propertyValue) throws MutationsRejectedException {
        String dataRowKey = new DataTableRowKey(vertexId, propertyKey, propertyName).getRowKey() + '\u001f' + timestamp;
        Mutation addPropertyMutation = new Mutation((CharSequence)vertexId);
        byte[] data = propertyValue.getBytes();
        StreamingPropertyValue spv = StreamingPropertyValue.create((String)propertyValue);
        StreamingPropertyValueTableRef spvValue = new StreamingPropertyValueTableRef(dataRowKey, spv, data);
        Metadata metadata = new Metadata();
        MutablePropertyImpl property = new MutablePropertyImpl(propertyKey, propertyName, (Object)spvValue, metadata, Long.valueOf(timestamp), new HashSet(), new Visibility(""), FetchHint.ALL);
        Text columnQualifier = KeyHelper.getColumnQualifierFromPropertyColumnQualifier((Property)property, (NameSubstitutionStrategy)this.getGraph().getNameSubstitutionStrategy());
        addPropertyMutation.put(AccumuloElement.CF_PROPERTY, columnQualifier, new Value(this.getGraph().getVertexiumSerializer().objectToBytes((Object)spvValue)));
        this.getGraph().getVerticesWriter().addMutation(addPropertyMutation);
        Mutation addDataMutation = new Mutation((CharSequence)dataRowKey);
        addDataMutation.put(ElementMutationBuilder.EMPTY_TEXT, ElementMutationBuilder.EMPTY_TEXT, timestamp - 1000L, new Value(data));
        this.getGraph().getDataWriter().addMutation(addDataMutation);
        this.getGraph().flush();
    }

    public AccumuloGraph getGraph() {
        return (AccumuloGraph)super.getGraph();
    }
}

