/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.vertexium.VertexiumException;

public class AccumuloGraphTestUtils {
    public static void ensureTableExists(Connector connector, String tableName) {
        if (!connector.tableOperations().exists(tableName)) {
            AccumuloGraphTestUtils.createTable(connector, tableName);
        }
    }

    public static void dropGraph(Connector connector, String tableName) {
        try {
            if (connector.tableOperations().exists(tableName)) {
                connector.tableOperations().delete(tableName);
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Unable to drop graph: " + tableName, (Throwable)e);
        }
        AccumuloGraphTestUtils.createTable(connector, tableName);
    }

    private static void createTable(Connector connector, String tableName) {
        try {
            NewTableConfiguration config = new NewTableConfiguration().withoutDefaultIterators().setTimeType(TimeType.MILLIS);
            connector.tableOperations().create(tableName, config);
        }
        catch (Exception e) {
            throw new VertexiumException("Unable to create table " + tableName);
        }
    }
}

