/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.junit.rules.ExternalResource;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloGraphConfiguration;
import org.vertexium.accumulo.AccumuloGraphTestUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class AccumuloResource
extends ExternalResource {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(AccumuloResource.class);
    private static final String ACCUMULO_USERNAME = "root";
    private static final String ACCUMULO_PASSWORD = "test";
    private File tempDir;
    private MiniAccumuloCluster accumulo;
    private Map extraConfig = null;

    public AccumuloResource() {
    }

    public AccumuloResource(Map extraConfig) {
        this.extraConfig = extraConfig;
    }

    protected void before() throws Throwable {
        this.ensureAccumuloIsStarted();
        super.before();
    }

    protected void after() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOGGER.info("Unable to shut down mini accumulo cluster", (Throwable)e);
        }
        super.after();
    }

    public void dropGraph() throws Exception {
        Connector connector = this.createConnector();
        AccumuloGraphTestUtils.ensureTableExists(connector, "vertexium");
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getDataTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getVerticesTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getHistoryVerticesTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getEdgesTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getExtendedDataTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getHistoryEdgesTableName((String)"vertexium"));
        AccumuloGraphTestUtils.dropGraph(connector, AccumuloGraph.getMetadataTableName((String)"vertexium"));
        connector.securityOperations().changeUserAuthorizations(ACCUMULO_USERNAME, new Authorizations(new String[]{"a", "b", "c", "MIXED_CASE_a"}));
    }

    public void addAuthorizations(AccumuloGraph graph, String ... authorizations) {
        try {
            String principal = graph.getConnector().whoami();
            Authorizations currentAuthorizations = graph.getConnector().securityOperations().getUserAuthorizations(principal);
            ArrayList<byte[]> newAuthorizationsArray = new ArrayList<byte[]>();
            for (byte[] currentAuth : currentAuthorizations) {
                newAuthorizationsArray.add(currentAuth);
            }
            for (String authorization : authorizations) {
                if (currentAuthorizations.contains(authorization)) continue;
                newAuthorizationsArray.add(authorization.getBytes(StandardCharsets.UTF_8));
            }
            Authorizations newAuthorizations = new Authorizations(newAuthorizationsArray);
            graph.getConnector().securityOperations().changeUserAuthorizations(principal, newAuthorizations);
        }
        catch (Exception ex) {
            throw new VertexiumException("could not add authorizations", (Throwable)ex);
        }
    }

    public MiniAccumuloCluster getAccumulo() {
        return this.accumulo;
    }

    public Map createConfig() {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("zookeeperServers", this.accumulo.getZooKeepers());
        configMap.put("accumuloInstanceName", this.accumulo.getInstanceName());
        configMap.put("username", ACCUMULO_USERNAME);
        configMap.put("password", ACCUMULO_PASSWORD);
        configMap.put("autoFlush", false);
        configMap.put("maxStreamingPropertyValueTableDataSize", 0x100000);
        configMap.put("hdfs.dataDir", "/tmp/");
        configMap.put("historyInSeparateTable", true);
        if (this.extraConfig != null) {
            configMap.putAll(this.extraConfig);
        }
        return configMap;
    }

    public Connector createConnector() throws AccumuloSecurityException, AccumuloException {
        return new AccumuloGraphConfiguration(this.createConfig()).createConnector();
    }

    public void ensureAccumuloIsStarted() {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Accumulo mini cluster", e);
        }
    }

    protected void stop() throws IOException, InterruptedException {
        if (this.accumulo != null) {
            LOGGER.info("Stopping accumulo", new Object[0]);
            this.accumulo.stop();
            this.accumulo = null;
        }
        this.tempDir.delete();
    }

    public void start() throws IOException, InterruptedException {
        if (this.accumulo != null) {
            return;
        }
        LOGGER.info("Starting accumulo", new Object[0]);
        this.tempDir = File.createTempFile("accumulo-temp", Long.toString(System.nanoTime()));
        this.tempDir.delete();
        this.tempDir.mkdir();
        LOGGER.info("writing to: %s", new Object[]{this.tempDir});
        MiniAccumuloConfig miniAccumuloConfig = new MiniAccumuloConfig(this.tempDir, ACCUMULO_PASSWORD);
        miniAccumuloConfig.setZooKeeperStartupTime(60000L);
        this.accumulo = new MiniAccumuloCluster(miniAccumuloConfig);
        this.accumulo.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AccumuloResource.this.stop();
                }
                catch (Exception e) {
                    System.out.println("Failed to stop Accumulo test cluster");
                }
            }
        });
    }
}

