/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.StreamUtils;

public class CypherResultWriter {
    public String columnValueToString(VertexiumCypherQueryContext ctx, Object o) {
        if (o == null) {
            return this.columnNullValueToString();
        }
        if (o instanceof Optional) {
            return this.columnValueToString(ctx, ((Optional)o).orElse(null));
        }
        if (o instanceof Map) {
            return this.columnMapValueToString(ctx, (Map)o);
        }
        if (o instanceof Double) {
            return this.columnDoubleValueToString((Double)o);
        }
        if (o instanceof Vertex) {
            return this.columnVertexToString(ctx, (Vertex)o);
        }
        if (o instanceof Edge) {
            return this.columnEdgeToString(ctx, (Edge)o);
        }
        if (o instanceof String) {
            return this.columnStringToString(o);
        }
        if (o instanceof VertexiumCypherScope.PathItem) {
            return this.columnPathResultToString(ctx, (VertexiumCypherScope.PathItem)o);
        }
        if (o instanceof Stream) {
            return this.columnValueIterableToString(ctx, ((Stream)o).collect(Collectors.toList()));
        }
        if (o instanceof Iterable) {
            return this.columnValueIterableToString(ctx, (Iterable)o);
        }
        return this.columnUnknownToString(o);
    }

    private String columnPathResultToString(VertexiumCypherQueryContext ctx, VertexiumCypherScope.PathItem pathResult) {
        return pathResult.toString(ctx);
    }

    private String columnValueIterableToString(VertexiumCypherQueryContext ctx, Iterable<?> list) {
        return "[" + StreamUtils.stream((Iterable[])new Iterable[]{list}).map(item -> this.columnValueToString(ctx, item)).collect(Collectors.joining(", ")) + "]";
    }

    private String columnUnknownToString(Object o) {
        return o.toString();
    }

    private String columnStringToString(Object o) {
        return "'" + o + "'";
    }

    private String columnVertexToString(VertexiumCypherQueryContext ctx, Vertex vertex) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        int propertyCount = 0;
        for (Property property : vertex.getProperties()) {
            if (property.getName().equals(ctx.getLabelPropertyName())) {
                result.append(":");
                result.append(property.getValue());
                continue;
            }
            ++propertyCount;
        }
        if (propertyCount > 0) {
            if (result.length() > "(".length()) {
                result.append(" ");
            }
            result.append(this.elementPropertiesToString(ctx, (Element)vertex));
        }
        result.append(")");
        return result.toString();
    }

    private String elementPropertiesToString(VertexiumCypherQueryContext ctx, Element element) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Property property : element.getProperties()) {
            if (property.getName().equals(ctx.getLabelPropertyName())) continue;
            if (first) {
                result.append("{");
            } else {
                result.append(", ");
            }
            result.append(property.getName());
            result.append(": ");
            result.append(this.columnValueToString(ctx, property.getValue()));
            first = false;
        }
        if (result.length() > 0) {
            result.append("}");
        }
        return result.toString();
    }

    private String columnEdgeToString(VertexiumCypherQueryContext ctx, Edge edge) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(":");
        result.append(edge.getLabel());
        if (IterableUtils.count((Iterable)edge.getProperties()) > 0) {
            result.append(" ");
            result.append(this.elementPropertiesToString(ctx, (Element)edge));
        }
        result.append("]");
        return result.toString();
    }

    private String columnDoubleValueToString(double o) {
        DecimalFormat formatter = new DecimalFormat(o < 0.0 ? ".0#############" : "0.0#############");
        return formatter.format(o);
    }

    private String columnMapValueToString(VertexiumCypherQueryContext ctx, Map<String, Object> o) {
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (!first) {
                result.append(", ");
            }
            result.append(entry.getKey());
            result.append(": ");
            result.append(this.columnValueToString(ctx, entry.getValue()));
            first = false;
        }
        result.append("}");
        return result.toString();
    }

    private String columnNullValueToString() {
        return "null";
    }
}

