/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher;

import com.google.common.base.Preconditions;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherResult;
import org.vertexium.cypher.ast.CypherAstParser;
import org.vertexium.cypher.ast.CypherCompilerContext;
import org.vertexium.cypher.ast.model.CypherStatement;
import org.vertexium.cypher.executor.QueryExecutor;

public class VertexiumCypherQuery {
    private final CypherStatement statement;
    private final QueryExecutor queryExecutor;

    protected VertexiumCypherQuery(CypherStatement statement) {
        Preconditions.checkNotNull((Object)statement, (Object)"statement is required");
        this.statement = statement;
        this.queryExecutor = new QueryExecutor();
    }

    public static VertexiumCypherQuery parse(CypherCompilerContext ctx, String queryString) {
        CypherStatement statement = CypherAstParser.getInstance().parse(ctx, queryString);
        if (statement == null) {
            throw new VertexiumException("Failed to parse query: " + queryString);
        }
        return new VertexiumCypherQuery(statement);
    }

    public VertexiumCypherResult execute(VertexiumCypherQueryContext ctx) {
        return this.queryExecutor.execute(ctx, this.statement);
    }
}

