/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.cypher.CypherResultWriter;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.executor.CreateClauseExecutor;
import org.vertexium.cypher.executor.DeleteClauseExecutor;
import org.vertexium.cypher.executor.ExpressionExecutor;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.executor.MatchClauseExecutor;
import org.vertexium.cypher.executor.MergeClauseExecutor;
import org.vertexium.cypher.executor.RemoveClauseExecutor;
import org.vertexium.cypher.executor.ReturnClauseExecutor;
import org.vertexium.cypher.executor.SetClauseExecutor;
import org.vertexium.cypher.executor.UnwindClauseExecutor;
import org.vertexium.cypher.executor.WithClauseExecutor;
import org.vertexium.cypher.executor.models.match.MatchConstraint;
import org.vertexium.cypher.functions.CypherFunction;
import org.vertexium.cypher.functions.aggregate.AverageFunction;
import org.vertexium.cypher.functions.aggregate.CollectFunction;
import org.vertexium.cypher.functions.aggregate.CountFunction;
import org.vertexium.cypher.functions.aggregate.MaxFunction;
import org.vertexium.cypher.functions.aggregate.MinFunction;
import org.vertexium.cypher.functions.aggregate.PercentileContFunction;
import org.vertexium.cypher.functions.aggregate.PercentileDiscFunction;
import org.vertexium.cypher.functions.aggregate.StandardDeviationFunction;
import org.vertexium.cypher.functions.aggregate.StandardDeviationPopulationFunction;
import org.vertexium.cypher.functions.aggregate.SumFunction;
import org.vertexium.cypher.functions.date.DayFunction;
import org.vertexium.cypher.functions.date.MonthFunction;
import org.vertexium.cypher.functions.date.YearFunction;
import org.vertexium.cypher.functions.list.ExtractFunction;
import org.vertexium.cypher.functions.list.FilterFunction;
import org.vertexium.cypher.functions.list.KeysFunction;
import org.vertexium.cypher.functions.list.LabelsFunction;
import org.vertexium.cypher.functions.list.NodesFunction;
import org.vertexium.cypher.functions.list.RangeFunction;
import org.vertexium.cypher.functions.list.ReduceFunction;
import org.vertexium.cypher.functions.list.RelationshipsFunction;
import org.vertexium.cypher.functions.list.TailFunction;
import org.vertexium.cypher.functions.math.ACosFunction;
import org.vertexium.cypher.functions.math.ASinFunction;
import org.vertexium.cypher.functions.math.ATan2Function;
import org.vertexium.cypher.functions.math.ATanFunction;
import org.vertexium.cypher.functions.math.AbsFunction;
import org.vertexium.cypher.functions.math.CeilFunction;
import org.vertexium.cypher.functions.math.CosFunction;
import org.vertexium.cypher.functions.math.CotFunction;
import org.vertexium.cypher.functions.math.DegreesFunction;
import org.vertexium.cypher.functions.math.EFunction;
import org.vertexium.cypher.functions.math.ExpFunction;
import org.vertexium.cypher.functions.math.FloorFunction;
import org.vertexium.cypher.functions.math.HaversinFunction;
import org.vertexium.cypher.functions.math.Log10Function;
import org.vertexium.cypher.functions.math.LogFunction;
import org.vertexium.cypher.functions.math.PiFunction;
import org.vertexium.cypher.functions.math.RadiansFunction;
import org.vertexium.cypher.functions.math.RandFunction;
import org.vertexium.cypher.functions.math.RoundFunction;
import org.vertexium.cypher.functions.math.SignFunction;
import org.vertexium.cypher.functions.math.SinFunction;
import org.vertexium.cypher.functions.math.SquareRootFunction;
import org.vertexium.cypher.functions.math.TanFunction;
import org.vertexium.cypher.functions.predicate.AllFunction;
import org.vertexium.cypher.functions.predicate.AnyFunction;
import org.vertexium.cypher.functions.predicate.ExistsFunction;
import org.vertexium.cypher.functions.predicate.NoneFunction;
import org.vertexium.cypher.functions.predicate.SingleFunction;
import org.vertexium.cypher.functions.scalar.CoalesceFunction;
import org.vertexium.cypher.functions.scalar.EndNodeFunction;
import org.vertexium.cypher.functions.scalar.HeadFunction;
import org.vertexium.cypher.functions.scalar.IdFunction;
import org.vertexium.cypher.functions.scalar.LastFunction;
import org.vertexium.cypher.functions.scalar.LengthFunction;
import org.vertexium.cypher.functions.scalar.PropertiesFunction;
import org.vertexium.cypher.functions.scalar.SizeFunction;
import org.vertexium.cypher.functions.scalar.StartNodeFunction;
import org.vertexium.cypher.functions.scalar.TimestampFunction;
import org.vertexium.cypher.functions.scalar.ToBooleanFunction;
import org.vertexium.cypher.functions.scalar.ToFloatFunction;
import org.vertexium.cypher.functions.scalar.ToIntegerFunction;
import org.vertexium.cypher.functions.scalar.TypeFunction;
import org.vertexium.cypher.functions.spatial.DistanceFunction;
import org.vertexium.cypher.functions.spatial.PointFunction;
import org.vertexium.cypher.functions.string.LTrimFunction;
import org.vertexium.cypher.functions.string.LeftFunction;
import org.vertexium.cypher.functions.string.RTrimFunction;
import org.vertexium.cypher.functions.string.ReplaceFunction;
import org.vertexium.cypher.functions.string.ReverseFunction;
import org.vertexium.cypher.functions.string.RightFunction;
import org.vertexium.cypher.functions.string.SplitFunction;
import org.vertexium.cypher.functions.string.SubstringFunction;
import org.vertexium.cypher.functions.string.ToLowerFunction;
import org.vertexium.cypher.functions.string.ToStringFunction;
import org.vertexium.cypher.functions.string.ToUpperFunction;
import org.vertexium.cypher.functions.string.TrimFunction;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.util.StreamUtils;

public abstract class VertexiumCypherQueryContext {
    private final Graph graph;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, CypherFunction> functions = new HashMap<String, CypherFunction>();
    private final Authorizations authorizations;
    private final ExpressionExecutor expressionExecutor;
    private final CreateClauseExecutor createClauseExecutor;
    private final ReturnClauseExecutor returnClauseExecutor;
    private final MatchClauseExecutor matchClauseExecutor;
    private final UnwindClauseExecutor unwindClauseExecutor;
    private final WithClauseExecutor withClauseExecutor;
    private final MergeClauseExecutor mergeClauseExecutor;
    private final DeleteClauseExecutor deleteClauseExecutor;
    private final SetClauseExecutor setClauseExecutor;
    private final RemoveClauseExecutor removeClauseExecutor;
    private final CypherResultWriter resultWriter;
    private final Map<MatchConstraint<?, ?>, Long> totalHitsByMatchConstraint = new HashMap();

    public VertexiumCypherQueryContext(Graph graph, Authorizations authorizations) {
        this.graph = graph;
        this.authorizations = authorizations;
        this.addFunction("avg", new AverageFunction());
        this.addFunction("collect", new CollectFunction());
        this.addFunction("count", new CountFunction());
        this.addFunction("max", new MaxFunction());
        this.addFunction("min", new MinFunction());
        this.addFunction("percentileCont", new PercentileContFunction());
        this.addFunction("percentileDisc", new PercentileDiscFunction());
        this.addFunction("stDev", new StandardDeviationFunction());
        this.addFunction("stDevP", new StandardDeviationPopulationFunction());
        this.addFunction("sum", new SumFunction());
        this.addFunction("extract", new ExtractFunction());
        this.addFunction("filter", new FilterFunction());
        this.addFunction("keys", new KeysFunction());
        this.addFunction("labels", new LabelsFunction());
        this.addFunction("nodes", new NodesFunction());
        this.addFunction("range", new RangeFunction());
        this.addFunction("reduce", new ReduceFunction());
        this.addFunction("relationships", new RelationshipsFunction());
        this.addFunction("tail", new TailFunction());
        this.addFunction("abs", new AbsFunction());
        this.addFunction("ceil", new CeilFunction());
        this.addFunction("floor", new FloorFunction());
        this.addFunction("rand", new RandFunction());
        this.addFunction("round", new RoundFunction());
        this.addFunction("sign", new SignFunction());
        this.addFunction("e", new EFunction());
        this.addFunction("exp", new ExpFunction());
        this.addFunction("log", new LogFunction());
        this.addFunction("log10", new Log10Function());
        this.addFunction("sqrt", new SquareRootFunction());
        this.addFunction("acos", new ACosFunction());
        this.addFunction("asin", new ASinFunction());
        this.addFunction("atan", new ATanFunction());
        this.addFunction("atan2", new ATan2Function());
        this.addFunction("cos", new CosFunction());
        this.addFunction("cot", new CotFunction());
        this.addFunction("degrees", new DegreesFunction());
        this.addFunction("haversin", new HaversinFunction());
        this.addFunction("pi", new PiFunction());
        this.addFunction("radians", new RadiansFunction());
        this.addFunction("sin", new SinFunction());
        this.addFunction("tan", new TanFunction());
        this.addFunction("all", new AllFunction());
        this.addFunction("any", new AnyFunction());
        this.addFunction("exists", new ExistsFunction());
        this.addFunction("none", new NoneFunction());
        this.addFunction("single", new SingleFunction());
        this.addFunction("coalesce", new CoalesceFunction());
        this.addFunction("endNode", new EndNodeFunction());
        this.addFunction("head", new HeadFunction());
        this.addFunction("id", new IdFunction());
        this.addFunction("last", new LastFunction());
        this.addFunction("length", new LengthFunction());
        this.addFunction("properties", new PropertiesFunction());
        this.addFunction("size", new SizeFunction());
        this.addFunction("startNode", new StartNodeFunction());
        this.addFunction("timestamp", new TimestampFunction());
        this.addFunction("toBoolean", new ToBooleanFunction());
        this.addFunction("toFloat", new ToFloatFunction());
        this.addFunction("toInteger", new ToIntegerFunction());
        this.addFunction("type", new TypeFunction());
        this.addFunction("distance", new DistanceFunction());
        this.addFunction("point", new PointFunction());
        this.addFunction("left", new LeftFunction());
        this.addFunction("lTrim", new LTrimFunction());
        this.addFunction("replace", new ReplaceFunction());
        this.addFunction("reverse", new ReverseFunction());
        this.addFunction("right", new RightFunction());
        this.addFunction("rTrim", new RTrimFunction());
        this.addFunction("split", new SplitFunction());
        this.addFunction("substring", new SubstringFunction());
        this.addFunction("toLower", new ToLowerFunction());
        this.addFunction("lower", new ToLowerFunction());
        this.addFunction("toString", new ToStringFunction());
        this.addFunction("toUpper", new ToUpperFunction());
        this.addFunction("upper", new ToUpperFunction());
        this.addFunction("trim", new TrimFunction());
        this.addFunction("year", new YearFunction());
        this.addFunction("month", new MonthFunction());
        this.addFunction("day", new DayFunction());
        this.resultWriter = new CypherResultWriter();
        this.expressionExecutor = new ExpressionExecutor();
        this.createClauseExecutor = new CreateClauseExecutor(this.expressionExecutor);
        this.returnClauseExecutor = new ReturnClauseExecutor(this.expressionExecutor);
        this.matchClauseExecutor = new MatchClauseExecutor();
        this.unwindClauseExecutor = new UnwindClauseExecutor(this.expressionExecutor);
        this.withClauseExecutor = new WithClauseExecutor();
        this.mergeClauseExecutor = new MergeClauseExecutor();
        this.deleteClauseExecutor = new DeleteClauseExecutor(this.expressionExecutor);
        this.setClauseExecutor = new SetClauseExecutor();
        this.removeClauseExecutor = new RemoveClauseExecutor();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public abstract Visibility calculateVertexVisibility(CypherNodePattern var1, ExpressionScope var2);

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public abstract String getLabelPropertyName();

    public abstract <T extends Element> void setLabelProperty(ElementMutation<T> var1, String var2);

    public abstract void removeLabel(ExistingElementMutation<Vertex> var1, String var2);

    public abstract <T extends Element> void setProperty(ElementMutation<T> var1, String var2, Object var3);

    public abstract void removeProperty(ElementMutation<Element> var1, String var2);

    public abstract String calculateEdgeLabel(CypherRelationshipPattern var1, Vertex var2, Vertex var3, ExpressionScope var4);

    public abstract Visibility calculateEdgeVisibility(CypherRelationshipPattern var1, Vertex var2, Vertex var3, ExpressionScope var4);

    public abstract boolean isLabelProperty(Property var1);

    public abstract Set<String> getVertexLabels(Vertex var1);

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public CypherFunction getFunction(String functionName) {
        return this.functions.get(functionName.toLowerCase());
    }

    public void deleteEdge(Edge edge) {
        this.getGraph().deleteEdge(edge, this.getAuthorizations());
    }

    public void deleteVertex(Vertex vertex) {
        this.getGraph().deleteVertex(vertex, this.getAuthorizations());
    }

    public Edge saveEdge(ElementMutation<Edge> m) {
        return (Edge)m.save(this.getAuthorizations());
    }

    public Vertex saveVertex(ElementMutation<Vertex> m) {
        return (Vertex)m.save(this.getAuthorizations());
    }

    public <T extends Element> void saveElement(ExistingElementMutation<T> m) {
        if (m.getElement() instanceof Edge) {
            this.saveEdge((ElementMutation<Edge>)m);
        } else if (m.getElement() instanceof Vertex) {
            this.saveVertex((ElementMutation<Vertex>)m);
        } else {
            throw new VertexiumException("unexpected element type: " + m.getElement().getClass().getName());
        }
    }

    public ExpressionExecutor getExpressionExecutor() {
        return this.expressionExecutor;
    }

    public CreateClauseExecutor getCreateClauseExecutor() {
        return this.createClauseExecutor;
    }

    public ReturnClauseExecutor getReturnClauseExecutor() {
        return this.returnClauseExecutor;
    }

    public MatchClauseExecutor getMatchClauseExecutor() {
        return this.matchClauseExecutor;
    }

    public UnwindClauseExecutor getUnwindClauseExecutor() {
        return this.unwindClauseExecutor;
    }

    public WithClauseExecutor getWithClauseExecutor() {
        return this.withClauseExecutor;
    }

    public MergeClauseExecutor getMergeClauseExecutor() {
        return this.mergeClauseExecutor;
    }

    public DeleteClauseExecutor getDeleteClauseExecutor() {
        return this.deleteClauseExecutor;
    }

    public SetClauseExecutor getSetClauseExecutor() {
        return this.setClauseExecutor;
    }

    public RemoveClauseExecutor getRemoveClauseExecutor() {
        return this.removeClauseExecutor;
    }

    public CypherResultWriter getResultWriter() {
        return this.resultWriter;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, CypherFunction> getFunctions() {
        return this.functions;
    }

    public void addFunction(String name, CypherFunction fn) {
        this.functions.put(name.toLowerCase(), fn);
    }

    public Set<String> getKeys(Element element) {
        HashSet<String> results = new HashSet<String>();
        for (Property property : element.getProperties()) {
            if (this.isLabelProperty(property)) continue;
            results.add(property.getName());
        }
        return results;
    }

    public Map<String, Object> getElementPropertiesAsMap(Element element) {
        return StreamUtils.stream((Iterable[])new Iterable[]{element.getProperties()}).filter(p -> !this.isLabelProperty((Property)p)).collect(Collectors.toMap(Property::getName, Property::getValue));
    }

    public EnumSet<FetchHint> getFetchHints() {
        return FetchHint.ALL;
    }

    public abstract int getMaxUnboundedRange();

    public String calculateVertexId(CypherNodePattern nodePattern, ExpressionScope scope) {
        return null;
    }

    public String calculateEdgeId(CypherRelationshipPattern relationshipPattern, ExpressionScope scope) {
        return null;
    }

    public String normalizeLabelName(String labelName) {
        return labelName;
    }

    public String normalizePropertyName(String propertyName) {
        return propertyName;
    }

    public Long getTotalHitsForMatchConstraint(MatchConstraint<?, ?> matchConstraint, Function<MatchConstraint<?, ?>, Long> computeFn) {
        return this.totalHitsByMatchConstraint.computeIfAbsent(matchConstraint, computeFn);
    }
}

