/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class VertexiumCypherQueryResult {
    private final String[] columnNames;
    private List<Row> rows;

    public VertexiumCypherQueryResult(String[] columnNames, List<Row> rows) {
        this.columnNames = columnNames;
        this.rows = rows;
    }

    public static VertexiumCypherQueryResult createEmpty() {
        return new VertexiumCypherQueryResult(new String[0], (List<Row>)ImmutableList.of());
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public VertexiumCypherQueryResult concat(VertexiumCypherQueryResult newResults, boolean all) {
        ArrayList<Row> newRows = new ArrayList<Row>();
        newRows.addAll(this.getRows());
        if (all) {
            newRows.addAll(newResults.getRows());
        } else {
            for (Row row : newResults.getRows()) {
                if (this.getRows().contains(row)) continue;
                newRows.add(row);
            }
        }
        return new VertexiumCypherQueryResult(this.columnNames, newRows);
    }

    public static class Row {
        private final List<Object> columns;

        public Row(List<Object> columns) {
            this.columns = columns;
        }

        public List<Object> getColumns() {
            return this.columns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            return this.columns.equals(row.columns);
        }

        public int hashCode() {
            return this.columns.hashCode();
        }
    }
}

