/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherPath;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherResult;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;
import org.vertexium.cypher.executor.ExpressionScope;

public class VertexiumCypherScope
implements VertexiumCypherResult,
ExpressionScope {
    private Stream<Item> itemsStream;
    private Collection<Item> items;
    private LinkedHashSet<String> columnNames;
    private final VertexiumCypherScope parentScope;

    private VertexiumCypherScope(Collection<Item> items, VertexiumCypherScope parentScope) {
        this(items, VertexiumCypherScope.getColumnNames(items), parentScope);
    }

    private VertexiumCypherScope(Collection<Item> items, LinkedHashSet<String> columnNames, VertexiumCypherScope parentScope) {
        this.items = items;
        for (Item item : items) {
            if (item.parentScope != null && parentScope != null) continue;
            item.parentScope = this;
        }
        this.columnNames = columnNames;
        this.parentScope = parentScope;
    }

    private VertexiumCypherScope(Stream<Item> items, VertexiumCypherScope parentScope) {
        this(items, null, parentScope);
    }

    private VertexiumCypherScope(Stream<Item> items, LinkedHashSet<String> columnNames, VertexiumCypherScope parentScope) {
        this.itemsStream = items.peek(item -> {
            if (((Item)item).parentScope == null || parentScope == null) {
                ((Item)item).parentScope = this;
            }
        });
        this.columnNames = columnNames;
        this.parentScope = parentScope;
    }

    public static VertexiumCypherScope newSingleItemScope(Item item) {
        return VertexiumCypherScope.newItemsScope(Lists.newArrayList((Object[])new Item[]{item}), null);
    }

    public static VertexiumCypherScope newItemsScope(Stream<Item> itemsStream, VertexiumCypherScope parentScope) {
        return new VertexiumCypherScope(itemsStream, parentScope);
    }

    public static VertexiumCypherScope newItemsScope(List<Item> items, VertexiumCypherScope parentScope) {
        return new VertexiumCypherScope(items, parentScope);
    }

    public static VertexiumCypherScope newItemsScope(List<Item> items, LinkedHashSet<String> columnNames, VertexiumCypherScope parentScope) {
        return new VertexiumCypherScope(items, columnNames, parentScope);
    }

    public static VertexiumCypherScope newEmpty() {
        return new VertexiumCypherScope(new ArrayList<Item>(), new LinkedHashSet<String>(), null);
    }

    public static VertexiumCypherScope newItemsScope(Stream<Item> items, LinkedHashSet<String> columnNames, VertexiumCypherScope parentScope) {
        return new VertexiumCypherScope(items, columnNames, parentScope);
    }

    @Override
    public int size() {
        return this.getItemsCollection().size();
    }

    private Collection<Item> getItemsCollection() {
        if (this.items == null) {
            this.items = this.itemsStream.collect(Collectors.toList());
        }
        return this.items;
    }

    @Override
    public VertexiumCypherScope getParentScope() {
        return this.parentScope;
    }

    @Override
    public VertexiumCypherScope getParentCypherScope() {
        return this.parentScope;
    }

    @Override
    public LinkedHashSet<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = VertexiumCypherScope.getColumnNames(this.getItemsCollection());
        }
        return this.columnNames;
    }

    public Stream<Item> stream() {
        if (this.items != null) {
            return this.items.stream();
        }
        return this.itemsStream;
    }

    @Override
    public List<Object> getByName(String name) {
        List<Object> results = this.getItemsCollection().stream().map(i -> i.getByName(name, false)).filter(Objects::nonNull).collect(Collectors.toList());
        if (results.size() == 0 && this.getParentScope() != null) {
            return this.getParentScope().getByName(name);
        }
        return results;
    }

    @Override
    public boolean contains(String name) {
        boolean results = this.getItemsCollection().stream().anyMatch(i -> i.contains(name, false));
        if (results) {
            return true;
        }
        return this.getParentScope() != null && this.getParentScope().contains(name);
    }

    public VertexiumCypherScope concat(VertexiumCypherScope other, VertexiumCypherScope parentScope) {
        return this.concat(other, false, parentScope);
    }

    public VertexiumCypherScope concat(VertexiumCypherScope other, boolean distinct, VertexiumCypherScope parentScope) {
        AbstractCollection newItems = distinct ? new LinkedHashSet() : new ArrayList();
        newItems.addAll(this.getItemsCollection());
        newItems.addAll(other.getItemsCollection());
        LinkedHashSet<String> allColumnNames = new LinkedHashSet<String>(this.getColumnNames());
        allColumnNames.addAll(other.getColumnNames());
        return new VertexiumCypherScope(newItems, allColumnNames, parentScope);
    }

    public static Collector<VertexiumCypherScope, Builder, VertexiumCypherScope> concatStreams(VertexiumCypherScope parentScope) {
        return Collector.of(() -> new Builder(parentScope), Builder::add, Builder::concat, Builder::build, new Collector.Characteristics[0]);
    }

    private static LinkedHashSet<String> getColumnNames(Iterable<Item> itemsList) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        for (Item item : itemsList) {
            results.addAll(item.getColumnNames());
        }
        return results;
    }

    public static Item newMapItem(String name, Object value, ExpressionScope parentScope) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(name, value);
        return VertexiumCypherScope.newMapItem(map, parentScope);
    }

    public static Item newEmptyItem() {
        return new EmptyItem(null);
    }

    public static Item newMapItem(LinkedHashMap<String, ?> map, ExpressionScope parentScope) {
        return new MapItem(map, parentScope);
    }

    public static PathItem newEmptyPathItem(String pathName, ExpressionScope parentScope) {
        return new PathItem(pathName, new ArrayList(), parentScope);
    }

    public void run() {
        try {
            this.getItemsCollection();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class Builder {
        private final VertexiumCypherScope parentScope;
        private final List<Item> items = new ArrayList<Item>();

        public Builder(VertexiumCypherScope parentScope) {
            this.parentScope = parentScope;
        }

        public void add(VertexiumCypherScope other) {
            this.items.addAll(other.getItemsCollection());
        }

        public Builder concat(Builder other) {
            throw new VertexiumCypherNotImplemented("concat");
        }

        public VertexiumCypherScope build() {
            return VertexiumCypherScope.newItemsScope(this.items, this.parentScope);
        }
    }

    public static class MapItem
    extends Item {
        private final LinkedHashMap<String, ?> map;

        public MapItem(LinkedHashMap<String, ?> map, ExpressionScope parentScope) {
            super(parentScope);
            this.map = map;
        }

        @Override
        public LinkedHashSet<String> getColumnNames() {
            LinkedHashSet<String> results = new LinkedHashSet<String>();
            for (Map.Entry<String, ?> entry : this.map.entrySet()) {
                results.add(entry.getKey());
            }
            results.addAll(this.getParentScope().getColumnNames());
            return results;
        }

        @Override
        public Object getByName(String name, boolean lookInParent) {
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            if (lookInParent && this.getParentScope() != null) {
                return this.getParentScope().getByName(name);
            }
            return null;
        }

        @Override
        public boolean contains(String name, boolean lookInParent) {
            if (this.map.containsKey(name)) {
                return true;
            }
            if (lookInParent && this.getParentScope() != null) {
                return this.getParentScope().contains(name);
            }
            return false;
        }

        @Override
        public Item concat(Item itemOther) {
            if (itemOther instanceof MapItem) {
                LinkedHashMap all = new LinkedHashMap();
                all.putAll(this.map);
                all.putAll(((MapItem)itemOther).map);
                return new MapItem(all, this.getParentScope());
            }
            throw new VertexiumCypherNotImplemented("concat map items with: " + itemOther);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapItem mapItem = (MapItem)o;
            return this.map.equals(mapItem.map);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static class PathItem
    extends Item
    implements VertexiumCypherPath {
        private final String pathName;
        private final List<Entry> items;
        private PrintMode printMode;

        private PathItem(String pathName, List<Entry> entries, ExpressionScope parentScope) {
            super(parentScope);
            this.pathName = pathName;
            this.items = entries;
        }

        public PathItem setPrintMode(PrintMode printMode) {
            this.printMode = printMode;
            return this;
        }

        public PrintMode getPrintMode() {
            return this.printMode;
        }

        public Element getLastElement() {
            if (this.items.size() > 0) {
                return this.items.get((int)(this.items.size() - 1)).element;
            }
            throw new IndexOutOfBoundsException("list contains no items");
        }

        public Element getFirstElement() {
            if (this.items.size() > 0) {
                return this.items.get((int)0).element;
            }
            throw new IndexOutOfBoundsException("list contains no items");
        }

        public PathItem concat(String name, Element element) {
            ArrayList<Entry> allEntries = new ArrayList<Entry>(this.items);
            allEntries.add(new Entry(name, element));
            return new PathItem(this.pathName, allEntries, this.getParentScope()).setPrintMode(this.getPrintMode());
        }

        public PathItem concat(PathItem pathItem) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.items);
            int offset = 0;
            if (entries.size() > 0 && pathItem.items.size() > 0 && ((Entry)entries.get((int)(entries.size() - 1))).element.equals(pathItem.items.get((int)0).element)) {
                offset = 1;
            }
            entries.addAll(pathItem.items.subList(offset, pathItem.items.size()));
            return new PathItem(this.pathName, entries, this.getParentScope());
        }

        public boolean contains(Element element) {
            return this.items.stream().anyMatch(e -> e.element != null && e.element.equals(element));
        }

        public List<Edge> getEdges() {
            return this.items.stream().filter(e -> e.element instanceof Edge).map(e -> (Edge)e.element).collect(Collectors.toList());
        }

        public List<Vertex> getVertices() {
            return this.items.stream().filter(e -> e.element instanceof Vertex).map(e -> (Vertex)e.element).collect(Collectors.toList());
        }

        public Element getElement(int index) {
            int calculatedIndex = index;
            if (calculatedIndex < 0) {
                calculatedIndex = this.items.size() + index;
            }
            if (calculatedIndex < 0 || calculatedIndex >= this.items.size()) {
                throw new IndexOutOfBoundsException("requested " + index + " but size is " + this.items.size());
            }
            return this.items.get((int)calculatedIndex).element;
        }

        @Override
        public LinkedHashSet<String> getColumnNames() {
            throw new VertexiumCypherNotImplemented("getColumnNames");
        }

        @Override
        public Object getByName(String name, boolean lookInParent) {
            throw new VertexiumCypherNotImplemented("getByName");
        }

        @Override
        public boolean contains(String name, boolean lookInParent) {
            throw new VertexiumCypherNotImplemented("contains");
        }

        @Override
        public Item concat(Item itemOther) {
            throw new VertexiumCypherNotImplemented("concat path items");
        }

        public String toString(VertexiumCypherQueryContext ctx) {
            if (this.printMode == PrintMode.RELATIONSHIP_RANGE) {
                return "[" + this.items.stream().filter(item -> item.element instanceof Edge).map(item -> item.toString(ctx)).collect(Collectors.joining(", ")) + "]";
            }
            StringBuilder result = new StringBuilder();
            result.append("<");
            Vertex previousVertex = null;
            Element previousElement = null;
            for (Entry item2 : this.items) {
                Element element = item2.element;
                if (element != null) {
                    if (element instanceof Edge) {
                        Edge edge = (Edge)element;
                        Direction direction = null;
                        if (previousVertex != null) {
                            direction = this.getDirection(previousVertex.getId(), edge);
                        }
                        if (direction != null && direction == Direction.IN) {
                            result.append("<");
                        }
                        result.append("-");
                        result.append(item2.toString(ctx));
                        result.append("-");
                        if (direction != null && direction == Direction.OUT) {
                            result.append(">");
                        }
                    } else if (element instanceof Vertex) {
                        Vertex vertex = (Vertex)element;
                        if (previousElement != null || !vertex.equals(previousVertex)) {
                            result.append(item2.toString(ctx));
                            previousVertex = vertex;
                        }
                    } else {
                        throw new VertexiumException("unexpected element type: " + element.getClass().getName());
                    }
                }
                previousElement = element;
            }
            result.append(">");
            return result.toString();
        }

        public String toString() {
            return this.toString(null);
        }

        private Direction getDirection(String previousVertexId, Edge element) {
            if (element.getVertexId(Direction.OUT).equals(previousVertexId)) {
                return Direction.OUT;
            }
            return Direction.IN;
        }

        public int getLength() {
            return (int)this.items.stream().filter(e -> e.element instanceof Edge).map(e -> (Edge)e.element).count();
        }

        @Override
        public String getPathName() {
            return this.pathName;
        }

        @Override
        public List<VertexiumCypherPath.Item> getItems() {
            ImmutableList.Builder builder = ImmutableList.builder();
            return builder.addAll(this.items).build();
        }

        public boolean canVertexConnectOrFoundAtStartOrEnd(Vertex vertex) {
            return this.canVertexConnectOrFound(this.getFirstElement(), vertex) || this.canVertexConnectOrFound(this.getLastElement(), vertex);
        }

        private boolean canVertexConnectOrFound(Element element, Vertex vertex) {
            if (element instanceof Vertex) {
                return element.equals(vertex);
            }
            if (element instanceof Edge) {
                Edge edge = (Edge)element;
                return edge.getVertexId(Direction.OUT).equals(vertex.getId()) || edge.getVertexId(Direction.IN).equals(vertex.getId());
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathItem pathItem = (PathItem)o;
            if (this.pathName != null ? !this.pathName.equals(pathItem.pathName) : pathItem.pathName != null) {
                return false;
            }
            return this.items != null ? this.items.equals(pathItem.items) : pathItem.items == null;
        }

        @Override
        public int hashCode() {
            int result = this.pathName != null ? this.pathName.hashCode() : 0;
            result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
            return result;
        }

        private static class Entry
        implements VertexiumCypherPath.Item {
            public final String name;
            public final Element element;

            private Entry(String name, Element element) {
                this.name = name;
                this.element = element;
            }

            public String toString() {
                return "{name='" + this.name + '\'' + ", " + (this.element instanceof Vertex ? "vertex" : "edge") + "Id=" + (this.element == null ? null : this.element.getId()) + '}';
            }

            public String toString(VertexiumCypherQueryContext ctx) {
                if (ctx == null) {
                    return this.element.toString();
                }
                return ctx.getResultWriter().columnValueToString(ctx, this.element);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                if (this.name != null ? !this.name.equals(entry.name) : entry.name != null) {
                    return false;
                }
                return this.element != null ? this.element.equals(entry.element) : entry.element == null;
            }

            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
                return result;
            }

            @Override
            public String getItemName() {
                return this.name;
            }

            @Override
            public Element getElement() {
                return this.element;
            }
        }

        public static enum PrintMode {
            RELATIONSHIP_RANGE;

        }
    }

    public static class EmptyItem
    extends Item {
        public EmptyItem(VertexiumCypherScope parentScope) {
            super(parentScope);
        }

        @Override
        public LinkedHashSet<String> getColumnNames() {
            return new LinkedHashSet<String>();
        }

        @Override
        public Object getByName(String name, boolean lookInParent) {
            if (lookInParent && this.getParentScope() != null) {
                return this.getParentScope().getByName(name);
            }
            return null;
        }

        @Override
        public boolean contains(String name, boolean lookInParent) {
            if (lookInParent && this.getParentScope() != null) {
                return this.getParentScope().contains(name);
            }
            return false;
        }

        @Override
        public Item concat(Item itemOther) {
            return itemOther;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    public static abstract class Item
    implements VertexiumCypherResult.Row,
    ExpressionScope {
        private ExpressionScope parentScope;

        protected Item(ExpressionScope parentScope) {
            this.parentScope = parentScope;
        }

        @Override
        public abstract LinkedHashSet<String> getColumnNames();

        @Override
        public Object getByName(String name) {
            return this.getByName(name, true);
        }

        @Override
        public boolean contains(String name) {
            return this.contains(name, true);
        }

        public abstract Object getByName(String var1, boolean var2);

        public abstract boolean contains(String var1, boolean var2);

        @Override
        public ExpressionScope getParentScope() {
            return this.parentScope;
        }

        public abstract Item concat(Item var1);

        @Override
        public VertexiumCypherScope getParentCypherScope() {
            for (ExpressionScope parentScope = this.getParentScope(); parentScope != null; parentScope = parentScope.getParentScope()) {
                if (!(parentScope instanceof VertexiumCypherScope)) continue;
                return (VertexiumCypherScope)parentScope;
            }
            return null;
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public static Stream<Item> cartesianProduct(Stream<Item> items0, Stream<Item> items1) {
            List items1List = items1.collect(Collectors.toList());
            return items0.flatMap(item0 -> items1List.stream().map(item0::concat));
        }
    }
}

