/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.vertexium.cypher.CypherLexer;
import org.vertexium.cypher.CypherParser;
import org.vertexium.cypher.ast.CypherCompilerContext;
import org.vertexium.cypher.ast.CypherCstToAstVisitor;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherStatement;
import org.vertexium.cypher.exceptions.VertexiumCypherSyntaxErrorException;

public class CypherAstParser {
    private static final CypherAstParser instance = new CypherAstParser();

    public static CypherAstParser getInstance() {
        return instance;
    }

    public CypherStatement parse(CypherCompilerContext ctx, String code) {
        CodePointCharStream input = CharStreams.fromString((String)code);
        CypherLexer lexer = new CypherLexer((CharStream)input);
        CypherParser parser = new CypherParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new ParserErrorHandler(code));
        CypherParser.CypherContext tree = parser.cypher();
        if (!tree.getText().equals(code)) {
            throw new VertexiumCypherSyntaxErrorException("Parsing error, \"" + code.substring(tree.getText().length()) + "\"");
        }
        return new CypherCstToAstVisitor(ctx).visitCypher(tree);
    }

    public CypherAstBase parseExpression(String expressionString) {
        CypherLexer lexer = new CypherLexer((CharStream)CharStreams.fromString((String)expressionString));
        CypherParser parser = new CypherParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new ParserErrorHandler(expressionString));
        CypherParser.ExpressionContext expressionContext = parser.expression();
        return new CypherCstToAstVisitor().visitExpression(expressionContext);
    }

    private static class ParserErrorHandler
    extends BailErrorStrategy {
        private final String code;

        public ParserErrorHandler(String code) {
            this.code = code;
        }

        public void reportError(Parser recognizer, RecognitionException e) {
            String messagePrefix = "";
            if (e.getCtx() instanceof CypherParser.RelationshipPatternContext) {
                messagePrefix = "InvalidRelationshipPattern: ";
            }
            throw new VertexiumCypherSyntaxErrorException(messagePrefix + "Could not parse: " + this.code, e);
        }
    }
}

