/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.CypherBaseVisitor;
import org.vertexium.cypher.CypherParser;
import org.vertexium.cypher.ast.CypherCompilerContext;
import org.vertexium.cypher.ast.model.CypherAllLiteral;
import org.vertexium.cypher.ast.model.CypherArrayAccess;
import org.vertexium.cypher.ast.model.CypherArraySlice;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherBinaryExpression;
import org.vertexium.cypher.ast.model.CypherBoolean;
import org.vertexium.cypher.ast.model.CypherClause;
import org.vertexium.cypher.ast.model.CypherComparisonExpression;
import org.vertexium.cypher.ast.model.CypherCreateClause;
import org.vertexium.cypher.ast.model.CypherDeleteClause;
import org.vertexium.cypher.ast.model.CypherDirection;
import org.vertexium.cypher.ast.model.CypherDouble;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherExpression;
import org.vertexium.cypher.ast.model.CypherFilterExpression;
import org.vertexium.cypher.ast.model.CypherFunctionInvocation;
import org.vertexium.cypher.ast.model.CypherIdInColl;
import org.vertexium.cypher.ast.model.CypherIn;
import org.vertexium.cypher.ast.model.CypherIndexedParameter;
import org.vertexium.cypher.ast.model.CypherInteger;
import org.vertexium.cypher.ast.model.CypherIsNotNull;
import org.vertexium.cypher.ast.model.CypherIsNull;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherLimit;
import org.vertexium.cypher.ast.model.CypherListComprehension;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherLiteral;
import org.vertexium.cypher.ast.model.CypherLookup;
import org.vertexium.cypher.ast.model.CypherMapLiteral;
import org.vertexium.cypher.ast.model.CypherMatchAll;
import org.vertexium.cypher.ast.model.CypherMatchClause;
import org.vertexium.cypher.ast.model.CypherMergeAction;
import org.vertexium.cypher.ast.model.CypherMergeActionCreate;
import org.vertexium.cypher.ast.model.CypherMergeActionMatch;
import org.vertexium.cypher.ast.model.CypherMergeClause;
import org.vertexium.cypher.ast.model.CypherNameParameter;
import org.vertexium.cypher.ast.model.CypherNegateExpression;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherOrderBy;
import org.vertexium.cypher.ast.model.CypherPatternComprehension;
import org.vertexium.cypher.ast.model.CypherPatternPart;
import org.vertexium.cypher.ast.model.CypherQuery;
import org.vertexium.cypher.ast.model.CypherRangeLiteral;
import org.vertexium.cypher.ast.model.CypherRelTypeName;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.ast.model.CypherRelationshipsPattern;
import org.vertexium.cypher.ast.model.CypherRemoveClause;
import org.vertexium.cypher.ast.model.CypherRemoveItem;
import org.vertexium.cypher.ast.model.CypherRemoveLabelItem;
import org.vertexium.cypher.ast.model.CypherRemovePropertyExpressionItem;
import org.vertexium.cypher.ast.model.CypherReturnBody;
import org.vertexium.cypher.ast.model.CypherReturnClause;
import org.vertexium.cypher.ast.model.CypherReturnItem;
import org.vertexium.cypher.ast.model.CypherSetClause;
import org.vertexium.cypher.ast.model.CypherSetItem;
import org.vertexium.cypher.ast.model.CypherSetNodeLabels;
import org.vertexium.cypher.ast.model.CypherSetProperty;
import org.vertexium.cypher.ast.model.CypherSetVariable;
import org.vertexium.cypher.ast.model.CypherSkip;
import org.vertexium.cypher.ast.model.CypherSortItem;
import org.vertexium.cypher.ast.model.CypherStatement;
import org.vertexium.cypher.ast.model.CypherString;
import org.vertexium.cypher.ast.model.CypherStringMatch;
import org.vertexium.cypher.ast.model.CypherTrueExpression;
import org.vertexium.cypher.ast.model.CypherUnaryExpression;
import org.vertexium.cypher.ast.model.CypherUnion;
import org.vertexium.cypher.ast.model.CypherUnwindClause;
import org.vertexium.cypher.ast.model.CypherVariable;
import org.vertexium.cypher.ast.model.CypherWithClause;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;
import org.vertexium.cypher.exceptions.VertexiumCypherSyntaxErrorException;
import org.vertexium.cypher.functions.CypherFunction;
import org.vertexium.util.StreamUtils;

public class CypherCstToAstVisitor
extends CypherBaseVisitor<CypherAstBase> {
    private final CypherCompilerContext compilerContext;

    public CypherCstToAstVisitor() {
        this(new CypherCompilerContext());
    }

    public CypherCstToAstVisitor(CypherCompilerContext compilerContext) {
        this.compilerContext = compilerContext;
    }

    @Override
    public CypherStatement visitStatement(CypherParser.StatementContext ctx) {
        return new CypherStatement(this.visitQuery(ctx.query()));
    }

    @Override
    public CypherAstBase visitQuery(CypherParser.QueryContext ctx) {
        return this.visitRegularQuery(ctx.regularQuery());
    }

    @Override
    public CypherAstBase visitRegularQuery(CypherParser.RegularQueryContext ctx) {
        CypherQuery left = this.visitSingleQuery(ctx.singleQuery());
        if (ctx.union().size() > 0) {
            return this.visitUnions(left, ctx.union());
        }
        return left;
    }

    @Override
    public CypherQuery visitSingleQuery(CypherParser.SingleQueryContext ctx) {
        return new CypherQuery((ImmutableList<CypherClause>)((ImmutableList)ctx.clause().stream().map(this::visitClause).collect(StreamUtils.toImmutableList())));
    }

    @Override
    public CypherClause visitClause(CypherParser.ClauseContext ctx) {
        Object o = super.visitClause(ctx);
        if (!(o instanceof CypherClause)) {
            throw new VertexiumException("clause not supported: " + ctx.getText());
        }
        return (CypherClause)o;
    }

    @Override
    public CypherCreateClause visitCreate(CypherParser.CreateContext ctx) {
        ImmutableList patternParts = (ImmutableList)ctx.pattern().patternPart().stream().map(this::visitPatternPart).collect(StreamUtils.toImmutableList());
        return new CypherCreateClause((ImmutableList<CypherPatternPart>)patternParts);
    }

    @Override
    public CypherReturnClause visitReturnClause(CypherParser.ReturnClauseContext ctx) {
        boolean distinct = ctx.DISTINCT() != null;
        return new CypherReturnClause(distinct, this.visitReturnBody(ctx.returnBody()));
    }

    @Override
    public CypherReturnBody visitReturnBody(CypherParser.ReturnBodyContext ctx) {
        CypherParser.OrderContext order = ctx.order();
        CypherParser.LimitContext limit = ctx.limit();
        CypherParser.SkipContext skip = ctx.skip();
        return new CypherReturnBody((CypherListLiteral<CypherReturnItem>)this.visitReturnItems(ctx.returnItems()), order == null ? null : this.visitOrder(order), limit == null ? null : this.visitLimit(limit), skip == null ? null : this.visitSkip(skip));
    }

    @Override
    public CypherMatchClause visitMatch(CypherParser.MatchContext ctx) {
        boolean optional = ctx.OPTIONAL() != null;
        Object patternParts = this.visitPattern(ctx.pattern());
        CypherAstBase whereExpression = this.visitWhere(ctx.where());
        return new CypherMatchClause(optional, (CypherListLiteral<CypherPatternPart>)patternParts, whereExpression);
    }

    @Override
    public CypherListLiteral<CypherPatternPart> visitPattern(CypherParser.PatternContext ctx) {
        return ctx.patternPart().stream().map(this::visitPatternPart).collect(CypherListLiteral.collect());
    }

    @Override
    public CypherPatternPart visitPatternPart(CypherParser.PatternPartContext ctx) {
        String name = this.visitVariableString(ctx.variable());
        Object elementPatterns = this.visitAnonymousPatternPart(ctx.anonymousPatternPart());
        return new CypherPatternPart(name, (CypherListLiteral<CypherElementPattern>)elementPatterns);
    }

    @Override
    public CypherListLiteral<CypherElementPattern> visitAnonymousPatternPart(CypherParser.AnonymousPatternPartContext ctx) {
        return this.visitPatternElement(ctx.patternElement());
    }

    @Override
    public CypherListLiteral<CypherElementPattern> visitPatternElement(CypherParser.PatternElementContext ctx) {
        if (ctx.patternElement() != null) {
            return this.visitPatternElement(ctx.patternElement());
        }
        ArrayList<CypherElementPattern> list = new ArrayList<CypherElementPattern>();
        CypherNodePattern nodePattern = this.visitNodePattern(ctx.nodePattern());
        list.add(nodePattern);
        list.addAll(this.visitPatternElementChainList(nodePattern, ctx.patternElementChain()));
        return new CypherListLiteral<CypherElementPattern>((List<CypherElementPattern>)list);
    }

    private List<CypherElementPattern> visitPatternElementChainList(CypherNodePattern previousNodePattern, List<CypherParser.PatternElementChainContext> patternElementChainList) {
        ArrayList<CypherElementPattern> list = new ArrayList<CypherElementPattern>();
        for (CypherParser.PatternElementChainContext chainContext : patternElementChainList) {
            CypherRelationshipPattern relationshipPattern = this.visitRelationshipPattern(chainContext.relationshipPattern());
            relationshipPattern.setPreviousNodePattern(previousNodePattern);
            list.add(relationshipPattern);
            CypherNodePattern nodePattern = this.visitNodePattern(chainContext.nodePattern());
            relationshipPattern.setNextNodePattern(nodePattern);
            list.add(nodePattern);
            previousNodePattern = nodePattern;
        }
        return list;
    }

    @Override
    public CypherNodePattern visitNodePattern(CypherParser.NodePatternContext ctx) {
        return new CypherNodePattern(this.visitVariableString(ctx.variable()), (CypherMapLiteral<String, CypherAstBase>)this.visitProperties(ctx.properties()), (CypherListLiteral<CypherLabelName>)this.visitNodeLabels(ctx.nodeLabels()));
    }

    @Override
    public CypherRelationshipPattern visitRelationshipPattern(CypherParser.RelationshipPatternContext ctx) {
        CypherRangeLiteral range;
        Object properties;
        Object relTypeNames;
        String name;
        CypherParser.RelationshipDetailContext relationshipDetail = ctx.relationshipDetail();
        if (relationshipDetail == null) {
            name = null;
            relTypeNames = null;
            properties = null;
            range = null;
        } else {
            range = relationshipDetail.rangeLiteral() != null ? this.visitRangeLiteral(relationshipDetail.rangeLiteral()) : null;
            name = this.visitVariableString(relationshipDetail.variable());
            relTypeNames = relationshipDetail.relationshipTypes() == null ? null : this.visitRelationshipTypes(relationshipDetail.relationshipTypes());
            properties = this.visitProperties(relationshipDetail.properties());
        }
        CypherDirection direction = CypherCstToAstVisitor.getDirectionFromRelationshipPattern(ctx);
        return new CypherRelationshipPattern(name, (CypherListLiteral<CypherRelTypeName>)relTypeNames, (CypherMapLiteral<String, CypherAstBase>)properties, range, direction);
    }

    private static CypherDirection getDirectionFromRelationshipPattern(CypherParser.RelationshipPatternContext relationshipPatternContext) {
        if (relationshipPatternContext.leftArrowHead() != null && relationshipPatternContext.rightArrowHead() != null) {
            return CypherDirection.BOTH;
        }
        if (relationshipPatternContext.leftArrowHead() != null) {
            return CypherDirection.IN;
        }
        if (relationshipPatternContext.rightArrowHead() != null) {
            return CypherDirection.OUT;
        }
        return CypherDirection.UNSPECIFIED;
    }

    @Override
    public CypherMapLiteral<String, CypherAstBase> visitProperties(CypherParser.PropertiesContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (CypherMapLiteral)super.visitProperties(ctx);
    }

    @Override
    public CypherMapLiteral<String, CypherAstBase> visitMapLiteral(CypherParser.MapLiteralContext ctx) {
        List<CypherParser.PropertyKeyNameContext> keys = ctx.propertyKeyName();
        List<CypherParser.ExpressionContext> values = ctx.expression();
        HashMap<String, CypherAstBase> result = new HashMap<String, CypherAstBase>();
        int keysSize = keys.size();
        for (int i = 0; i < keysSize; ++i) {
            String key = (String)this.visitPropertyKeyName(keys.get(i)).getValue();
            CypherAstBase value = this.visitExpression(values.get(i));
            result.put(key, value);
        }
        return new CypherMapLiteral<String, CypherAstBase>((Map<String, CypherAstBase>)result);
    }

    @Override
    public CypherString visitPropertyKeyName(CypherParser.PropertyKeyNameContext ctx) {
        return this.visitSymbolicName(ctx.symbolicName());
    }

    @Override
    public CypherListLiteral<CypherLabelName> visitNodeLabels(CypherParser.NodeLabelsContext ctx) {
        if (ctx == null) {
            return new CypherListLiteral<CypherLabelName>();
        }
        return ctx.nodeLabel().stream().map(nl -> this.visitLabelName(nl.labelName())).collect(CypherListLiteral.collect());
    }

    @Override
    public CypherLabelName visitLabelName(CypherParser.LabelNameContext ctx) {
        return new CypherLabelName((String)this.visitSymbolicName(ctx.symbolicName()).getValue());
    }

    @Override
    public CypherAstBase visitPatternElementChain(CypherParser.PatternElementChainContext ctx) {
        throw new VertexiumException("should not be called, see visitPatternElementChainList");
    }

    @Override
    public CypherUnwindClause visitUnwind(CypherParser.UnwindContext ctx) {
        String name = this.visitVariableString(ctx.variable());
        CypherAstBase expression = this.visitExpression(ctx.expression());
        return new CypherUnwindClause(name, expression);
    }

    @Override
    public CypherWithClause visitWith(CypherParser.WithContext ctx) {
        boolean distinct = ctx.DISTINCT() != null;
        CypherReturnBody returnBody = this.visitReturnBody(ctx.returnBody());
        CypherAstBase where = this.visitWhere(ctx.where());
        return new CypherWithClause(distinct, returnBody, where);
    }

    @Override
    public CypherMergeClause visitMerge(CypherParser.MergeContext ctx) {
        CypherPatternPart patternPart = this.visitPatternPart(ctx.patternPart());
        List<CypherMergeAction> mergeActions = ctx.mergeAction().stream().map(this::visitMergeAction).collect(Collectors.toList());
        return new CypherMergeClause(patternPart, mergeActions);
    }

    @Override
    public CypherAstBase visitWhere(CypherParser.WhereContext ctx) {
        if (ctx == null) {
            return null;
        }
        return this.visitExpression(ctx.expression());
    }

    public CypherListLiteral<CypherAstBase> visitExpressions(Iterable<CypherParser.ExpressionContext> expressionContexts) {
        return StreamUtils.stream((Iterable[])new Iterable[]{expressionContexts}).map(this::visitExpression).collect(CypherListLiteral.collect());
    }

    @Override
    public CypherAstBase visitExpression(CypherParser.ExpressionContext ctx) {
        return this.visitExpression12(ctx.expression12());
    }

    @Override
    public CypherAstBase visitExpression12(CypherParser.Expression12Context ctx) {
        List<CypherParser.Expression11Context> children = ctx.expression11();
        if (children.size() == 1) {
            return this.visitExpression11(children.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression11);
    }

    @Override
    public CypherAstBase visitExpression11(CypherParser.Expression11Context ctx) {
        List<CypherParser.Expression10Context> children = ctx.expression10();
        if (children.size() == 1) {
            return this.visitExpression10(children.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression10);
    }

    @Override
    public CypherAstBase visitExpression10(CypherParser.Expression10Context ctx) {
        List<CypherParser.Expression9Context> children = ctx.expression9();
        if (children.size() == 1) {
            return this.visitExpression9(children.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression9);
    }

    private <T extends ParseTree> CypherBinaryExpression toBinaryExpressions(List<ParseTree> children, Function<T, CypherAstBase> itemTransform) {
        CypherAstBase left = null;
        CypherBinaryExpression.Op op = null;
        for (int i = 0; i < children.size(); ++i) {
            ParseTree child = children.get(i);
            if (child instanceof TerminalNode) {
                CypherBinaryExpression.Op newOp = CypherBinaryExpression.Op.parseOrNull(child.getText());
                if (newOp == null) continue;
                if (op == null) {
                    op = newOp;
                    continue;
                }
                throw new VertexiumException("unexpected op, found too many ops in a row");
            }
            CypherAstBase childObj = itemTransform.apply(child);
            if (left == null) {
                left = childObj;
            } else {
                if (op == null) {
                    throw new VertexiumException("unexpected binary expression. expected an op between expressions");
                }
                left = new CypherBinaryExpression(left, op, childObj);
            }
            op = null;
        }
        return (CypherBinaryExpression)left;
    }

    @Override
    public CypherAstBase visitExpression9(CypherParser.Expression9Context ctx) {
        if (ctx.NOT().size() % 2 == 0) {
            return this.visitExpression8(ctx.expression8());
        }
        return new CypherUnaryExpression(CypherUnaryExpression.Op.NOT, this.visitExpression8(ctx.expression8()));
    }

    @Override
    public CypherAstBase visitExpression8(CypherParser.Expression8Context ctx) {
        List<CypherParser.PartialComparisonExpressionContext> partialComparisonExpressions = ctx.partialComparisonExpression();
        if (partialComparisonExpressions.size() == 0) {
            return this.visitExpression7(ctx.expression7());
        }
        CypherAstBase left = this.visitExpression7(ctx.expression7());
        String op = ((ParseTree)partialComparisonExpressions.get((int)0).children.get(0)).getText();
        CypherAstBase right = this.visitExpression7(partialComparisonExpressions.get(0).expression7());
        return new CypherBinaryExpression(new CypherComparisonExpression(left, op, right), CypherBinaryExpression.Op.AND, this.visitPartialComparisonExpression(right, 1, partialComparisonExpressions));
    }

    private CypherExpression visitPartialComparisonExpression(CypherAstBase left, int partialComparisonExpressionIndex, List<CypherParser.PartialComparisonExpressionContext> partialComparisonExpressions) {
        if (partialComparisonExpressionIndex >= partialComparisonExpressions.size()) {
            return new CypherTrueExpression();
        }
        String op = ((ParseTree)partialComparisonExpressions.get((int)partialComparisonExpressionIndex).children.get(0)).getText();
        CypherAstBase right = this.visitExpression7(partialComparisonExpressions.get(partialComparisonExpressionIndex).expression7());
        CypherComparisonExpression binLeft = new CypherComparisonExpression(left, op, right);
        CypherExpression binRight = this.visitPartialComparisonExpression(right, partialComparisonExpressionIndex + 1, partialComparisonExpressions);
        if (binRight instanceof CypherTrueExpression) {
            return binLeft;
        }
        return new CypherBinaryExpression(binLeft, CypherBinaryExpression.Op.AND, binRight);
    }

    @Override
    public CypherAstBase visitExpression7(CypherParser.Expression7Context ctx) {
        List<CypherParser.Expression6Context> expression6s = ctx.expression6();
        if (expression6s.size() == 1) {
            return this.visitExpression6(expression6s.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression6);
    }

    @Override
    public CypherAstBase visitExpression6(CypherParser.Expression6Context ctx) {
        List<CypherParser.Expression5Context> expression5s = ctx.expression5();
        if (expression5s.size() == 1) {
            return this.visitExpression5(expression5s.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression5);
    }

    @Override
    public CypherAstBase visitExpression5(CypherParser.Expression5Context ctx) {
        List<CypherParser.Expression4Context> expression4s = ctx.expression4();
        if (expression4s.size() == 1) {
            return this.visitExpression4(expression4s.get(0));
        }
        return this.toBinaryExpressions(ctx.children, this::visitExpression4);
    }

    @Override
    public CypherAstBase visitExpression4(CypherParser.Expression4Context ctx) {
        int neg = 0;
        for (ParseTree child : ctx.children) {
            if (!(child instanceof TerminalNode) || !child.getText().equals("-")) continue;
            ++neg;
        }
        CypherAstBase expr = this.visitExpression3(ctx.expression3());
        if (neg % 2 == 1) {
            return new CypherNegateExpression(expr);
        }
        return expr;
    }

    @Override
    public CypherAstBase visitExpression3(CypherParser.Expression3Context ctx) {
        if (ctx.children.size() == 1) {
            return this.visitExpression2(ctx.expression2(0));
        }
        return this.visitExpression3(this.filterSpaces(ctx.children).collect(Collectors.toList()));
    }

    private Stream<ParseTree> filterSpaces(List<ParseTree> items) {
        return items.stream().filter(item -> item.getText().trim().length() > 0);
    }

    private CypherAstBase visitExpression3(List<ParseTree> children) {
        if (children.size() == 6 && children.get(1).getText().equals("[") && children.get(3).getText().equals("..") && children.get(5).getText().equals("]")) {
            CypherAstBase arrayExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            CypherAstBase sliceFrom = this.visitExpression((CypherParser.ExpressionContext)children.get(2));
            CypherAstBase sliceTo = this.visitExpression((CypherParser.ExpressionContext)children.get(4));
            return new CypherArraySlice(arrayExpression, sliceFrom, sliceTo);
        }
        if (children.size() > 2 && children.get(1).getText().equalsIgnoreCase("IN")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            List<ParseTree> remainingChildren = children.stream().skip(2L).collect(Collectors.toList());
            CypherAstBase arrExpression = remainingChildren.size() == 1 ? this.visitExpression2((CypherParser.Expression2Context)remainingChildren.get(0)) : this.visitExpression3(remainingChildren);
            return new CypherIn(valueExpression, arrExpression);
        }
        if (children.size() == 3 && children.get(1).getText().equalsIgnoreCase("IS") && children.get(2).getText().equalsIgnoreCase("NULL")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            return new CypherIsNull(valueExpression);
        }
        if (children.size() == 4 && children.get(1).getText().equalsIgnoreCase("IS") && children.get(2).getText().equalsIgnoreCase("NOT") && children.get(3).getText().equalsIgnoreCase("NULL")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            return new CypherIsNotNull(valueExpression);
        }
        if (children.size() == 4 && children.get(1).getText().equalsIgnoreCase("STARTS") && children.get(2).getText().equalsIgnoreCase("WITH")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            CypherAstBase stringExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(3));
            return new CypherStringMatch(valueExpression, stringExpression, CypherStringMatch.Op.STARTS_WITH);
        }
        if (children.size() == 4 && children.get(1).getText().equalsIgnoreCase("ENDS") && children.get(2).getText().equalsIgnoreCase("WITH")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            CypherAstBase stringExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(3));
            return new CypherStringMatch(valueExpression, stringExpression, CypherStringMatch.Op.ENDS_WITH);
        }
        if (children.size() == 3 && children.get(1).getText().equalsIgnoreCase("CONTAINS")) {
            CypherAstBase valueExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            CypherAstBase stringExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(2));
            return new CypherStringMatch(valueExpression, stringExpression, CypherStringMatch.Op.CONTAINS);
        }
        if (children.size() >= 4 && children.get(1).getText().equals("[") && children.get(3).getText().equals("]")) {
            CypherAstBase arrayExpression = this.visitExpression2((CypherParser.Expression2Context)children.get(0));
            CypherAstBase indexExpression = this.visitExpression((CypherParser.ExpressionContext)children.get(2));
            CypherArrayAccess arrayAccess = new CypherArrayAccess(arrayExpression, indexExpression);
            children = children.subList(4, children.size());
            while (children.size() > 0) {
                indexExpression = this.visitExpression((CypherParser.ExpressionContext)children.get(1));
                arrayAccess = new CypherArrayAccess(arrayAccess, indexExpression);
                children = children.subList(3, children.size());
            }
            return arrayAccess;
        }
        throw new VertexiumCypherNotImplemented("" + children.stream().map(ParseTree::getText).collect(Collectors.joining(", ")));
    }

    @Override
    public CypherAstBase visitExpression2(CypherParser.Expression2Context ctx) {
        CypherParser.AtomContext atom = ctx.atom();
        List<CypherParser.PropertyLookupContext> propertyLookups = ctx.propertyLookup();
        List<CypherParser.NodeLabelsContext> nodeLabels = ctx.nodeLabels();
        if (!(propertyLookups != null && propertyLookups.size() != 0 || nodeLabels != null && nodeLabels.size() != 0)) {
            if (ctx.children.size() != 1) {
                throw new VertexiumCypherSyntaxErrorException("invalid expression \"" + ctx.getText() + "\"");
            }
            return this.visitAtom(atom);
        }
        return this.createLookup(atom, propertyLookups, nodeLabels);
    }

    private CypherLookup createLookup(CypherParser.AtomContext atomCtx, List<CypherParser.PropertyLookupContext> propertyLookups, List<CypherParser.NodeLabelsContext> nodeLabels) {
        CypherAstBase atom = this.visitAtom(atomCtx);
        if (propertyLookups.size() == 0 && nodeLabels.size() == 0) {
            return new CypherLookup(atom, null, null);
        }
        String property = propertyLookups.stream().map(pl -> (String)this.visitPropertyLookup((CypherParser.PropertyLookupContext)((Object)pl)).getValue()).collect(Collectors.joining("."));
        if (property.length() == 0) {
            property = null;
        }
        List labels = nodeLabels == null ? null : nodeLabels.stream().flatMap(l -> ((List)((CypherLiteral)this.visitNodeLabels((CypherParser.NodeLabelsContext)((Object)l))).getValue()).stream()).collect(Collectors.toList());
        return new CypherLookup(atom, property, labels);
    }

    @Override
    public CypherString visitPropertyLookup(CypherParser.PropertyLookupContext ctx) {
        return this.visitPropertyKeyName(ctx.propertyKeyName());
    }

    @Override
    public CypherAstBase visitAtom(CypherParser.AtomContext ctx) {
        if (ctx.COUNT() != null) {
            return new CypherFunctionInvocation("count", false, new CypherMatchAll());
        }
        return (CypherAstBase)super.visitAtom(ctx);
    }

    @Override
    public CypherLiteral visitLiteral(CypherParser.LiteralContext ctx) {
        if (ctx.StringLiteral() != null) {
            String text = ctx.StringLiteral().getText();
            return new CypherString(text.substring(1, text.length() - 1));
        }
        return (CypherLiteral)super.visitLiteral(ctx);
    }

    @Override
    public CypherVariable visitVariable(CypherParser.VariableContext ctx) {
        if (ctx == null) {
            return null;
        }
        String name = (String)this.visitSymbolicName(ctx.symbolicName()).getValue();
        if (name == null) {
            return null;
        }
        return new CypherVariable(name);
    }

    public String visitVariableString(CypherParser.VariableContext ctx) {
        CypherVariable v = this.visitVariable(ctx);
        if (v == null) {
            return null;
        }
        return v.getName();
    }

    @Override
    public CypherString visitSymbolicName(CypherParser.SymbolicNameContext ctx) {
        if (ctx.EscapedSymbolicName() != null) {
            return this.visitEscapedSymbolicName(ctx.EscapedSymbolicName());
        }
        return new CypherString(ctx.getText());
    }

    @Override
    public CypherListLiteral<CypherReturnItem> visitReturnItems(CypherParser.ReturnItemsContext ctx) {
        if (((ParseTree)ctx.children.get(0)).getText().equals("*")) {
            return CypherListLiteral.of(new CypherReturnItem("*", new CypherAllLiteral(), null));
        }
        return ctx.returnItem().stream().map(this::visitReturnItem).collect(CypherListLiteral.collect());
    }

    @Override
    public CypherReturnItem visitReturnItem(CypherParser.ReturnItemContext ctx) {
        return new CypherReturnItem(ctx.getText(), this.visitExpression(ctx.expression()), this.visitVariableString(ctx.variable()));
    }

    @Override
    public CypherAstBase visitPartialComparisonExpression(CypherParser.PartialComparisonExpressionContext ctx) {
        throw new VertexiumCypherNotImplemented("PartialComparisonExpression");
    }

    @Override
    public CypherAstBase visitParenthesizedExpression(CypherParser.ParenthesizedExpressionContext ctx) {
        return this.visitExpression(ctx.expression());
    }

    @Override
    public CypherPatternComprehension visitPatternComprehension(CypherParser.PatternComprehensionContext ctx) {
        CypherVariable variable = ctx.variable() == null ? null : this.visitVariable(ctx.variable());
        CypherRelationshipsPattern relationshipsPattern = this.visitRelationshipsPattern(ctx.relationshipsPattern());
        List<CypherParser.ExpressionContext> expressions = ctx.expression();
        CypherAstBase whereExpression = expressions.size() > 1 ? this.visitExpression(expressions.get(0)) : null;
        CypherAstBase expression = this.visitExpression(expressions.get(expressions.size() - 1));
        ArrayList patternPartPatterns = Lists.newArrayList((Object[])new CypherElementPattern[]{relationshipsPattern.getNodePattern()});
        for (CypherElementPattern elementPattern : relationshipsPattern.getPatternElementChains()) {
            patternPartPatterns.add(elementPattern);
        }
        CypherPatternPart patternPart = new CypherPatternPart(variable == null ? null : variable.getName(), new CypherListLiteral<CypherElementPattern>(patternPartPatterns));
        CypherMatchClause matchClause = new CypherMatchClause(false, CypherListLiteral.of(patternPart), whereExpression);
        return new CypherPatternComprehension(matchClause, expression);
    }

    @Override
    public CypherLimit visitLimit(CypherParser.LimitContext ctx) {
        String expressionText = ctx.expression().getText();
        Integer i = this.tryParseInteger(expressionText);
        if (i != null && i < 0) {
            throw new VertexiumCypherSyntaxErrorException("NegativeIntegerArgument: limit should only have positive arguments: " + expressionText);
        }
        CypherAstBase expression = this.visitExpression(ctx.expression());
        return new CypherLimit(expression);
    }

    private Integer tryParseInteger(String expressionText) {
        try {
            return Integer.parseInt(expressionText);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public CypherBoolean visitBooleanLiteral(CypherParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return new CypherBoolean(true);
        }
        if (ctx.FALSE() != null) {
            return new CypherBoolean(false);
        }
        throw new VertexiumException("unexpected boolean: " + ctx.getText());
    }

    @Override
    public CypherOrderBy visitOrder(CypherParser.OrderContext ctx) {
        List<CypherSortItem> sortItems = ctx.sortItem().stream().map(this::visitSortItem).collect(Collectors.toList());
        return new CypherOrderBy(sortItems);
    }

    @Override
    public CypherIdInColl visitIdInColl(CypherParser.IdInCollContext ctx) {
        CypherVariable variable = this.visitVariable(ctx.variable());
        CypherAstBase expression = this.visitExpression(ctx.expression());
        return new CypherIdInColl(variable, expression);
    }

    @Override
    public CypherRelTypeName visitRelTypeName(CypherParser.RelTypeNameContext ctx) {
        return new CypherRelTypeName((String)this.visitSymbolicName(ctx.symbolicName()).getValue());
    }

    @Override
    public CypherDouble visitDoubleLiteral(CypherParser.DoubleLiteralContext ctx) {
        return new CypherDouble(Double.parseDouble(ctx.getText()));
    }

    @Override
    public CypherAstBase visitDash(CypherParser.DashContext ctx) {
        throw new VertexiumCypherNotImplemented("Dash");
    }

    @Override
    public CypherAstBase visitNodeLabel(CypherParser.NodeLabelContext ctx) {
        throw new VertexiumCypherNotImplemented("NodeLabel");
    }

    @Override
    public CypherAstBase visitRightArrowHead(CypherParser.RightArrowHeadContext ctx) {
        throw new VertexiumCypherNotImplemented("RightArrowHead");
    }

    @Override
    public CypherAstBase visitPropertyExpression(CypherParser.PropertyExpressionContext ctx) {
        if (ctx.propertyLookup() != null) {
            return this.createLookup(ctx.atom(), ctx.propertyLookup(), null);
        }
        return this.visitAtom(ctx.atom());
    }

    @Override
    public CypherRemoveItem visitRemoveItem(CypherParser.RemoveItemContext ctx) {
        if (ctx.propertyExpression() != null) {
            return new CypherRemovePropertyExpressionItem(this.visitPropertyExpression(ctx.propertyExpression()));
        }
        return new CypherRemoveLabelItem(this.visitVariable(ctx.variable()), (CypherListLiteral<CypherLabelName>)this.visitNodeLabels(ctx.nodeLabels()));
    }

    @Override
    public CypherListLiteral<CypherAstBase> visitListLiteral(CypherParser.ListLiteralContext ctx) {
        return this.visitExpressions(ctx.expression());
    }

    @Override
    public CypherSkip visitSkip(CypherParser.SkipContext ctx) {
        CypherAstBase expression = this.visitExpression(ctx.expression());
        return new CypherSkip(expression);
    }

    @Override
    public CypherAstBase visitLeftArrowHead(CypherParser.LeftArrowHeadContext ctx) {
        throw new VertexiumCypherNotImplemented("LeftArrowHead");
    }

    @Override
    public CypherAstBase visitDelete(CypherParser.DeleteContext ctx) {
        boolean detach = ctx.DETACH() != null;
        CypherListLiteral<CypherAstBase> expressions = this.visitExpressions(ctx.expression());
        return new CypherDeleteClause(expressions, detach);
    }

    @Override
    public CypherAstBase visitRemove(CypherParser.RemoveContext ctx) {
        List<CypherRemoveItem> removeItems = ctx.removeItem().stream().map(this::visitRemoveItem).collect(Collectors.toList());
        return new CypherRemoveClause(removeItems);
    }

    @Override
    public CypherAstBase visitFunctionInvocation(CypherParser.FunctionInvocationContext ctx) {
        String functionName = (String)this.visitFunctionName(ctx.functionName()).getValue();
        CypherFunction fn = this.compilerContext.getFunction(functionName);
        if (fn == null) {
            throw new VertexiumCypherSyntaxErrorException("UnknownFunction: Could not find function with name \"" + functionName + "\"");
        }
        boolean distinct = ctx.DISTINCT() != null;
        CypherListLiteral<CypherAstBase> argumentsList = this.visitExpressions(ctx.expression());
        CypherAstBase[] arguments = argumentsList.toArray((CypherAstBase[])new CypherAstBase[argumentsList.size()]);
        fn.compile(this.compilerContext, arguments);
        return new CypherFunctionInvocation(functionName, distinct, arguments);
    }

    @Override
    public CypherAstBase visitListComprehension(CypherParser.ListComprehensionContext ctx) {
        CypherFilterExpression filterExpression = this.visitFilterExpression(ctx.filterExpression());
        CypherAstBase expression = ctx.expression() == null ? null : this.visitExpression(ctx.expression());
        return new CypherListComprehension(filterExpression, expression);
    }

    @Override
    public CypherStatement visitCypher(CypherParser.CypherContext ctx) {
        return this.visitStatement(ctx.statement());
    }

    @Override
    public CypherAstBase visitParameter(CypherParser.ParameterContext ctx) {
        if (ctx.symbolicName() != null) {
            String parameterName = (String)this.visitSymbolicName(ctx.symbolicName()).getValue();
            return new CypherNameParameter(parameterName);
        }
        if (ctx.DecimalInteger() != null) {
            return new CypherIndexedParameter(Integer.parseInt(ctx.DecimalInteger().getText()));
        }
        throw new VertexiumCypherNotImplemented("Parameter");
    }

    @Override
    public CypherMergeAction visitMergeAction(CypherParser.MergeActionContext ctx) {
        CypherSetClause set = this.visitSet(ctx.set());
        if (ctx.CREATE() != null) {
            return new CypherMergeActionCreate(set);
        }
        if (ctx.MATCH() != null) {
            return new CypherMergeActionMatch(set);
        }
        throw new VertexiumCypherSyntaxErrorException("Expected ON CREATE or ON MATCH");
    }

    @Override
    public CypherSortItem visitSortItem(CypherParser.SortItemContext ctx) {
        CypherAstBase expr = this.visitExpression(ctx.expression());
        CypherSortItem.Direction direction = ctx.DESC() != null || ctx.DESCENDING() != null ? CypherSortItem.Direction.DESCENDING : CypherSortItem.Direction.ASCENDING;
        return new CypherSortItem(expr, direction);
    }

    @Override
    public CypherSetItem visitSetItem(CypherParser.SetItemContext ctx) {
        if (ctx.propertyExpression() != null) {
            CypherAstBase lookup = this.visitPropertyExpression(ctx.propertyExpression());
            if (!(lookup instanceof CypherLookup)) {
                throw new VertexiumException("expected " + CypherLookup.class.getName() + " found " + lookup.getClass().getName());
            }
            return new CypherSetProperty((CypherLookup)lookup, this.visitExpression(ctx.expression()));
        }
        if (ctx.nodeLabels() != null) {
            return new CypherSetNodeLabels(this.visitVariable(ctx.variable()), (CypherListLiteral<CypherLabelName>)this.visitNodeLabels(ctx.nodeLabels()));
        }
        CypherSetItem.Op op = this.getSetItemOp(ctx);
        return new CypherSetVariable(this.visitVariable(ctx.variable()), op, this.visitExpression(ctx.expression()));
    }

    private CypherSetItem.Op getSetItemOp(CypherParser.SetItemContext ctx) {
        for (ParseTree child : ctx.children) {
            if (!(child instanceof TerminalNode)) continue;
            String text = child.getText();
            if (text.equals("+=")) {
                return CypherSetItem.Op.PLUS_EQUAL;
            }
            if (!text.equals("=")) continue;
            return CypherSetItem.Op.EQUAL;
        }
        throw new VertexiumException("Could not find set item op: " + ctx.getText());
    }

    @Override
    public CypherSetClause visitSet(CypherParser.SetContext ctx) {
        return new CypherSetClause(ctx.setItem().stream().map(this::visitSetItem).collect(Collectors.toList()));
    }

    @Override
    public CypherString visitFunctionName(CypherParser.FunctionNameContext ctx) {
        if (ctx.UnescapedSymbolicName() != null) {
            return this.visitUnescapedSymbolicName(ctx.UnescapedSymbolicName());
        }
        if (ctx.EscapedSymbolicName() != null) {
            return this.visitEscapedSymbolicName(ctx.EscapedSymbolicName());
        }
        if (ctx.COUNT() != null) {
            return new CypherString("count");
        }
        throw new VertexiumException("unexpected function name: " + ctx.getText());
    }

    private CypherString visitEscapedSymbolicName(TerminalNode escapedSymbolicName) {
        String text = escapedSymbolicName.getText();
        text = text.substring(1, text.length() - 1);
        return new CypherString(text);
    }

    private CypherString visitUnescapedSymbolicName(TerminalNode unescapedSymbolicName) {
        return new CypherString(unescapedSymbolicName.getText());
    }

    @Override
    public CypherRelationshipsPattern visitRelationshipsPattern(CypherParser.RelationshipsPatternContext ctx) {
        CypherNodePattern nodePattern = this.visitNodePattern(ctx.nodePattern());
        List<CypherElementPattern> patternElementChains = this.visitPatternElementChainList(nodePattern, ctx.patternElementChain());
        return new CypherRelationshipsPattern(nodePattern, patternElementChains);
    }

    private CypherAstBase visitUnions(CypherQuery left, List<CypherParser.UnionContext> unions) {
        if (unions.size() == 0) {
            return left;
        }
        CypherParser.UnionContext firstUnion = unions.get(0);
        boolean all = firstUnion.ALL() != null;
        CypherQuery right = this.visitSingleQuery(firstUnion.singleQuery());
        return new CypherUnion(left, this.visitUnions(right, unions.subList(1, unions.size())), all);
    }

    @Override
    public CypherUnion visitUnion(CypherParser.UnionContext ctx) {
        throw new VertexiumCypherNotImplemented("Union");
    }

    @Override
    public CypherAstBase visitRelationshipDetail(CypherParser.RelationshipDetailContext ctx) {
        throw new VertexiumCypherNotImplemented("RelationshipDetail");
    }

    @Override
    public CypherRangeLiteral visitRangeLiteral(CypherParser.RangeLiteralContext ctx) {
        Integer from = null;
        Integer to = null;
        boolean seenDotDot = false;
        for (ParseTree child : ctx.children) {
            if (child instanceof CypherParser.IntegerLiteralContext) {
                int i = this.visitIntegerLiteral((CypherParser.IntegerLiteralContext)child).getIntValue();
                if (seenDotDot) {
                    to = i;
                    continue;
                }
                from = i;
                continue;
            }
            String text = child.getText();
            if (text.equals("*") || !text.equals("..")) continue;
            seenDotDot = true;
        }
        if (!seenDotDot) {
            to = from;
        }
        return new CypherRangeLiteral(from, to);
    }

    @Override
    public CypherFilterExpression visitFilterExpression(CypherParser.FilterExpressionContext ctx) {
        CypherIdInColl idInCol = this.visitIdInColl(ctx.idInColl());
        CypherAstBase where = ctx.where() == null ? null : this.visitWhere(ctx.where());
        return new CypherFilterExpression(idInCol, where);
    }

    @Override
    public CypherInteger visitIntegerLiteral(CypherParser.IntegerLiteralContext ctx) {
        try {
            return new CypherInteger(Long.decode(ctx.getText()));
        }
        catch (NumberFormatException ex) {
            throw new VertexiumException("could not parse \"" + ctx.getText() + "\" into integer");
        }
    }

    @Override
    public CypherListLiteral<CypherRelTypeName> visitRelationshipTypes(CypherParser.RelationshipTypesContext ctx) {
        return ctx.relTypeName().stream().map(this::visitRelTypeName).collect(CypherListLiteral.collect());
    }

    @Override
    public CypherLiteral visitNumberLiteral(CypherParser.NumberLiteralContext ctx) {
        return (CypherLiteral)super.visitNumberLiteral(ctx);
    }

    public CypherAstBase visitErrorNode(ErrorNode node) {
        throw new VertexiumException(String.format("Could not parse: invalid value \"%s\" (line: %d, pos: %d)", node.getText(), node.getSymbol().getLine(), node.getSymbol().getCharPositionInLine()));
    }
}

