/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherExpression;

public class CypherBinaryExpression
extends CypherExpression {
    private final CypherAstBase left;
    private final Op op;
    private final CypherAstBase right;

    public CypherBinaryExpression(CypherAstBase left, Op op, CypherAstBase right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    public CypherAstBase getLeft() {
        return this.left;
    }

    public Op getOp() {
        return this.op;
    }

    public CypherAstBase getRight() {
        return this.right;
    }

    public String toString() {
        return String.format("%s %s %s", this.getLeft(), this.getOp().text, this.getRight());
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.of(this.left, this.right);
    }

    public static enum Op {
        ADD("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        POWER("^"),
        MOD("%"),
        OR("OR"),
        XOR("XOR"),
        AND("AND");

        private final String text;

        private Op(String text) {
            this.text = text;
        }

        public static Op parseOrNull(String text) {
            if (text.trim().length() == 0) {
                return null;
            }
            for (Op op : Op.values()) {
                if (!op.text.equals(text)) continue;
                return op;
            }
            return null;
        }
    }
}

