/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherClause;
import org.vertexium.cypher.ast.model.CypherDirection;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherPatternPart;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.exceptions.VertexiumCypherSyntaxErrorException;

public class CypherCreateClause
extends CypherClause {
    private final ImmutableList<CypherPatternPart> patternParts;

    public CypherCreateClause(ImmutableList<CypherPatternPart> patternParts) {
        this.checkRequiresDirectedRelationship(patternParts);
        this.patternParts = patternParts;
    }

    private void checkRequiresDirectedRelationship(ImmutableList<CypherPatternPart> patternParts) {
        for (CypherPatternPart patternPart : patternParts) {
            for (CypherElementPattern elementPattern : patternPart.getElementPatterns()) {
                CypherDirection direction;
                if (!(elementPattern instanceof CypherRelationshipPattern) || (direction = ((CypherRelationshipPattern)elementPattern).getDirection()).isDirected()) continue;
                throw new VertexiumCypherSyntaxErrorException("RequiresDirectedRelationship: Relationship create statements must have direction: " + elementPattern);
            }
        }
    }

    public ImmutableList<CypherPatternPart> getPatternParts() {
        return this.patternParts;
    }

    public String toString() {
        return String.format("CREATE %s", this.getPatternParts().stream().map(CypherPatternPart::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return this.patternParts.stream();
    }
}

