/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.Map;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherMapLiteral;
import org.vertexium.util.StreamUtils;

public abstract class CypherElementPattern
extends CypherAstBase {
    private final String name;
    private final CypherMapLiteral<String, CypherAstBase> propertiesMap;

    public CypherElementPattern(String name, CypherMapLiteral<String, CypherAstBase> propertiesMap) {
        if (propertiesMap == null) {
            propertiesMap = new CypherMapLiteral();
        }
        this.name = name;
        this.propertiesMap = propertiesMap;
    }

    public String getName() {
        return this.name;
    }

    public CypherMapLiteral<String, CypherAstBase> getPropertiesMap() {
        return this.propertiesMap;
    }

    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.size() > 0;
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return StreamUtils.stream((Iterable[])new Iterable[]{this.propertiesMap.entrySet()}).map(Map.Entry::getValue);
    }

    public String toString() {
        return this.getClass().getName() + "{name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CypherElementPattern that = (CypherElementPattern)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.propertiesMap.equals(that.propertiesMap);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.propertiesMap.hashCode();
        return result;
    }

    public int getConstraintCount() {
        return this.propertiesMap.size();
    }
}

