/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherLiteral;

public class CypherListLiteral<TItem>
extends CypherLiteral<List<TItem>>
implements Iterable<TItem> {
    public CypherListLiteral(List<TItem> list) {
        super(list);
    }

    public CypherListLiteral() {
        this(new ArrayList());
    }

    public TItem[] toArray(TItem[] arr) {
        return ((List)this.getValue()).toArray(arr);
    }

    public static <T> Collector<T, ArrayList<T>, CypherListLiteral<T>> collect() {
        return Collector.of(ArrayList::new, ArrayList::add, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }, CypherListLiteral::new, new Collector.Characteristics[0]);
    }

    public int size() {
        return ((List)this.getValue()).size();
    }

    public TItem get(int i) {
        return (TItem)((List)this.getValue()).get(i);
    }

    @Override
    public Iterator<TItem> iterator() {
        return ((List)this.getValue()).iterator();
    }

    public Stream<TItem> stream() {
        return ((List)this.getValue()).stream();
    }

    @Override
    public String toString() {
        String delimiter = this.size() > 0 && this.get(0) instanceof CypherLabelName ? "" : ", ";
        return this.toString(delimiter);
    }

    public String toString(String delimiter) {
        return this.stream().map(o -> o == null ? "null" : o.toString()).collect(Collectors.joining(delimiter));
    }

    public static <T> CypherListLiteral<T> of(T ... items) {
        return new CypherListLiteral(Lists.newArrayList((Object[])items));
    }
}

