/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.ast.model.CypherAstBase;

public class CypherLiteral<T>
extends CypherAstBase
implements Comparable {
    private final T value;

    public CypherLiteral(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public int compareTo(Object o) {
        if (!(this.getValue() instanceof Comparable)) {
            throw new VertexiumException("Literal value is not comparable (type: " + this.getValue().getClass().getName() + ")");
        }
        Comparable value = (Comparable)this.getValue();
        if (o instanceof CypherLiteral) {
            o = ((CypherLiteral)o).getValue();
        }
        return value.compareTo(o);
    }

    public String toString() {
        if (this.getValue() == null) {
            return "null";
        }
        return this.getValue().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CypherLiteral literal = (CypherLiteral)o;
        return !(this.value != null ? !this.value.equals(literal.value) : literal.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        if (this.value instanceof CypherAstBase) {
            return Stream.of((CypherAstBase)this.value);
        }
        return Stream.of(new CypherAstBase[0]);
    }
}

