/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherLiteral;

public class CypherLookup
extends CypherAstBase {
    private final CypherAstBase atom;
    private final String property;
    private final List<CypherLabelName> labels;

    public CypherLookup(CypherAstBase atom, String property, List<CypherLabelName> labels) {
        this.atom = atom;
        this.property = property;
        this.labels = labels;
    }

    public CypherAstBase getAtom() {
        return this.atom;
    }

    public String getProperty() {
        return this.property;
    }

    public List<CypherLabelName> getLabels() {
        return this.labels;
    }

    public boolean hasLabels() {
        return this.getLabels() != null && this.getLabels().size() > 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getAtom());
        if (this.hasLabels()) {
            result.append(this.getLabels().stream().map(CypherLabelName::toString).collect(Collectors.joining("")));
        }
        if (this.getProperty() != null) {
            result.append(".");
            result.append(this.getProperty());
        }
        return result.toString();
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.concat(Stream.of(this.atom), this.labels.stream().flatMap(CypherLiteral::getChildren));
    }
}

