/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherClause;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherPatternPart;

public class CypherMatchClause
extends CypherClause {
    private final CypherListLiteral<CypherPatternPart> patternParts;
    private final CypherAstBase whereExpression;
    private final boolean optional;

    public CypherMatchClause(boolean optional, CypherListLiteral<CypherPatternPart> patternParts, CypherAstBase whereExpression) {
        this.optional = optional;
        this.patternParts = patternParts;
        this.whereExpression = whereExpression;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public CypherListLiteral<CypherPatternPart> getPatternParts() {
        return this.patternParts;
    }

    public CypherAstBase getWhereExpression() {
        return this.whereExpression;
    }

    public String toString() {
        return String.format("%sMATCH %s%s", this.isOptional() ? "OPTIONAL " : "", this.getPatternParts().stream().map(CypherPatternPart::toString).collect(Collectors.joining(", ")), this.getWhereExpression() == null ? "" : " " + this.getWhereExpression());
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        if (this.whereExpression != null) {
            return Stream.concat(this.patternParts.stream(), Stream.of(this.whereExpression));
        }
        return this.patternParts.stream();
    }
}

