/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.List;
import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherClause;
import org.vertexium.cypher.ast.model.CypherMergeAction;
import org.vertexium.cypher.ast.model.CypherPatternPart;

public class CypherMergeClause
extends CypherClause {
    private final CypherPatternPart patternPart;
    private final List<CypherMergeAction> mergeActions;

    public CypherMergeClause(CypherPatternPart patternPart, List<CypherMergeAction> mergeActions) {
        this.patternPart = patternPart;
        this.mergeActions = mergeActions;
    }

    public CypherPatternPart getPatternPart() {
        return this.patternPart;
    }

    public List<CypherMergeAction> getMergeActions() {
        return this.mergeActions;
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.concat(Stream.of(this.getPatternPart()), this.getMergeActions().stream());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MERGE ");
        result.append(this.getPatternPart());
        for (CypherMergeAction mergeAction : this.getMergeActions()) {
            result.append(" ");
            result.append(mergeAction.toString());
        }
        return result.toString();
    }
}

