/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherMapLiteral;

public class CypherNodePattern
extends CypherElementPattern {
    private final CypherListLiteral<CypherLabelName> labelNames;

    public CypherNodePattern(String name, CypherMapLiteral<String, CypherAstBase> properties, CypherListLiteral<CypherLabelName> labelNames) {
        super(name, properties);
        this.labelNames = labelNames;
    }

    public CypherListLiteral<CypherLabelName> getLabelNames() {
        return this.labelNames;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        if (this.getName() != null) {
            result.append(this.getName());
        }
        if (this.getLabelNames() != null && this.getLabelNames().size() > 0) {
            result.append(this.getLabelNames());
        }
        if (this.getPropertiesMap() != null && this.getPropertiesMap().size() > 0) {
            result.append(" ").append(this.getPropertiesMap());
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.concat(super.getChildren(), this.labelNames.stream());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CypherNodePattern that = (CypherNodePattern)o;
        if (!(this.labelNames == null ? that.labelNames == null : this.labelNames.equals(that.labelNames))) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.labelNames != null ? this.labelNames.hashCode() : 0);
        return result;
    }

    @Override
    public int getConstraintCount() {
        return super.getConstraintCount() + (this.getLabelNames() == null ? 0 : this.getLabelNames().size());
    }
}

