/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherDirection;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherMapLiteral;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherRangeLiteral;
import org.vertexium.cypher.ast.model.CypherRelTypeName;

public class CypherRelationshipPattern
extends CypherElementPattern {
    private final CypherListLiteral<CypherRelTypeName> relTypeNames;
    private final CypherRangeLiteral range;
    private CypherDirection direction;
    private CypherNodePattern previousNodePattern;
    private CypherNodePattern nextNodePattern;

    public CypherRelationshipPattern(String name, CypherListLiteral<CypherRelTypeName> relTypeNames, CypherMapLiteral<String, CypherAstBase> properties, CypherRangeLiteral range, CypherDirection direction) {
        super(name, properties);
        this.relTypeNames = relTypeNames;
        this.range = range;
        this.direction = direction;
    }

    public CypherDirection getDirection() {
        return this.direction;
    }

    public CypherRangeLiteral getRange() {
        return this.range;
    }

    public CypherListLiteral<CypherRelTypeName> getRelTypeNames() {
        return this.relTypeNames;
    }

    public boolean hasRelTypeNames() {
        return this.getRelTypeNames() != null && this.getRelTypeNames().size() > 0;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.getDirection().hasIn()) {
            result.append("<");
        }
        result.append("-");
        if (this.getName() != null || this.getPropertiesMap() != null && this.getPropertiesMap().size() > 0 || this.getRelTypeNames() != null && this.getRelTypeNames().size() > 0 || this.getRange() != null) {
            result.append("[");
            if (this.getName() != null) {
                result.append(this.getName());
            }
            if (this.getRelTypeNames() != null && this.getRelTypeNames().size() > 0) {
                result.append(this.getRelTypeNames());
            }
            if (this.getPropertiesMap() != null && this.getPropertiesMap().size() > 0) {
                result.append(" ").append(this.getPropertiesMap());
            }
            if (this.getRange() != null) {
                result.append("*");
                result.append(this.getRange());
            }
            result.append("]");
        }
        result.append("-");
        if (this.getDirection().hasOut()) {
            result.append(">");
        }
        return result.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CypherRelationshipPattern that = (CypherRelationshipPattern)o;
        if (this.relTypeNames != null ? !this.relTypeNames.equals(that.relTypeNames) : that.relTypeNames != null) {
            return false;
        }
        if (this.range != null ? !this.range.equals(that.range) : that.range != null) {
            return false;
        }
        if (this.direction != that.direction) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.relTypeNames != null ? this.relTypeNames.hashCode() : 0);
        result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
        result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
        return result;
    }

    @Override
    public int getConstraintCount() {
        return super.getConstraintCount() + (this.getRelTypeNames() == null ? 0 : this.getRelTypeNames().size());
    }

    public void setPreviousNodePattern(CypherNodePattern previousNodePattern) {
        this.previousNodePattern = previousNodePattern;
    }

    public CypherNodePattern getPreviousNodePattern() {
        return this.previousNodePattern;
    }

    public void setNextNodePattern(CypherNodePattern nextNodePattern) {
        this.nextNodePattern = nextNodePattern;
    }

    public CypherNodePattern getNextNodePattern() {
        return this.nextNodePattern;
    }
}

