/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.ast.model.CypherAstBase;

public class CypherReturnItem
extends CypherAstBase {
    private final CypherAstBase expression;
    private final String alias;
    private final String originalText;

    public CypherReturnItem(String originalText, CypherAstBase expression, String alias) {
        this.originalText = originalText;
        if (expression == null && alias == null) {
            throw new VertexiumException("both expression and alias cannot be null");
        }
        this.expression = expression;
        this.alias = alias;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public CypherAstBase getExpression() {
        return this.expression;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getResultColumnName() {
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        return this.getOriginalText();
    }

    public String toString() {
        if (this.getAlias() != null) {
            return this.getExpression() + " AS " + this.getAlias();
        }
        return this.getExpression().toString();
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.of(this.expression);
    }
}

