/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherListLiteral;

public abstract class CypherSetItem<TLeft extends CypherAstBase, TRight extends CypherAstBase>
extends CypherAstBase {
    private final TLeft left;
    private final Op op;
    private final TRight right;

    public CypherSetItem(TLeft left, Op op, TRight right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    public TLeft getLeft() {
        return this.left;
    }

    public Op getOp() {
        return this.op;
    }

    public TRight getRight() {
        return this.right;
    }

    public String toString() {
        if (this.getRight() instanceof CypherListLiteral) {
            return String.format("%s%s", this.getLeft(), this.getRight());
        }
        return String.format("%s %s %s", new Object[]{this.getLeft(), this.getOp(), this.getRight()});
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.of(this.getLeft(), this.getRight());
    }

    public static enum Op {
        PLUS_EQUAL,
        EQUAL;


        public String toString() {
            switch (this) {
                case PLUS_EQUAL: {
                    return "+=";
                }
                case EQUAL: {
                    return "=";
                }
            }
            throw new VertexiumException("unhandled op: " + (Object)((Object)this));
        }
    }
}

