/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.ast.model;

import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.ast.model.CypherAstBase;

public class CypherStringMatch
extends CypherAstBase {
    private final CypherAstBase valueExpression;
    private final CypherAstBase stringExpression;
    private final Op op;

    public CypherStringMatch(CypherAstBase valueExpression, CypherAstBase stringExpression, Op op) {
        this.valueExpression = valueExpression;
        this.stringExpression = stringExpression;
        this.op = op;
    }

    public CypherAstBase getValueExpression() {
        return this.valueExpression;
    }

    public CypherAstBase getStringExpression() {
        return this.stringExpression;
    }

    public Op getOp() {
        return this.op;
    }

    public String toString() {
        switch (this.getOp()) {
            case STARTS_WITH: {
                return String.format("%s STARTS WITH %s", this.getValueExpression(), this.getStringExpression());
            }
            case ENDS_WITH: {
                return String.format("%s ENDS WITH %s", this.getValueExpression(), this.getStringExpression());
            }
            case CONTAINS: {
                return String.format("%s CONTAINS %s", this.getValueExpression(), this.getStringExpression());
            }
        }
        throw new VertexiumException("unhandled: " + (Object)((Object)this.getOp()));
    }

    @Override
    public Stream<? extends CypherAstBase> getChildren() {
        return Stream.of(this.valueExpression, this.stringExpression);
    }

    public static enum Op {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS;

    }
}

