/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherCreateClause;
import org.vertexium.cypher.ast.model.CypherDirection;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherPatternPart;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.executor.ExpressionExecutor;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class CreateClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(CreateClauseExecutor.class);
    private final ExpressionExecutor expressionExecutor;

    public CreateClauseExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherCreateClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        scope.run();
        Stream<VertexiumCypherScope.Item> results = scope.stream().map(item -> this.executeCreate(ctx, clause, (VertexiumCypherScope.Item)item));
        return VertexiumCypherScope.newItemsScope(results, scope);
    }

    private VertexiumCypherScope.Item executeCreate(VertexiumCypherQueryContext ctx, CypherCreateClause createClause, VertexiumCypherScope.Item item) {
        LinkedHashMap<String, Element> map = new LinkedHashMap<String, Element>();
        for (CypherPatternPart cypherPatternPart : createClause.getPatternParts()) {
            LinkedHashMap<String, Element> patternPartResult = this.executePatternPart(ctx, cypherPatternPart, VertexiumCypherScope.newMapItem(map, item));
            map.putAll(patternPartResult);
        }
        return VertexiumCypherScope.newMapItem(map, item);
    }

    public LinkedHashMap<String, Element> executePatternPart(VertexiumCypherQueryContext ctx, CypherPatternPart cypherPatternPart, VertexiumCypherScope.Item item) {
        LinkedHashMap<String, Element> elements = new LinkedHashMap<String, Element>();
        Vertex lastVertex = null;
        CypherRelationshipPattern lastRelationshipPattern = null;
        for (CypherElementPattern cypherElementPattern : cypherPatternPart.getElementPatterns()) {
            if (cypherElementPattern instanceof CypherNodePattern) {
                Vertex vertex = null;
                String elementName = cypherElementPattern.getName();
                if (elementName != null) {
                    vertex = this.lookupExistingElement(elementName, elements, Vertex.class, item);
                }
                if (vertex == null) {
                    vertex = this.executeCreateVertex(ctx, (CypherNodePattern)cypherElementPattern, item);
                    if (elementName != null) {
                        elements.put(elementName, (Element)vertex);
                    }
                } else {
                    this.executeUpdateVertex(ctx, (CypherNodePattern)cypherElementPattern, vertex, item);
                }
                if (lastVertex != null && lastRelationshipPattern != null) {
                    Edge edge = null;
                    String edgeName = lastRelationshipPattern.getName();
                    if (edgeName != null) {
                        edge = this.lookupExistingElement(edgeName, elements, Edge.class, item);
                    }
                    if (edge == null) {
                        edge = this.executeCreateEdge(ctx, lastRelationshipPattern, lastVertex, vertex, item);
                        if (edgeName != null) {
                            elements.put(edgeName, (Element)edge);
                        }
                    }
                }
                lastVertex = vertex;
                continue;
            }
            if (cypherElementPattern instanceof CypherRelationshipPattern) {
                lastRelationshipPattern = (CypherRelationshipPattern)cypherElementPattern;
                continue;
            }
            throw new VertexiumException("Unexpected element pattern: " + cypherElementPattern.getClass().getName());
        }
        return elements;
    }

    private <T extends Element> T lookupExistingElement(String name, Map<String, Element> elements, Class<T> resultType, ExpressionScope scope) {
        if (scope == null) {
            return null;
        }
        Element element = elements.get(name);
        if (element == null) {
            List<Object> obj = scope.getByName(name);
            if (obj instanceof Stream) {
                Stream stream = (Stream)((Object)obj);
                obj = stream.collect(Collectors.toList());
            }
            if (obj instanceof List) {
                List list = obj;
                if (list.size() == 0) {
                    return null;
                }
                if (list.size() == 1) {
                    obj = list.get(0);
                }
            }
            if (obj != null && !(obj instanceof Element)) {
                throw new VertexiumException("Expected Element with name \"" + name + "\", found \"" + obj.getClass().getName() + "\"");
            }
            element = (Element)obj;
        }
        if (element == null) {
            return null;
        }
        return (T)((Element)resultType.cast(element));
    }

    private Edge executeCreateEdge(VertexiumCypherQueryContext ctx, CypherRelationshipPattern relationshipPattern, Vertex leftVertex, Vertex rightVertex, VertexiumCypherScope.Item item) {
        Vertex inVertex;
        Vertex outVertex;
        CypherDirection direction = relationshipPattern.getDirection();
        if (direction == CypherDirection.OUT) {
            outVertex = leftVertex;
            inVertex = rightVertex;
        } else if (direction == CypherDirection.IN) {
            outVertex = rightVertex;
            inVertex = leftVertex;
        } else {
            throw new VertexiumException("unexpected direction: " + (Object)((Object)direction));
        }
        String edgeId = ctx.calculateEdgeId(relationshipPattern, item);
        String label = ctx.calculateEdgeLabel(relationshipPattern, outVertex, inVertex, item);
        label = ctx.normalizeLabelName(label);
        Visibility visibility = ctx.calculateEdgeVisibility(relationshipPattern, outVertex, inVertex, item);
        EdgeBuilder m = ctx.getGraph().prepareEdge(edgeId, outVertex, inVertex, label, visibility);
        this.setPropertiesOnElement(ctx, (ElementMutation)m, relationshipPattern, item);
        return ctx.saveEdge((ElementMutation<Edge>)m);
    }

    private Vertex executeCreateVertex(VertexiumCypherQueryContext ctx, CypherNodePattern nodePattern, VertexiumCypherScope.Item item) {
        String vertexId = ctx.calculateVertexId(nodePattern, item);
        Visibility vertexVisibility = ctx.calculateVertexVisibility(nodePattern, item);
        VertexBuilder m = ctx.getGraph().prepareVertex(vertexId, vertexVisibility);
        this.updateVertex(ctx, (ElementMutation<Vertex>)m, nodePattern, item);
        return ctx.saveVertex((ElementMutation<Vertex>)m);
    }

    private void executeUpdateVertex(VertexiumCypherQueryContext ctx, CypherNodePattern nodePattern, Vertex vertex, VertexiumCypherScope.Item item) {
        ExistingElementMutation m = vertex.prepareMutation();
        this.updateVertex(ctx, (ElementMutation<Vertex>)m, nodePattern, item);
        ctx.saveVertex((ElementMutation<Vertex>)m);
    }

    private void updateVertex(VertexiumCypherQueryContext ctx, ElementMutation<Vertex> m, CypherNodePattern nodePattern, VertexiumCypherScope.Item item) {
        for (CypherLabelName label : nodePattern.getLabelNames()) {
            String labelName = ctx.normalizeLabelName((String)label.getValue());
            ctx.setLabelProperty(m, labelName);
        }
        this.setPropertiesOnElement(ctx, m, nodePattern, item);
    }

    private <T extends Element> void setPropertiesOnElement(VertexiumCypherQueryContext ctx, ElementMutation<T> m, CypherElementPattern elementPattern, VertexiumCypherScope.Item item) {
        for (Map.Entry<String, CypherAstBase> property : elementPattern.getPropertiesMap().entrySet()) {
            String propertyName = ctx.normalizePropertyName(property.getKey());
            CypherAstBase propertyValue = property.getValue();
            Object value = this.toObject(ctx, propertyValue, item);
            if (value == null) continue;
            ctx.setProperty(m, propertyName, value);
        }
    }

    private Object toObject(VertexiumCypherQueryContext ctx, CypherAstBase expression, VertexiumCypherScope.Item item) {
        return this.expressionExecutor.executeExpression(ctx, expression, item);
    }
}

