/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherDeleteClause;
import org.vertexium.cypher.exceptions.VertexiumCypherConstraintVerificationFailedException;
import org.vertexium.cypher.executor.ExpressionExecutor;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class DeleteClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(DeleteClauseExecutor.class);
    private final ExpressionExecutor expressionExecutor;

    public DeleteClauseExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherDeleteClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        scope.run();
        Stream<DeleteElementItem> elementsToDelete = scope.stream().flatMap(item -> this.execute(ctx, clause, (VertexiumCypherScope.Item)item).stream());
        this.deleteElements(ctx, elementsToDelete);
        return scope;
    }

    private List<DeleteElementItem> execute(VertexiumCypherQueryContext ctx, CypherDeleteClause clause, VertexiumCypherScope.Item item) {
        ArrayList<DeleteElementItem> elementsToDelete = new ArrayList<DeleteElementItem>();
        clause.getExpressions().forEach(expr -> {
            Object exprResult = this.expressionExecutor.executeExpression(ctx, (CypherAstBase)expr, item);
            if (exprResult == null) {
                return;
            }
            if (exprResult instanceof Element) {
                Element element = (Element)exprResult;
                elementsToDelete.add(new DeleteElementItem(element, clause.isDetach()));
            } else if (exprResult instanceof VertexiumCypherScope.PathItem) {
                VertexiumCypherScope.PathItem path = (VertexiumCypherScope.PathItem)exprResult;
                if (clause.isDetach()) {
                    for (Vertex vertex : path.getVertices()) {
                        elementsToDelete.add(new DeleteElementItem((Element)vertex, clause.isDetach()));
                    }
                } else {
                    for (Edge edge : path.getEdges()) {
                        elementsToDelete.add(new DeleteElementItem((Element)edge, clause.isDetach()));
                    }
                    for (Vertex vertex : path.getVertices()) {
                        elementsToDelete.add(new DeleteElementItem((Element)vertex, clause.isDetach()));
                    }
                }
            } else {
                throw new VertexiumException("not implemented \"" + exprResult.getClass().getName() + "\": " + exprResult);
            }
        });
        return elementsToDelete;
    }

    private void deleteElements(VertexiumCypherQueryContext ctx, Stream<DeleteElementItem> elementsToDelete) {
        List elementsToDeleteList = elementsToDelete.collect(Collectors.toList());
        for (DeleteElementItem deleteElementItem : elementsToDeleteList) {
            this.deleteElement(ctx, deleteElementItem.element, deleteElementItem.detach, elementsToDeleteList.stream());
        }
    }

    private void deleteElement(VertexiumCypherQueryContext ctx, Element element, boolean detach, Stream<DeleteElementItem> elementsToDelete) {
        if (element instanceof Vertex) {
            Vertex vertex = (Vertex)element;
            this.deleteVertex(ctx, vertex, detach, elementsToDelete);
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            this.deleteEdge(ctx, edge);
        } else {
            throw new VertexiumException("unhandled element type to delete: " + element.getClass().getName());
        }
    }

    private void deleteVertex(VertexiumCypherQueryContext ctx, Vertex vertex, boolean detach, Stream<DeleteElementItem> elementsToDelete) {
        if (!detach && this.isAttached(ctx, vertex, elementsToDelete)) {
            throw new VertexiumCypherConstraintVerificationFailedException("DeleteConnectedNode: Cannot delete a vertex with edges unless 'DETACH' is specified in the 'DELETE' clause.");
        }
        ctx.deleteVertex(vertex);
    }

    private boolean isAttached(VertexiumCypherQueryContext ctx, Vertex vertex, Stream<DeleteElementItem> elementsToDelete) {
        for (String vertexId : vertex.getVertexIds(Direction.BOTH, ctx.getAuthorizations())) {
            if (!elementsToDelete.noneMatch(e -> vertexId.equals(e.element.getId()))) continue;
            return true;
        }
        return false;
    }

    private void deleteEdge(VertexiumCypherQueryContext ctx, Edge edge) {
        ctx.deleteEdge(edge);
    }

    private static class DeleteElementItem {
        public final Element element;
        public final boolean detach;

        public DeleteElementItem(Element element, boolean detach) {
            this.element = element;
            this.detach = detach;
        }
    }
}

