/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherArrayAccess;
import org.vertexium.cypher.ast.model.CypherArraySlice;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherBinaryExpression;
import org.vertexium.cypher.ast.model.CypherComparisonExpression;
import org.vertexium.cypher.ast.model.CypherExpression;
import org.vertexium.cypher.ast.model.CypherFilterExpression;
import org.vertexium.cypher.ast.model.CypherFunctionInvocation;
import org.vertexium.cypher.ast.model.CypherIn;
import org.vertexium.cypher.ast.model.CypherIndexedParameter;
import org.vertexium.cypher.ast.model.CypherIsNotNull;
import org.vertexium.cypher.ast.model.CypherIsNull;
import org.vertexium.cypher.ast.model.CypherListComprehension;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherLiteral;
import org.vertexium.cypher.ast.model.CypherLookup;
import org.vertexium.cypher.ast.model.CypherMatchClause;
import org.vertexium.cypher.ast.model.CypherNameParameter;
import org.vertexium.cypher.ast.model.CypherNegateExpression;
import org.vertexium.cypher.ast.model.CypherParameter;
import org.vertexium.cypher.ast.model.CypherPatternComprehension;
import org.vertexium.cypher.ast.model.CypherStringMatch;
import org.vertexium.cypher.ast.model.CypherTrueExpression;
import org.vertexium.cypher.ast.model.CypherUnaryExpression;
import org.vertexium.cypher.ast.model.CypherVariable;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.functions.CypherFunction;
import org.vertexium.cypher.utils.MapUtils;
import org.vertexium.cypher.utils.ObjectUtils;
import org.vertexium.util.StreamUtils;

public class ExpressionExecutor {
    public Object executeExpression(VertexiumCypherQueryContext ctx, CypherAstBase expression, ExpressionScope scope) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof CypherExpression) {
            if (expression instanceof CypherBinaryExpression) {
                return this.executeBinaryExpression(ctx, (CypherBinaryExpression)expression, scope);
            }
            if (expression instanceof CypherComparisonExpression) {
                return this.executeComparisonExpression(ctx, (CypherComparisonExpression)expression, scope);
            }
            if (expression instanceof CypherUnaryExpression) {
                return this.executeUnaryExpression(ctx, (CypherUnaryExpression)expression, scope);
            }
            if (expression instanceof CypherTrueExpression) {
                return true;
            }
            if (expression instanceof CypherNegateExpression) {
                return this.executeNegateExpression(ctx, (CypherNegateExpression)expression, scope);
            }
            throw new VertexiumCypherNotImplemented("" + expression);
        }
        if (expression instanceof CypherListLiteral) {
            CypherListLiteral list = (CypherListLiteral)expression;
            return this.executeList(ctx, list, scope);
        }
        if (expression instanceof CypherLiteral) {
            CypherLiteral literal = (CypherLiteral)expression;
            return literal.getValue();
        }
        if (expression instanceof CypherVariable) {
            CypherVariable variable = (CypherVariable)expression;
            return this.executeObject(ctx, this.executeVariable(ctx, variable, scope), scope);
        }
        if (expression instanceof CypherLookup) {
            CypherLookup lookup = (CypherLookup)expression;
            return this.executeLookup(ctx, lookup, scope);
        }
        if (expression instanceof CypherFunctionInvocation) {
            CypherFunctionInvocation functionInvocation = (CypherFunctionInvocation)expression;
            return this.executeFunctionInvocation(ctx, functionInvocation, scope);
        }
        if (expression instanceof CypherIn) {
            CypherIn in = (CypherIn)expression;
            return this.executeIn(ctx, in, scope);
        }
        if (expression instanceof CypherArrayAccess) {
            CypherArrayAccess arrayAccess = (CypherArrayAccess)expression;
            return this.executeArrayAccess(ctx, arrayAccess, scope);
        }
        if (expression instanceof CypherArraySlice) {
            CypherArraySlice arraySlice = (CypherArraySlice)expression;
            return this.executeArraySlice(ctx, arraySlice, scope);
        }
        if (expression instanceof CypherParameter) {
            CypherParameter parameter = (CypherParameter)expression;
            return this.executeParameter(ctx, parameter);
        }
        if (expression instanceof CypherIsNull) {
            CypherIsNull isNull = (CypherIsNull)expression;
            return this.executeIsNull(ctx, isNull, scope);
        }
        if (expression instanceof CypherIsNotNull) {
            CypherIsNotNull isNotNull = (CypherIsNotNull)expression;
            return this.executeIsNotNull(ctx, isNotNull, scope);
        }
        if (expression instanceof CypherListComprehension) {
            CypherListComprehension listComprehension = (CypherListComprehension)expression;
            return this.executeListComprehension(ctx, listComprehension, scope);
        }
        if (expression instanceof CypherStringMatch) {
            CypherStringMatch startWith = (CypherStringMatch)expression;
            return this.executeStringMatch(ctx, startWith, scope);
        }
        if (expression instanceof CypherPatternComprehension) {
            CypherPatternComprehension patternComprehension = (CypherPatternComprehension)expression;
            VertexiumCypherScope matchScope = scope instanceof VertexiumCypherScope ? (VertexiumCypherScope)scope : VertexiumCypherScope.newSingleItemScope((VertexiumCypherScope.Item)scope);
            VertexiumCypherScope results = ctx.getMatchClauseExecutor().execute(ctx, Lists.newArrayList((Object[])new CypherMatchClause[]{patternComprehension.getMatchClause()}), matchScope);
            return results.stream().map(item -> this.executeExpression(ctx, patternComprehension.getExpression(), (ExpressionScope)item));
        }
        throw new VertexiumException("not implemented \"" + expression.getClass().getName() + "\": " + expression);
    }

    private Object executeNegateExpression(VertexiumCypherQueryContext ctx, CypherNegateExpression expression, ExpressionScope scope) {
        Object value = this.executeExpression(ctx, expression.getValue(), scope);
        if (value instanceof Number) {
            if (value instanceof Double) {
                return -((Double)value).doubleValue();
            }
            if (value instanceof Integer) {
                return -((Integer)value).intValue();
            }
            if (value instanceof Long) {
                return -((Long)value).longValue();
            }
            return -((Number)value).doubleValue();
        }
        throw new VertexiumException("not implemented");
    }

    private Object executeStringMatch(VertexiumCypherQueryContext ctx, CypherStringMatch stringMatch, ExpressionScope scope) {
        Object value = this.executeExpression(ctx, stringMatch.getValueExpression(), scope);
        Object stringObj = this.executeExpression(ctx, stringMatch.getStringExpression(), scope);
        if (stringObj == null) {
            return null;
        }
        if (!(stringObj instanceof String)) {
            return null;
        }
        String string = (String)stringObj;
        if (value == null) {
            return null;
        }
        switch (stringMatch.getOp()) {
            case STARTS_WITH: {
                return value.toString().startsWith(string);
            }
            case ENDS_WITH: {
                return value.toString().endsWith(string);
            }
            case CONTAINS: {
                return value.toString().contains(string);
            }
        }
        throw new VertexiumException("unhandled string match: " + (Object)((Object)stringMatch.getOp()));
    }

    private Object executeListComprehension(VertexiumCypherQueryContext ctx, CypherListComprehension listComprehension, ExpressionScope scope) {
        Stream<ExpressionScope> itemScopes = this.executeFilterExpression(ctx, listComprehension.getFilterExpression(), scope);
        if (listComprehension.getExpression() == null) {
            return itemScopes;
        }
        return itemScopes.map(itemScope -> this.executeExpression(ctx, listComprehension.getExpression(), (ExpressionScope)itemScope));
    }

    private Stream<ExpressionScope> executeFilterExpression(VertexiumCypherQueryContext ctx, CypherFilterExpression filterExpression, ExpressionScope scope) {
        String name = filterExpression.getIdInCol().getVariable().getName();
        Object values = this.executeExpression(ctx, filterExpression.getIdInCol().getExpression(), scope);
        Stream<ExpressionScope> results = this.toStream(values).map(value -> VertexiumCypherScope.newMapItem(name, value, scope));
        if (filterExpression.getWhere() != null) {
            throw new VertexiumCypherNotImplemented("where");
        }
        return results;
    }

    private Object executeObject(VertexiumCypherQueryContext ctx, Object o, ExpressionScope scope) {
        if (o instanceof CypherAstBase) {
            return this.executeExpression(ctx, (CypherAstBase)o, scope);
        }
        return o;
    }

    private Object executeIsNotNull(VertexiumCypherQueryContext ctx, CypherIsNotNull isNotNull, ExpressionScope clauseResult) {
        Object value = ctx.getExpressionExecutor().executeExpression(ctx, isNotNull.getValueExpression(), clauseResult);
        return value != null;
    }

    private Object executeIsNull(VertexiumCypherQueryContext ctx, CypherIsNull isNull, ExpressionScope scope) {
        Object value = ctx.getExpressionExecutor().executeExpression(ctx, isNull.getValueExpression(), scope);
        return value == null;
    }

    private Object executeParameter(VertexiumCypherQueryContext ctx, CypherParameter parameter) {
        if (parameter instanceof CypherNameParameter) {
            CypherNameParameter nameParameter = (CypherNameParameter)parameter;
            return ctx.getParameters().get(nameParameter.getParameterName());
        }
        if (parameter instanceof CypherIndexedParameter) {
            CypherIndexedParameter indexedParameter = (CypherIndexedParameter)parameter;
            return ctx.getParameters().get(Integer.toString(indexedParameter.getIndex()));
        }
        throw new VertexiumException("not implemented");
    }

    private Object executeArraySlice(VertexiumCypherQueryContext ctx, CypherArraySlice arraySlice, ExpressionScope scope) {
        Object array = ctx.getExpressionExecutor().executeExpression(ctx, arraySlice.getArrayExpression(), scope);
        Object sliceFromObj = ctx.getExpressionExecutor().executeExpression(ctx, arraySlice.getSliceFrom(), scope);
        Object sliceToObj = ctx.getExpressionExecutor().executeExpression(ctx, arraySlice.getSliceTo(), scope);
        if (!(sliceFromObj instanceof Number)) {
            throw new VertexiumException("expected integer from, found " + sliceFromObj.getClass().getName());
        }
        int sliceFrom = ((Number)sliceFromObj).intValue();
        if (!(sliceToObj instanceof Number)) {
            throw new VertexiumException("expected integer to, found " + sliceToObj.getClass().getName());
        }
        int sliceTo = ((Number)sliceToObj).intValue();
        Iterable<?> it = this.toIterable(array);
        return StreamUtils.stream((Iterable[])new Iterable[]{it}).skip(sliceFrom).limit(sliceTo - sliceFrom);
    }

    private Object executeArrayAccess(VertexiumCypherQueryContext ctx, CypherArrayAccess arrayAccess, ExpressionScope scope) {
        Object array = ctx.getExpressionExecutor().executeExpression(ctx, arrayAccess.getArrayExpression(), scope);
        if (array == null) {
            return null;
        }
        Object indexObj = ctx.getExpressionExecutor().executeExpression(ctx, arrayAccess.getIndexExpression(), scope);
        if (array instanceof Element) {
            Element element = (Element)array;
            if (indexObj instanceof String) {
                String propertyName = (String)indexObj;
                return element.getPropertyValue(propertyName);
            }
            throw new VertexiumCypherTypeErrorException("expected string property name, found " + indexObj.getClass().getName());
        }
        if (array instanceof Map) {
            Map map = (Map)array;
            if (indexObj instanceof String) {
                String propertyName = (String)indexObj;
                return map.get(propertyName);
            }
            throw new VertexiumCypherTypeErrorException("MapElementAccessByNonString: expected string, found " + indexObj.getClass().getName());
        }
        if (array instanceof List || array instanceof CypherListLiteral) {
            if (indexObj instanceof Long) {
                indexObj = ((Long)indexObj).intValue();
            }
            if (indexObj instanceof Integer) {
                int index = (Integer)indexObj;
                if (array instanceof CypherListLiteral) {
                    return ((CypherListLiteral)array).get(index);
                }
                if (array instanceof List) {
                    return ((List)array).get(index);
                }
            }
            throw new VertexiumCypherTypeErrorException("ListElementAccessByNonInteger: expected integer, found " + indexObj.getClass().getName());
        }
        if (array instanceof Stream) {
            if (indexObj instanceof Long) {
                indexObj = ((Long)indexObj).intValue();
            }
            if (indexObj instanceof Integer) {
                int index = (Integer)indexObj;
                return ((Stream)array).skip(index).findFirst().get();
            }
            throw new VertexiumCypherTypeErrorException("ListElementAccessByNonInteger: expected integer, found " + indexObj.getClass().getName());
        }
        throw new VertexiumCypherTypeErrorException("InvalidElementAccess: unexpected object access, found object " + array.getClass().getName() + ": " + array + ", index " + indexObj.getClass().getName() + ": " + indexObj);
    }

    private Object executeIn(VertexiumCypherQueryContext ctx, CypherIn in, ExpressionScope scope) {
        Object value = ctx.getExpressionExecutor().executeExpression(ctx, in.getValueExpression(), scope);
        Object array = ctx.getExpressionExecutor().executeExpression(ctx, in.getArrayExpression(), scope);
        if (value == null) {
            if (array == null) {
                return null;
            }
            Iterable<?> it = this.toIterable(array);
            if (!it.iterator().hasNext()) {
                return false;
            }
            return null;
        }
        Iterable<?> it = this.toIterable(array);
        boolean hasNullValue = false;
        for (Object o : it) {
            if (o == null) {
                hasNullValue = true;
                continue;
            }
            if (o instanceof CypherLiteral) {
                o = ((CypherLiteral)o).getValue();
            }
            if (!o.equals(value)) continue;
            return true;
        }
        if (hasNullValue) {
            return null;
        }
        return false;
    }

    private Iterable<?> toIterable(Object obj) {
        if (obj instanceof Stream) {
            return ((Stream)obj).collect(Collectors.toList());
        }
        if (!(obj instanceof CypherListLiteral || obj instanceof List || obj instanceof Set)) {
            throw new VertexiumCypherNotImplemented("expected iterable, found " + obj == null ? null : obj.getClass().getName());
        }
        Iterable it = (Iterable)obj;
        return it;
    }

    private Stream<?> toStream(Object obj) {
        if (obj instanceof Stream) {
            return (Stream)obj;
        }
        return StreamUtils.stream((Iterable[])new Iterable[]{this.toIterable(obj)});
    }

    private Object executeUnaryExpression(VertexiumCypherQueryContext ctx, CypherUnaryExpression expression, ExpressionScope scope) {
        Object value = ctx.getExpressionExecutor().executeExpression(ctx, expression.getExpression(), scope);
        switch (expression.getOp()) {
            case NOT: {
                return this.executeNOT(value);
            }
        }
        throw new VertexiumCypherNotImplemented("" + (Object)((Object)expression.getOp()));
    }

    private Object executeNOT(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        throw new VertexiumException("could not NOT: " + value.getClass().getName());
    }

    private Object executeFunctionInvocation(VertexiumCypherQueryContext ctx, CypherFunctionInvocation functionInvocation, ExpressionScope scope) {
        CypherFunction fn = ctx.getFunction(functionInvocation.getFunctionName());
        return fn.invoke(ctx, functionInvocation.getArguments(), scope);
    }

    private Stream<Object> executeList(VertexiumCypherQueryContext context, CypherListLiteral<? extends CypherAstBase> list, ExpressionScope scope) {
        return list.stream().map(i -> this.executeExpression(context, (CypherAstBase)i, scope));
    }

    private Object executeLookup(VertexiumCypherQueryContext ctx, CypherLookup expression, ExpressionScope scope) {
        Object item = this.executeExpression(ctx, expression.getAtom(), scope);
        return this.executeLookup(ctx, item, expression, scope);
    }

    private Object executeLookup(VertexiumCypherQueryContext ctx, Object item, CypherLookup expression, ExpressionScope scope) {
        if (item == null) {
            return null;
        }
        if (item instanceof Map) {
            if (expression.hasLabels()) {
                throw new VertexiumException("lookup using labels from a map is not supported");
            }
            Object value = MapUtils.getByExpression((Map)item, expression.getProperty());
            if (value == null) {
                return null;
            }
            if (value instanceof Element) {
                return value;
            }
            if (value instanceof CypherAstBase) {
                return this.executeExpression(ctx, (CypherAstBase)value, scope);
            }
            return value;
        }
        if (item instanceof Element) {
            Element element = (Element)item;
            if (expression.hasLabels()) {
                if (element instanceof Vertex) {
                    if (expression.getProperty() != null) {
                        throw new VertexiumException("cannot have labels and properties");
                    }
                    return expression.getLabels().stream().anyMatch(l -> ctx.getVertexLabels((Vertex)element).contains(ctx.normalizeLabelName((String)l.getValue())));
                }
                throw new VertexiumCypherNotImplemented("label lookup");
            }
            if (expression.getProperty() == null) {
                return element;
            }
            return element.getPropertyValue(ctx.normalizePropertyName(expression.getProperty()));
        }
        if (item instanceof Collection) {
            Collection list = (Collection)item;
            return list.stream().map(listItem -> this.executeLookup(ctx, listItem, expression, scope));
        }
        if (item instanceof Stream) {
            Stream list = (Stream)item;
            return list.map(listItem -> this.executeLookup(ctx, listItem, expression, scope));
        }
        throw new VertexiumCypherTypeErrorException(item, Element.class, Map.class, Collection.class, null);
    }

    private Object executeComparisonExpression(VertexiumCypherQueryContext context, CypherComparisonExpression expression, ExpressionScope scope) {
        String op;
        Object left = this.executeExpression(context, expression.getLeft(), scope);
        Object right = this.executeExpression(context, expression.getRight(), scope);
        switch (op = expression.getOp()) {
            case "=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": 
            case "<>": {
                if (left == null && right == null) {
                    return null;
                }
                if (left == null) {
                    return false;
                }
                return this.compare(left, op, right);
            }
        }
        throw new VertexiumException("comparison not implemented: " + op);
    }

    private Object compare(Object left, String op, Object right) {
        switch (op) {
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                if (left == null || right == null) {
                    return false;
                }
                if (left instanceof Number && right instanceof Number || left.getClass().equals(right.getClass())) break;
                return false;
            }
        }
        int comp = ObjectUtils.compare(left, right);
        switch (op) {
            case "=": {
                return comp == 0;
            }
            case "<": {
                return comp < 0;
            }
            case "<=": {
                return comp <= 0;
            }
            case ">": {
                return comp > 0;
            }
            case ">=": {
                return comp >= 0;
            }
            case "<>": {
                return comp != 0;
            }
        }
        throw new VertexiumCypherNotImplemented("unexpected op: " + op);
    }

    private Object executeBinaryExpression(VertexiumCypherQueryContext ctx, CypherBinaryExpression expression, ExpressionScope scope) {
        Object left = this.executeExpression(ctx, expression.getLeft(), scope);
        switch (expression.getOp()) {
            case ADD: {
                return this.executeADD(ctx, left, expression.getRight(), scope);
            }
            case MULTIPLY: {
                return this.executeMULTIPLY(ctx, left, expression.getRight(), scope);
            }
            case MINUS: {
                return this.executeMINUS(ctx, left, expression.getRight(), scope);
            }
            case DIVIDE: {
                return this.executeDIVIDE(ctx, left, expression.getRight(), scope);
            }
            case AND: {
                return this.executeAND(ctx, left, expression.getRight(), scope);
            }
            case OR: {
                return this.executeOR(ctx, left, expression.getRight(), scope);
            }
            case XOR: {
                return this.executeXOR(ctx, left, expression.getRight(), scope);
            }
            case MOD: {
                return this.executeMOD(ctx, left, expression.getRight(), scope);
            }
            case POWER: {
                return this.executePOWER(ctx, left, expression.getRight(), scope);
            }
        }
        throw new VertexiumException("Unhandled binary op: " + (Object)((Object)expression.getOp()));
    }

    private Object executeMULTIPLY(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(left, Number.class);
        }
        if (!(right instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(right, Number.class);
        }
        Number leftNumber = (Number)left;
        Number rightNumber = (Number)right;
        if (leftNumber instanceof Double || leftNumber instanceof Float || rightNumber instanceof Double || rightNumber instanceof Float) {
            return leftNumber.doubleValue() * rightNumber.doubleValue();
        }
        if (leftNumber instanceof Long || rightNumber instanceof Long) {
            return leftNumber.longValue() * rightNumber.longValue();
        }
        return leftNumber.intValue() * rightNumber.intValue();
    }

    private Object executeMINUS(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(left, Number.class);
        }
        if (!(right instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(right, Number.class);
        }
        Number leftNumber = (Number)left;
        Number rightNumber = (Number)right;
        if (leftNumber instanceof Double || leftNumber instanceof Float || rightNumber instanceof Double || rightNumber instanceof Float) {
            return leftNumber.doubleValue() - rightNumber.doubleValue();
        }
        if (leftNumber instanceof Long || rightNumber instanceof Long) {
            return leftNumber.longValue() - rightNumber.longValue();
        }
        return leftNumber.intValue() - rightNumber.intValue();
    }

    private Object executeDIVIDE(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(left, Number.class);
        }
        if (!(right instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(right, Number.class);
        }
        Number leftNumber = (Number)left;
        Number rightNumber = (Number)right;
        if (leftNumber instanceof Double || leftNumber instanceof Float || rightNumber instanceof Double || rightNumber instanceof Float) {
            return leftNumber.doubleValue() / rightNumber.doubleValue();
        }
        if (leftNumber instanceof Long || rightNumber instanceof Long) {
            return leftNumber.longValue() / rightNumber.longValue();
        }
        return leftNumber.intValue() / rightNumber.intValue();
    }

    private Object executeMOD(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(left, Number.class);
        }
        if (!(right instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(right, Number.class);
        }
        Number leftNumber = (Number)left;
        Number rightNumber = (Number)right;
        if (leftNumber instanceof Double || leftNumber instanceof Float || rightNumber instanceof Double || rightNumber instanceof Float) {
            return leftNumber.doubleValue() % rightNumber.doubleValue();
        }
        if (leftNumber instanceof Long || rightNumber instanceof Long) {
            return leftNumber.longValue() % rightNumber.longValue();
        }
        return leftNumber.intValue() % rightNumber.intValue();
    }

    private Object executePOWER(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(left, Number.class);
        }
        if (!(right instanceof Number)) {
            throw new VertexiumCypherTypeErrorException(right, Number.class);
        }
        Number leftNumber = (Number)left;
        Number rightNumber = (Number)right;
        if (leftNumber instanceof Double || leftNumber instanceof Float || rightNumber instanceof Double || rightNumber instanceof Float) {
            return Math.pow(leftNumber.doubleValue(), rightNumber.doubleValue());
        }
        if (leftNumber instanceof Long || rightNumber instanceof Long) {
            return (long)Math.pow(leftNumber.longValue(), rightNumber.longValue());
        }
        return (long)Math.pow(leftNumber.intValue(), rightNumber.intValue());
    }

    private Object executeADD(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (left instanceof String) {
            return (String)left + right;
        }
        if (left instanceof Number && right instanceof Number) {
            return ObjectUtils.addNumbers((Number)left, (Number)right);
        }
        if (left instanceof Stream && right instanceof Stream) {
            return Stream.concat((Stream)left, (Stream)right);
        }
        if (left instanceof Stream) {
            return Stream.concat((Stream)left, Stream.of(right));
        }
        if (left instanceof List && right instanceof List) {
            ArrayList results = new ArrayList();
            results.addAll((List)left);
            results.addAll((List)right);
            return results;
        }
        if (left instanceof List) {
            ArrayList<Object> results = new ArrayList<Object>();
            results.addAll((List)left);
            results.add(right);
            return results;
        }
        if (right == null) {
            return null;
        }
        throw new VertexiumException("add not implemented left:" + left.getClass().getName() + ", right:" + right.getClass().getName());
    }

    private Object executeAND(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        if (left == null) {
            Object right = this.executeExpression(ctx, rightExpression, scope);
            if (right == null) {
                return null;
            }
            if (right instanceof Boolean) {
                boolean b = (Boolean)right;
                if (b) {
                    return null;
                }
                return false;
            }
        }
        if (left instanceof Boolean) {
            boolean bLeft = (Boolean)left;
            if (!bLeft) {
                return false;
            }
            Object right = this.executeExpression(ctx, rightExpression, scope);
            if (right == null) {
                return null;
            }
            if (right instanceof Boolean) {
                return right;
            }
            throw new VertexiumException("unexpected value in AND expression: " + right);
        }
        throw new VertexiumException("unexpected value in AND expression: " + left);
    }

    private Object executeOR(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        if (left == null) {
            Object right = this.executeExpression(ctx, rightExpression, scope);
            if (right == null) {
                return null;
            }
            if (right instanceof Boolean) {
                boolean b = (Boolean)right;
                if (b) {
                    return true;
                }
                return null;
            }
        }
        if (left instanceof Boolean) {
            boolean bLeft = (Boolean)left;
            if (bLeft) {
                return true;
            }
            Object right = this.executeExpression(ctx, rightExpression, scope);
            if (right == null) {
                return null;
            }
            if (right instanceof Boolean) {
                return right;
            }
            throw new VertexiumException("unexpected value in OR expression: " + right);
        }
        throw new VertexiumException("unexpected value in OR expression: " + left);
    }

    private Object executeXOR(VertexiumCypherQueryContext ctx, Object left, CypherAstBase rightExpression, ExpressionScope scope) {
        if (left == null) {
            return null;
        }
        Object right = this.executeExpression(ctx, rightExpression, scope);
        if (right == null) {
            return null;
        }
        throw new VertexiumCypherNotImplemented("XOR " + left + ", " + right);
    }

    private Object executeVariable(VertexiumCypherQueryContext ctx, CypherVariable expression, ExpressionScope scope) {
        if (scope == null) {
            throw new VertexiumException("Could not get variable \"" + expression.getName() + "\" last results were null");
        }
        return scope.getByName(expression.getName());
    }

    Stream<VertexiumCypherScope.Item> applyWhereToResults(VertexiumCypherQueryContext ctx, Stream<VertexiumCypherScope.Item> rows, CypherAstBase whereExpression) {
        return rows.filter(row -> {
            Object result = this.executeExpression(ctx, whereExpression, (ExpressionScope)row);
            return ObjectUtils.compare(true, result) == 0;
        });
    }
}

