/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeInfoEdge;
import org.vertexium.EdgeVertices;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.VertexiumPropertyNotDefinedException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherMatchClause;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherRelTypeName;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.exceptions.VertexiumCypherException;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.executor.models.match.MatchConstraint;
import org.vertexium.cypher.executor.models.match.MatchConstraints;
import org.vertexium.cypher.executor.models.match.NodeMatchConstraint;
import org.vertexium.cypher.executor.models.match.PatternPartMatchConstraint;
import org.vertexium.cypher.executor.models.match.RelationshipMatchConstraint;
import org.vertexium.cypher.executor.models.match.RelationshipMatchRange;
import org.vertexium.cypher.executor.utils.MatchConstraintBuilder;
import org.vertexium.cypher.utils.ObjectUtils;
import org.vertexium.query.Contains;
import org.vertexium.query.EmptyResultsQueryResultsIterable;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class MatchClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(MatchClauseExecutor.class);

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, List<CypherMatchClause> matchClauses, VertexiumCypherScope scope) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("execute: %s", new Object[]{matchClauses.stream().map(CypherMatchClause::toString).collect(Collectors.joining("; "))});
        }
        MatchConstraints matchConstraints = new MatchConstraintBuilder().getMatchConstraints(matchClauses);
        Stream<VertexiumCypherScope.Item> results = scope.stream().flatMap(item -> this.executeMatchConstraints(ctx, matchConstraints, (ExpressionScope)item));
        return VertexiumCypherScope.newItemsScope(results, scope);
    }

    private Stream<VertexiumCypherScope.Item> executeMatchConstraints(VertexiumCypherQueryContext ctx, MatchConstraints matchConstraints, ExpressionScope scope) {
        Stream<VertexiumCypherScope.Item> results = null;
        for (PatternPartMatchConstraint patternPartMatchConstraint : matchConstraints.getPatternPartMatchConstraints()) {
            Stream<VertexiumCypherScope.Item> patternPartResults = this.executePatternPartConstraint(ctx, patternPartMatchConstraint, scope);
            if (results != null) {
                results = VertexiumCypherScope.Item.cartesianProduct(results, patternPartResults);
                continue;
            }
            results = patternPartResults;
        }
        for (CypherAstBase whereExpression : matchConstraints.getWhereExpressions()) {
            results = ctx.getExpressionExecutor().applyWhereToResults(ctx, results, whereExpression);
        }
        return results;
    }

    public Stream<VertexiumCypherScope.Item> executePatternPartConstraint(VertexiumCypherQueryContext ctx, PatternPartMatchConstraint patternPartConstraint, ExpressionScope scope) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new MatchContextIterator(ctx, patternPartConstraint, scope), 1024), false).map(mc -> mc.toResult(patternPartConstraint.getNamedPaths(), scope));
    }

    private Stream<MatchContext> getInitialMatchContexts(VertexiumCypherQueryContext ctx, PatternPartMatchConstraint patternPartConstraint, ExpressionScope scope) {
        List<MatchConstraint> foundMatchConstraints = this.findExistingMatchedMatchConstraintInScope(patternPartConstraint, scope);
        if (foundMatchConstraints.size() > 0) {
            return this.getInitialMatchContextsFromFoundItems(patternPartConstraint, foundMatchConstraints, scope);
        }
        return this.getInitialMatchContextsBySearching(ctx, patternPartConstraint, scope);
    }

    private Stream<MatchContext> getInitialMatchContextsBySearching(VertexiumCypherQueryContext ctx, PatternPartMatchConstraint patternPartConstraint, ExpressionScope scope) {
        MatchConstraint workingMatchConstraint = MatchContext.getNextConstraintToWorkOn(ctx, scope, patternPartConstraint.getMatchConstraints(), new HashMap());
        LOGGER.debug("working on: %s", new Object[]{workingMatchConstraint});
        Stream matchingElements = StreamUtils.stream((Iterable[])new Iterable[]{MatchClauseExecutor.executeFirstMatchConstraint(ctx, workingMatchConstraint, scope, null)});
        if (workingMatchConstraint.isOptional()) {
            matchingElements = (Stream)StreamUtils.ifEmpty((Stream)matchingElements, () -> Stream.of((Element)null), s -> s);
        }
        return matchingElements.map(element -> {
            ArrayList<MatchConstraint> remainingMatchConstraints = new ArrayList<MatchConstraint>(patternPartConstraint.getMatchConstraints());
            remainingMatchConstraints.remove(workingMatchConstraint);
            return new MatchContext(workingMatchConstraint, element, remainingMatchConstraints);
        });
    }

    private Stream<MatchContext> getInitialMatchContextsFromFoundItems(PatternPartMatchConstraint patternPartConstraint, List<MatchConstraint> foundMatchConstraints, ExpressionScope scope) {
        ArrayList<MatchContext> matchContexts = new ArrayList<MatchContext>();
        for (MatchConstraint foundMatchConstraint : foundMatchConstraints) {
            Object objByName = scope.getByName(foundMatchConstraint.getName());
            this.appendMatchContextsWithFoundItems(matchContexts, patternPartConstraint, foundMatchConstraint, objByName);
        }
        return matchContexts.stream();
    }

    private void appendMatchContextsWithFoundItems(List<MatchContext> matchContexts, PatternPartMatchConstraint patternPartConstraint, MatchConstraint foundMatchConstraint, Object objByName) {
        if (objByName == null || objByName instanceof Element) {
            Element element = (Element)objByName;
            if (matchContexts.size() == 0) {
                ArrayList<MatchConstraint> remainingMatchConstraints = new ArrayList<MatchConstraint>(patternPartConstraint.getMatchConstraints());
                remainingMatchConstraints.remove(foundMatchConstraint);
                matchContexts.add(new MatchContext(foundMatchConstraint, element, remainingMatchConstraints));
            } else {
                for (MatchContext matchContext : matchContexts) {
                    matchContext.addElement(foundMatchConstraint, element);
                }
            }
        } else if (objByName instanceof Stream) {
            ((Stream)objByName).forEach(o -> this.appendMatchContextsWithFoundItems(matchContexts, patternPartConstraint, foundMatchConstraint, o));
        } else if (objByName instanceof List) {
            for (Object o2 : (List)objByName) {
                this.appendMatchContextsWithFoundItems(matchContexts, patternPartConstraint, foundMatchConstraint, o2);
            }
        } else {
            throw new VertexiumCypherNotImplemented("non-objects: " + objByName);
        }
    }

    private List<MatchConstraint> findExistingMatchedMatchConstraintInScope(PatternPartMatchConstraint patternPartConstraint, ExpressionScope scope) {
        ArrayList<MatchConstraint> results = new ArrayList<MatchConstraint>();
        for (MatchConstraint matchConstraint : patternPartConstraint.getMatchConstraints()) {
            String name = matchConstraint.getName();
            if (name == null || !scope.contains(name)) continue;
            List obj = scope.getByName(name);
            if (obj instanceof Stream) {
                obj = ((Stream)((Object)obj)).collect(Collectors.toList());
            }
            if (obj instanceof List && obj.size() == 0) continue;
            results.add(matchConstraint);
        }
        return results;
    }

    private Stream<MatchContext> resolveMatchContext(VertexiumCypherQueryContext ctx, MatchContext matchContext, ExpressionScope scope) {
        MatchConstraint<?, ?> matchConstraint = matchContext.getNextConstraintToWorkOn(ctx, scope);
        LOGGER.trace("working on: %s", new Object[]{matchConstraint});
        if (matchConstraint == null) {
            throw new VertexiumCypherException("Cannot solve match clause. Could not find and constraints to work on.");
        }
        if (matchConstraint instanceof NodeMatchConstraint) {
            return this.resolveNodeMatchContext(ctx, matchContext, (NodeMatchConstraint)matchConstraint, scope);
        }
        if (matchConstraint instanceof RelationshipMatchConstraint) {
            return this.resolveRelationshipMatchContext(ctx, matchContext, (RelationshipMatchConstraint)matchConstraint, scope);
        }
        throw new VertexiumCypherTypeErrorException(matchConstraint, NodeMatchConstraint.class, RelationshipMatchConstraint.class);
    }

    private Stream<MatchContext> resolveRelationshipMatchContext(VertexiumCypherQueryContext ctx, MatchContext matchContext, RelationshipMatchConstraint relationshipMatchConstraint, ExpressionScope scope) {
        List<Vertex> previousVertices = matchContext.getMatchedVertices(relationshipMatchConstraint);
        if (previousVertices.size() > 2) {
            throw new VertexiumCypherNotImplemented("Too many vertices");
        }
        Vertex startingVertex = previousVertices.size() > 0 ? previousVertices.get(0) : null;
        Vertex endVertex = previousVertices.size() > 1 ? previousVertices.get(1) : null;
        Stream<VertexiumCypherScope.PathItem> paths = this.executeRelationshipConstraint(ctx, startingVertex, endVertex, relationshipMatchConstraint, matchContext, scope);
        return paths.map(path -> MatchContext.concatPath(relationshipMatchConstraint, matchContext, path));
    }

    private Stream<MatchContext> resolveNodeMatchContext(VertexiumCypherQueryContext ctx, MatchContext matchContext, NodeMatchConstraint nodeMatchConstraint, ExpressionScope scope) {
        List<EdgeVertexConstraint> satisfiedEdgeVertexConstraint = matchContext.getSatisfiedEdgeVertexPairs(ctx, nodeMatchConstraint);
        if (satisfiedEdgeVertexConstraint.size() == 0) {
            return Stream.empty();
        }
        Stream<Vertex> vertices = this.executeNodeConstraints(ctx, matchContext, satisfiedEdgeVertexConstraint, nodeMatchConstraint, scope);
        return vertices.map(v -> MatchContext.concatVertex(nodeMatchConstraint, matchContext, v));
    }

    private Stream<Vertex> executeNodeConstraints(VertexiumCypherQueryContext ctx, MatchContext matchContext, List<EdgeVertexConstraint> edgeVertexConstraints, NodeMatchConstraint matchConstraint, ExpressionScope scope) {
        if (edgeVertexConstraints.size() == 0) {
            throw new VertexiumCypherException("no edge vertex constraints found");
        }
        List<String> labelNames = MatchClauseExecutor.getLabelNamesFromMatchConstraint(matchConstraint).stream().map(ctx::normalizeLabelName).collect(Collectors.toList());
        ListMultimap<String, CypherAstBase> propertiesMap = MatchClauseExecutor.getPropertiesMapFromElementPatterns(ctx, matchConstraint.getPatterns());
        Stream<Object> results = Stream.empty();
        for (EdgeVertexConstraint edgeVertexConstraint : edgeVertexConstraints) {
            Stream<Vertex> newResults = this.executeNodeConstraint(ctx, matchContext, matchConstraint, edgeVertexConstraint, labelNames, propertiesMap, scope);
            results = Stream.concat(results, newResults);
        }
        return results.distinct();
    }

    private Stream<Vertex> executeNodeConstraint(VertexiumCypherQueryContext ctx, MatchContext matchContext, NodeMatchConstraint matchConstraint, EdgeVertexConstraint edgeVertexConstraint, List<String> labelNames, ListMultimap<String, CypherAstBase> propertiesMap, ExpressionScope scope) {
        Vertex vertex;
        ArrayList<Vertex> results = new ArrayList<Vertex>();
        Edge edge = edgeVertexConstraint.getEdge();
        Vertex previousVertex = edgeVertexConstraint.getVertex();
        MatchConstraint edgeMatchConstraint = edgeVertexConstraint.getEdgeMatchConstraint();
        boolean foundMatch = false;
        if (edge != null && previousVertex != null && this.vertexIsMatch(ctx, vertex = edge.getOtherVertex(previousVertex.getId(), ctx.getFetchHints(), ctx.getAuthorizations()), labelNames, propertiesMap, scope) && this.vertexRelationshipMatches(matchContext, matchConstraint, vertex)) {
            results.add(vertex);
            foundMatch = true;
        }
        if (!foundMatch && edge == null && previousVertex != null && edgeMatchConstraint.hasZeroRangePattern()) {
            results.add(previousVertex);
            foundMatch = true;
        }
        if (!foundMatch && matchConstraint.isOptional()) {
            results.add(null);
        }
        return results.stream();
    }

    private boolean vertexRelationshipMatches(MatchContext matchContext, NodeMatchConstraint matchConstraint, Vertex vertex) {
        for (RelationshipMatchConstraint relationshipMatchConstraint : matchConstraint.getConnectedConstraints()) {
            Object o = matchContext.getResultsByMatchConstraint(relationshipMatchConstraint);
            if (o == null) continue;
            if (o instanceof Edge) {
                Edge edge = (Edge)o;
                if (edge.getVertexId(Direction.OUT).equals(vertex.getId()) || edge.getVertexId(Direction.IN).equals(vertex.getId())) continue;
                return false;
            }
            if (o instanceof VertexiumCypherScope.PathItem) {
                VertexiumCypherScope.PathItem pathItem = (VertexiumCypherScope.PathItem)o;
                if (pathItem.canVertexConnectOrFoundAtStartOrEnd(vertex)) continue;
                return false;
            }
            throw new VertexiumCypherException("Unexpected result type: " + o.getClass().getName());
        }
        return true;
    }

    private boolean vertexIsMatch(VertexiumCypherQueryContext ctx, Vertex vertex, List<String> labelNames, ListMultimap<String, CypherAstBase> propertiesMap, ExpressionScope scope) {
        Set<String> vertexLabelNames = ctx.getVertexLabels(vertex);
        for (String labelName : labelNames) {
            if (vertexLabelNames.contains(labelName)) continue;
            return false;
        }
        return this.propertyMapMatch(ctx, (Element)vertex, propertiesMap, scope);
    }

    private static long getTotalHits(VertexiumCypherQueryContext ctx, MatchConstraint<?, ?> matchConstraint, ExpressionScope scope) {
        return ctx.getTotalHitsForMatchConstraint(matchConstraint, mc -> MatchClauseExecutor.executeFirstMatchConstraint(ctx, mc, scope, 0L).getTotalHits());
    }

    private static IterableWithTotalHits<? extends Element> executeFirstMatchConstraint(VertexiumCypherQueryContext ctx, MatchConstraint<?, ?> matchConstraint, ExpressionScope scope, Long limit) {
        try {
            QueryResultsIterable<? extends Element> elements;
            List<String> labelNames = MatchClauseExecutor.getLabelNamesFromMatchConstraint(matchConstraint);
            ListMultimap<String, CypherAstBase> propertiesMap = MatchClauseExecutor.getPropertiesMapFromElementPatterns(ctx, matchConstraint.getPatterns());
            Query query = ctx.getGraph().query(ctx.getAuthorizations()).limit(limit);
            if (labelNames.size() == 0 && propertiesMap.size() == 0) {
                elements = MatchClauseExecutor.executeQuery(ctx, query, matchConstraint);
            } else {
                if (labelNames.size() > 0) {
                    Stream<String> labelNamesStream = labelNames.stream().map(ctx::normalizeLabelName);
                    if (matchConstraint instanceof NodeMatchConstraint) {
                        query = labelNamesStream.reduce(query, (q, labelName) -> q.has(ctx.getLabelPropertyName(), labelName), (q, q2) -> q);
                    } else if (matchConstraint instanceof RelationshipMatchConstraint) {
                        List normalizedLabelNames = labelNamesStream.collect(Collectors.toList());
                        query = query.hasEdgeLabel(normalizedLabelNames);
                    } else {
                        throw new VertexiumCypherNotImplemented("unexpected constraint type: " + matchConstraint.getClass().getName());
                    }
                }
                for (Map.Entry propertyMatch : propertiesMap.entries()) {
                    List value = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)propertyMatch.getValue(), scope);
                    if (value instanceof CypherAstBase) {
                        throw new VertexiumException("unexpected value: " + value.getClass().getName() + ": " + value);
                    }
                    if (value instanceof Stream) {
                        value = ((Stream)((Object)value)).collect(Collectors.toList());
                    }
                    if (value instanceof Collection) {
                        query.has((String)propertyMatch.getKey(), (Predicate)Contains.IN, value);
                        continue;
                    }
                    query.has((String)propertyMatch.getKey(), value);
                }
                elements = MatchClauseExecutor.executeQuery(ctx, query, matchConstraint);
            }
            return elements;
        }
        catch (VertexiumPropertyNotDefinedException e) {
            LOGGER.error(e.getMessage(), new Object[0]);
            return new EmptyResultsQueryResultsIterable();
        }
    }

    private static QueryResultsIterable<? extends Element> executeQuery(VertexiumCypherQueryContext ctx, Query query, MatchConstraint<?, ?> matchConstraint) {
        QueryResultsIterable elements;
        if (matchConstraint instanceof NodeMatchConstraint) {
            elements = query.vertices(ctx.getFetchHints());
        } else if (matchConstraint instanceof RelationshipMatchConstraint) {
            elements = query.edges(ctx.getFetchHints());
        } else {
            throw new VertexiumCypherNotImplemented("unexpected constraint type: " + matchConstraint.getClass().getName());
        }
        return elements;
    }

    private Stream<VertexiumCypherScope.PathItem> executeRelationshipConstraint(VertexiumCypherQueryContext ctx, Vertex startingVertex, Vertex endVertex, RelationshipMatchConstraint matchConstraint, MatchContext matchContext, ExpressionScope scope) {
        List<String> labelNames = this.getRelationshipTypeNamesFromMatchConstraint(matchConstraint).stream().map(ctx::normalizeLabelName).collect(Collectors.toList());
        ListMultimap<String, CypherAstBase> propertiesMap = MatchClauseExecutor.getPropertiesMapFromElementPatterns(ctx, matchConstraint.getPatterns());
        Direction direction = matchContext.getRelationshipDirection(matchConstraint, startingVertex, endVertex);
        RelationshipMatchRange range = matchConstraint.getRange();
        String name = matchConstraint.getName();
        Stream<VertexiumCypherScope.PathItem> newPaths = Stream.empty();
        VertexiumCypherScope.PathItem previousPath = VertexiumCypherScope.newEmptyPathItem(null, scope).setPrintMode(VertexiumCypherScope.PathItem.PrintMode.RELATIONSHIP_RANGE);
        previousPath = previousPath.concat(null, (Element)startingVertex);
        Vertex vertex = (Vertex)previousPath.getLastElement();
        if (range.isRangeSet() && range.isIn(0)) {
            newPaths = Stream.concat(newPaths, Stream.of(previousPath.concat(name, null)));
        }
        Stream<VertexiumCypherScope.PathItem> newPathsToAdd = this.findPathsToAdd(ctx, previousPath, vertex, endVertex, name, matchConstraint.isOptional(), range, 1, labelNames, propertiesMap, direction, matchContext, scope);
        newPaths = Stream.concat(newPaths, newPathsToAdd);
        return newPaths;
    }

    private Stream<VertexiumCypherScope.PathItem> findPathsToAdd(VertexiumCypherQueryContext ctx, VertexiumCypherScope.PathItem previousPath, Vertex startingVertex, Vertex endVertex, String name, boolean optional, RelationshipMatchRange range, int depth, List<String> labelNames, ListMultimap<String, CypherAstBase> propertiesMap, Direction direction, MatchContext matchContext, ExpressionScope scope) {
        if (range.isRangeSet() && range.getTo() == null && depth > ctx.getMaxUnboundedRange()) {
            return Stream.empty();
        }
        if (startingVertex == null && depth > 1) {
            return Stream.empty();
        }
        AtomicReference paths = new AtomicReference(Stream.empty());
        if (range.isIn(depth)) {
            AtomicBoolean foundEdge = new AtomicBoolean(false);
            if (startingVertex != null) {
                this.findEdges(ctx, name, propertiesMap, startingVertex, direction, labelNames).forEach(edge -> {
                    if (previousPath.contains((Element)edge) || matchContext.contains((Edge)edge)) {
                        return;
                    }
                    if (endVertex != null && !edge.getOtherVertexId(startingVertex.getId()).equals(endVertex.getId())) {
                        return;
                    }
                    if (this.edgeIsMatch(ctx, (Edge)edge, labelNames, propertiesMap, scope)) {
                        paths.set(Stream.concat((Stream)paths.get(), Stream.of(previousPath.concat(name, (Element)edge))));
                        foundEdge.set(true);
                    }
                });
            }
            if (optional && !foundEdge.get()) {
                paths.set(Stream.concat(paths.get(), Stream.of(previousPath.concat(name, null))));
            }
        }
        if (range.isRangeSet()) {
            if (startingVertex != null) {
                this.findEdges(ctx, name, propertiesMap, startingVertex, direction, labelNames).forEach(edge -> {
                    if (previousPath.contains((Element)edge) || matchContext.contains((Edge)edge)) {
                        return;
                    }
                    if (this.edgeIsMatch(ctx, (Edge)edge, labelNames, propertiesMap, scope)) {
                        Vertex otherVertex = edge.getOtherVertex(startingVertex.getId(), ctx.getFetchHints(), ctx.getAuthorizations());
                        VertexiumCypherScope.PathItem newPath = previousPath.concat(name, (Element)edge).concat(null, (Element)otherVertex);
                        paths.set(Stream.concat((Stream)paths.get(), this.findPathsToAdd(ctx, newPath, otherVertex, endVertex, name, optional, range, depth + 1, labelNames, propertiesMap, direction, matchContext, scope)));
                    }
                });
            }
            if (optional) {
                VertexiumCypherScope.PathItem newPath = previousPath.concat(name, null).concat(null, null);
                paths.set(Stream.concat(paths.get(), this.findPathsToAdd(ctx, newPath, null, endVertex, name, optional, range, depth + 1, labelNames, propertiesMap, direction, matchContext, scope)));
            }
        }
        return paths.get();
    }

    private Stream<Edge> findEdges(VertexiumCypherQueryContext ctx, String name, ListMultimap<String, CypherAstBase> propertiesMap, Vertex startingVertex, Direction direction, List<String> labelNames) {
        if (name == null && propertiesMap.size() == 0) {
            return StreamUtils.stream((Iterable[])new Iterable[]{startingVertex.getEdgeInfos(direction, this.labelNamesToArray(labelNames), ctx.getAuthorizations())}).map(edgeInfo -> new EdgeInfoEdge(ctx.getGraph(), startingVertex.getId(), edgeInfo, ctx.getFetchHints(), ctx.getAuthorizations()));
        }
        return StreamUtils.stream((Iterable[])new Iterable[]{startingVertex.getEdges(direction, this.labelNamesToArray(labelNames), ctx.getFetchHints(), ctx.getAuthorizations())});
    }

    private String[] labelNamesToArray(List<String> labelNames) {
        if (labelNames == null || labelNames.size() == 0) {
            return null;
        }
        return labelNames.toArray(new String[labelNames.size()]);
    }

    private boolean edgeIsMatch(VertexiumCypherQueryContext ctx, Edge edge, List<String> labelNames, ListMultimap<String, CypherAstBase> propertiesMap, ExpressionScope scope) {
        if (labelNames.size() > 0 && labelNames.stream().noneMatch(ln -> edge.getLabel().equals(ln))) {
            return false;
        }
        return this.propertyMapMatch(ctx, (Element)edge, propertiesMap, scope);
    }

    private boolean propertyMapMatch(VertexiumCypherQueryContext ctx, Element element, ListMultimap<String, CypherAstBase> propertiesMap, ExpressionScope scope) {
        for (Map.Entry propertyEntry : propertiesMap.entries()) {
            Object expressionValue;
            Object propertyValue = element.getPropertyValue((String)propertyEntry.getKey());
            if (ObjectUtils.equals(propertyValue, expressionValue = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)propertyEntry.getValue(), scope))) continue;
            return false;
        }
        return true;
    }

    private List<String> getRelationshipTypeNamesFromMatchConstraint(RelationshipMatchConstraint matchConstraint) {
        ArrayList<String> results = new ArrayList<String>();
        for (CypherRelationshipPattern relationshipPattern : matchConstraint.getPatterns()) {
            if (relationshipPattern.getRelTypeNames() == null) continue;
            for (CypherRelTypeName relTypeName : relationshipPattern.getRelTypeNames()) {
                results.add((String)relTypeName.getValue());
            }
        }
        return results;
    }

    private static List<String> getLabelNamesFromMatchConstraint(MatchConstraint<?, ?> matchConstraint) {
        ArrayList<String> results = new ArrayList<String>();
        for (CypherElementPattern pattern : matchConstraint.getPatterns()) {
            if (pattern instanceof CypherNodePattern) {
                CypherNodePattern nodePattern = (CypherNodePattern)pattern;
                if (nodePattern.getLabelNames() == null) continue;
                for (CypherLabelName labelName : nodePattern.getLabelNames()) {
                    results.add((String)labelName.getValue());
                }
                continue;
            }
            if (pattern instanceof CypherRelationshipPattern) {
                CypherRelationshipPattern relationshipPattern = (CypherRelationshipPattern)pattern;
                if (relationshipPattern.getRelTypeNames() == null) continue;
                for (CypherRelTypeName relTypeName : relationshipPattern.getRelTypeNames()) {
                    results.add((String)relTypeName.getValue());
                }
                continue;
            }
            throw new VertexiumCypherNotImplemented("unexpected pattern type: " + pattern.getClass().getName());
        }
        return results;
    }

    private static <T extends CypherElementPattern> ListMultimap<String, CypherAstBase> getPropertiesMapFromElementPatterns(VertexiumCypherQueryContext ctx, List<T> elementPatterns) {
        ArrayListMultimap results = ArrayListMultimap.create();
        for (CypherElementPattern elementPattern : elementPatterns) {
            for (Map.Entry<String, CypherAstBase> entry : elementPattern.getPropertiesMap().entrySet()) {
                results.put((Object)ctx.normalizePropertyName(entry.getKey()), (Object)entry.getValue());
            }
        }
        return results;
    }

    private static class MatchContext {
        public Map<MatchConstraint, Object> elementsByMatchConstraint = new HashMap<MatchConstraint, Object>();
        public LinkedHashMap<String, Object> elementsByName = new LinkedHashMap();
        public List<MatchConstraint> remainingMatchConstraints = new ArrayList<MatchConstraint>();

        private MatchContext() {
        }

        public MatchContext(MatchConstraint matchConstraint, Object element, List<MatchConstraint> remainingMatchConstraints) {
            this.elementsByMatchConstraint.put(matchConstraint, element);
            this.remainingMatchConstraints.addAll(remainingMatchConstraints);
            if (matchConstraint.getName() != null) {
                this.elementsByName.put(matchConstraint.getName(), element);
            }
        }

        public static MatchContext concatVertex(MatchConstraint matchConstraint, MatchContext previousMatchContext, Vertex vertex) {
            return MatchContext.concatItem(matchConstraint, previousMatchContext, vertex);
        }

        public static MatchContext concatPath(MatchConstraint matchConstraint, MatchContext previousMatchContext, VertexiumCypherScope.PathItem path) {
            return MatchContext.concatItem(matchConstraint, previousMatchContext, path);
        }

        private static MatchContext concatItem(MatchConstraint matchConstraint, MatchContext previousMatchContext, Object o) {
            MatchContext ctx = new MatchContext();
            ctx.elementsByMatchConstraint.put(matchConstraint, o);
            ctx.remainingMatchConstraints.addAll(previousMatchContext.remainingMatchConstraints);
            ctx.remainingMatchConstraints.remove(matchConstraint);
            ctx.elementsByMatchConstraint.putAll(previousMatchContext.elementsByMatchConstraint);
            ctx.elementsByName.putAll(previousMatchContext.elementsByName);
            if (matchConstraint.getName() != null) {
                ctx.elementsByName.put(matchConstraint.getName(), o);
            }
            return ctx;
        }

        public void addElement(MatchConstraint matchConstraint, Element element) {
            if (element == null && !matchConstraint.isOptional()) {
                throw new VertexiumCypherException("element cannot be null");
            }
            this.elementsByMatchConstraint.put(matchConstraint, element);
            this.remainingMatchConstraints.remove(matchConstraint);
            if (matchConstraint.getName() != null) {
                this.elementsByName.put(matchConstraint.getName(), element);
            }
        }

        public boolean isDone() {
            return this.remainingMatchConstraints.size() == 0;
        }

        public MatchConstraint<?, ?> getNextConstraintToWorkOn(VertexiumCypherQueryContext ctx, ExpressionScope scope) {
            Map<MatchConstraint, Integer> satisfiedConstraintCount = this.remainingMatchConstraints.stream().collect(Collectors.toMap(c -> c, this::getSatisfiedConstraintCount));
            return MatchContext.getNextConstraintToWorkOn(ctx, scope, this.remainingMatchConstraints, satisfiedConstraintCount);
        }

        private static MatchConstraint getNextConstraintToWorkOn(VertexiumCypherQueryContext ctx, ExpressionScope scope, Collection<MatchConstraint> remainingMatchConstraints, Map<MatchConstraint, Integer> satisfiedConstraintCount) {
            return remainingMatchConstraints.stream().sorted((o1, o2) -> {
                long o2Hits;
                if (satisfiedConstraintCount.size() > 0) {
                    int o1SatisfiedCount = satisfiedConstraintCount.getOrDefault(o1, 0);
                    int o2SatisfiedCount = satisfiedConstraintCount.getOrDefault(o2, 0);
                    int o1UnsatisfiedCount = o1.getConnectedConstraints().size() - o1SatisfiedCount;
                    int o2UnsatisfiedCount = o2.getConnectedConstraints().size() - o2SatisfiedCount;
                    int result = Integer.compare(o1SatisfiedCount, o2SatisfiedCount);
                    if (result != 0) {
                        return -result;
                    }
                    result = Integer.compare(o1UnsatisfiedCount, o2UnsatisfiedCount);
                    if (result != 0) {
                        return result;
                    }
                }
                if (o1.isOptional() || o2.isOptional()) {
                    if (o1.isOptional() && o2.isOptional()) {
                        return 0;
                    }
                    if (o1.isOptional()) {
                        return 1;
                    }
                    if (o2.isOptional()) {
                        return -1;
                    }
                }
                if (o1 instanceof RelationshipMatchConstraint && ((RelationshipMatchConstraint)o1).getRange().isRangeSet()) {
                    return 1;
                }
                if (o2 instanceof RelationshipMatchConstraint && ((RelationshipMatchConstraint)o2).getRange().isRangeSet()) {
                    return -1;
                }
                long o1Hits = MatchClauseExecutor.getTotalHits(ctx, o1, scope);
                int i = Long.compare(o1Hits, o2Hits = MatchClauseExecutor.getTotalHits(ctx, o2, scope));
                if (i != 0) {
                    return i;
                }
                return -Integer.compare(o1.getConstraintCount(), o2.getConstraintCount());
            }).findFirst().orElse(null);
        }

        private int getSatisfiedConstraintCount(MatchConstraint<?, ?> remainingMatchConstraint) {
            return (int)remainingMatchConstraint.getConnectedConstraints().stream().filter(c -> this.elementsByMatchConstraint.containsKey(c)).count();
        }

        public List<Vertex> getMatchedVertices(RelationshipMatchConstraint matchConstraint) {
            return matchConstraint.getConnectedConstraints().stream().map(mc -> (Vertex)this.elementsByMatchConstraint.get(mc)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<EdgeVertexConstraint> getSatisfiedEdgeVertexPairs(VertexiumCypherQueryContext ctx, NodeMatchConstraint matchConstraint) {
            return matchConstraint.getConnectedConstraints().stream().flatMap(edgeMatchConstraint -> {
                Object o = this.elementsByMatchConstraint.get(edgeMatchConstraint);
                if (o == null) {
                    return null;
                }
                if (!(o instanceof Edge)) {
                    if (o instanceof VertexiumCypherScope.PathItem) {
                        VertexiumCypherScope.PathItem pathResult = (VertexiumCypherScope.PathItem)o;
                        Edge edge = (Edge)pathResult.getLastElement();
                        Vertex vertex = (Vertex)pathResult.getElement(-2);
                        return Lists.newArrayList((Object[])new EdgeVertexConstraint[]{new EdgeVertexConstraint(edge, vertex, (MatchConstraint)edgeMatchConstraint)}).stream();
                    }
                    throw new VertexiumCypherTypeErrorException(o, Edge.class, VertexiumCypherScope.PathItem.class, null);
                }
                Edge edge = (Edge)o;
                List<Vertex> matchedVertices = this.getMatchedVertices((RelationshipMatchConstraint)edgeMatchConstraint);
                if (matchedVertices.size() == 0) {
                    EdgeVertices edgeVertices = edge.getVertices(ctx.getFetchHints(), ctx.getAuthorizations());
                    switch (edgeMatchConstraint.getDirection()) {
                        case BOTH: 
                        case UNSPECIFIED: {
                            matchedVertices.add(edgeVertices.getInVertex());
                            matchedVertices.add(edgeVertices.getOutVertex());
                            break;
                        }
                        case OUT: {
                            if (edgeMatchConstraint.isFoundInNext(matchConstraint)) {
                                matchedVertices.add(edgeVertices.getOutVertex());
                                break;
                            }
                            if (edgeMatchConstraint.isFoundInPrevious(matchConstraint)) {
                                matchedVertices.add(edgeVertices.getInVertex());
                                break;
                            }
                            throw new VertexiumCypherException("unexpected");
                        }
                        case IN: {
                            if (edgeMatchConstraint.isFoundInPrevious(matchConstraint)) {
                                matchedVertices.add(edgeVertices.getOutVertex());
                                break;
                            }
                            if (edgeMatchConstraint.isFoundInNext(matchConstraint)) {
                                matchedVertices.add(edgeVertices.getInVertex());
                                break;
                            }
                            throw new VertexiumCypherException("unexpected");
                        }
                    }
                }
                return matchedVertices.stream().filter(Objects::nonNull).map(v -> new EdgeVertexConstraint(edge, (Vertex)v, (MatchConstraint)edgeMatchConstraint));
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public VertexiumCypherScope.Item toResult(Map<String, List<MatchConstraint>> namedPaths, ExpressionScope parentScope) {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.elementsByName.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof VertexiumCypherScope.PathItem) {
                    VertexiumCypherScope.PathItem pr = (VertexiumCypherScope.PathItem)value;
                    List<Edge> edges = pr.getEdges();
                    if (edges.size() == 0) {
                        value = null;
                    } else if (edges.size() == 1) {
                        value = edges.get(0);
                    }
                }
                values.put(name, value);
            }
            for (Map.Entry<String, Object> entry : namedPaths.entrySet()) {
                String pathName = entry.getKey();
                VertexiumCypherScope.PathItem path = this.toPathResult(pathName, (List)entry.getValue(), parentScope);
                values.put(pathName, path);
            }
            return VertexiumCypherScope.newMapItem(values, parentScope);
        }

        private VertexiumCypherScope.PathItem toPathResult(String pathName, List<MatchConstraint> matchConstraints, ExpressionScope parentScope) {
            VertexiumCypherScope.PathItem result = VertexiumCypherScope.newEmptyPathItem(pathName, parentScope);
            for (MatchConstraint matchConstraint : matchConstraints) {
                String elementName = matchConstraint.getName();
                Object o = this.elementsByMatchConstraint.get(matchConstraint);
                if (o == null) {
                    return null;
                }
                if (o instanceof Element) {
                    result = result.concat(elementName, (Element)o);
                    continue;
                }
                if (o instanceof VertexiumCypherScope.PathItem) {
                    result = result.concat((VertexiumCypherScope.PathItem)o);
                    continue;
                }
                throw new VertexiumCypherTypeErrorException(o, Element.class, VertexiumCypherScope.PathItem.class, null);
            }
            return result;
        }

        public boolean contains(Edge edge) {
            for (Map.Entry<MatchConstraint, Object> entry : this.elementsByMatchConstraint.entrySet()) {
                Object o = entry.getValue();
                if (o == null || o instanceof Vertex) continue;
                if (o instanceof Edge) {
                    if (!edge.equals(o)) continue;
                    return true;
                }
                if (o instanceof VertexiumCypherScope.PathItem) {
                    if (!((VertexiumCypherScope.PathItem)o).contains((Element)edge)) continue;
                    return true;
                }
                throw new VertexiumCypherNotImplemented("unknown object type: " + o.getClass().getName());
            }
            return false;
        }

        public Direction getRelationshipDirection(RelationshipMatchConstraint matchConstraint, Vertex startingVertex, Vertex endVertex) {
            Direction direction = matchConstraint.getDirection().toVertexiumDirection();
            if (direction == Direction.BOTH) {
                return direction;
            }
            if (startingVertex == null && endVertex == null) {
                return null;
            }
            if (startingVertex != null) {
                Direction d = this.findConstraintsByElement((Element)startingVertex).map(startingMatchConstraint -> {
                    NodeMatchConstraint nodeMatchConstraint = (NodeMatchConstraint)startingMatchConstraint;
                    if (matchConstraint.isFoundInPrevious(nodeMatchConstraint)) {
                        return direction;
                    }
                    if (matchConstraint.isFoundInNext(nodeMatchConstraint)) {
                        return direction.reverse();
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst().orElse(null);
                if (d == null) {
                    throw new VertexiumCypherException("Could not find starting match constraint in next or previous");
                }
                return d;
            }
            throw new VertexiumCypherNotImplemented("getRelationshipDirection by end vertex");
        }

        private Stream<? extends MatchConstraint> findConstraintsByElement(Element element) {
            return this.elementsByMatchConstraint.entrySet().stream().filter(e -> element.equals(e.getValue())).map(Map.Entry::getKey);
        }

        public Object getResultsByMatchConstraint(RelationshipMatchConstraint relationshipMatchConstraint) {
            return this.elementsByMatchConstraint.get(relationshipMatchConstraint);
        }
    }

    private static class EdgeVertexConstraint {
        private Edge edge;
        private Vertex vertex;
        private final MatchConstraint edgeMatchConstraint;

        public EdgeVertexConstraint(Edge edge, Vertex vertex, MatchConstraint edgeMatchConstraint) {
            this.edge = edge;
            this.vertex = vertex;
            this.edgeMatchConstraint = edgeMatchConstraint;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public Vertex getVertex() {
            return this.vertex;
        }

        public MatchConstraint getEdgeMatchConstraint() {
            return this.edgeMatchConstraint;
        }
    }

    private class MatchContextIterator
    implements Iterator<MatchContext> {
        private final VertexiumCypherQueryContext ctx;
        private final ExpressionScope scope;
        private final LinkedList<Iterator<MatchContext>> matchContextsQueue = new LinkedList();
        private MatchContext next;
        private MatchContext current;

        public MatchContextIterator(VertexiumCypherQueryContext ctx, PatternPartMatchConstraint patternPartConstraint, ExpressionScope scope) {
            this.ctx = ctx;
            this.scope = scope;
            this.matchContextsQueue.add(MatchClauseExecutor.this.getInitialMatchContexts(ctx, patternPartConstraint, scope).iterator());
        }

        @Override
        public boolean hasNext() {
            this.loadNext();
            return this.next != null;
        }

        @Override
        public MatchContext next() {
            this.loadNext();
            this.current = this.next;
            this.next = null;
            return this.current;
        }

        private void loadNext() {
            if (this.next != null) {
                return;
            }
            while (this.matchContextsQueue.size() > 0) {
                Iterator<MatchContext> mcs = this.matchContextsQueue.peek();
                if (!mcs.hasNext()) {
                    this.matchContextsQueue.remove();
                    continue;
                }
                MatchContext mc = mcs.next();
                if (mc.isDone()) {
                    this.next = mc;
                    return;
                }
                this.matchContextsQueue.addFirst(MatchClauseExecutor.this.resolveMatchContext(this.ctx, mc, this.scope).iterator());
            }
        }
    }
}

