/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.vertexium.Element;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherMergeActionCreate;
import org.vertexium.cypher.ast.model.CypherMergeActionMatch;
import org.vertexium.cypher.ast.model.CypherMergeClause;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.executor.models.match.PatternPartMatchConstraint;
import org.vertexium.cypher.executor.utils.MatchConstraintBuilder;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class MergeClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(MergeClauseExecutor.class);

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherMergeClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        scope.run();
        PatternPartMatchConstraint patternPartConstraint = new MatchConstraintBuilder().patternPartToConstraints(clause.getPatternPart(), false);
        Stream<VertexiumCypherScope> results = scope.stream().map(item -> {
            Stream<VertexiumCypherScope.Item> patternPartResults = ctx.getMatchClauseExecutor().executePatternPartConstraint(ctx, patternPartConstraint, (ExpressionScope)item);
            return (VertexiumCypherScope)StreamUtils.ifEmpty(patternPartResults, () -> {
                Stream<VertexiumCypherScope.Item> createResults = this.executeCreate(ctx, clause, patternPartConstraint, (VertexiumCypherScope.Item)item);
                return VertexiumCypherScope.newItemsScope(createResults, scope);
            }, stream -> this.executeMatch(ctx, clause, (Stream<VertexiumCypherScope.Item>)stream, scope));
        });
        return results.collect(VertexiumCypherScope.concatStreams(scope));
    }

    private VertexiumCypherScope executeMatch(VertexiumCypherQueryContext ctx, CypherMergeClause clause, Stream<VertexiumCypherScope.Item> results, VertexiumCypherScope scope) {
        results = results.map(result -> {
            clause.getMergeActions().stream().filter(ma -> ma instanceof CypherMergeActionMatch).forEach(ma -> this.executeMatchMergeAction(ctx, (CypherMergeActionMatch)ma, (VertexiumCypherScope.Item)result));
            return result;
        });
        return VertexiumCypherScope.newItemsScope(results, scope);
    }

    private void executeMatchMergeAction(VertexiumCypherQueryContext ctx, CypherMergeActionMatch ma, VertexiumCypherScope.Item existingObj) {
        ctx.getSetClauseExecutor().execute(ctx, ma.getSet(), existingObj);
    }

    private Stream<VertexiumCypherScope.Item> executeCreate(VertexiumCypherQueryContext ctx, CypherMergeClause clause, PatternPartMatchConstraint patternPartConstraint, VertexiumCypherScope.Item item) {
        LinkedHashMap<String, Element> map = ctx.getCreateClauseExecutor().executePatternPart(ctx, clause.getPatternPart(), item);
        VertexiumCypherScope.Item concatItem = item.concat(VertexiumCypherScope.newMapItem(map, item.getParentScope()));
        clause.getMergeActions().stream().filter(ma -> ma instanceof CypherMergeActionCreate).forEach(ma -> this.executeCreateMergeAction(ctx, (CypherMergeActionCreate)ma, concatItem));
        return ctx.getMatchClauseExecutor().executePatternPartConstraint(ctx, patternPartConstraint, item);
    }

    private void executeCreateMergeAction(VertexiumCypherQueryContext ctx, CypherMergeActionCreate ma, VertexiumCypherScope.Item newObj) {
        ctx.getSetClauseExecutor().execute(ctx, ma.getSet(), newObj);
    }
}

