/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherResult;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherClause;
import org.vertexium.cypher.ast.model.CypherCreateClause;
import org.vertexium.cypher.ast.model.CypherDeleteClause;
import org.vertexium.cypher.ast.model.CypherMatchClause;
import org.vertexium.cypher.ast.model.CypherMergeClause;
import org.vertexium.cypher.ast.model.CypherQuery;
import org.vertexium.cypher.ast.model.CypherRemoveClause;
import org.vertexium.cypher.ast.model.CypherReturnClause;
import org.vertexium.cypher.ast.model.CypherSetClause;
import org.vertexium.cypher.ast.model.CypherStatement;
import org.vertexium.cypher.ast.model.CypherUnion;
import org.vertexium.cypher.ast.model.CypherUnwindClause;
import org.vertexium.cypher.ast.model.CypherWithClause;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class QueryExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(QueryExecutor.class);

    public VertexiumCypherResult execute(VertexiumCypherQueryContext ctx, CypherStatement statement) {
        LOGGER.debug("execute: %s", new Object[]{statement});
        Preconditions.checkNotNull((Object)statement, (Object)"statement is required");
        CypherAstBase query = statement.getQuery();
        return this.executeQuery(ctx, query);
    }

    private VertexiumCypherScope executeQuery(VertexiumCypherQueryContext ctx, CypherAstBase query) {
        if (query instanceof CypherQuery) {
            return this.execute(ctx, (CypherQuery)query);
        }
        if (query instanceof CypherUnion) {
            return this.executeUnion(ctx, (CypherUnion)query);
        }
        throw new VertexiumCypherTypeErrorException(query, CypherQuery.class, CypherUnion.class);
    }

    private VertexiumCypherScope executeUnion(VertexiumCypherQueryContext ctx, CypherUnion union) {
        VertexiumCypherScope leftResults = this.executeQuery(ctx, union.getLeft());
        VertexiumCypherScope rightResults = this.executeQuery(ctx, union.getRight());
        return leftResults.concat(rightResults, !union.isAll(), null);
    }

    private VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherQuery cypherQuery) {
        VertexiumCypherScope scope = VertexiumCypherScope.newSingleItemScope(VertexiumCypherScope.newEmptyItem());
        ImmutableList<CypherClause> clauses = cypherQuery.getClauses();
        AtomicInteger clauseIndex = new AtomicInteger(0);
        while (clauseIndex.intValue() < clauses.size()) {
            scope = this.execute(ctx, clauses, clauseIndex, scope);
            clauseIndex.incrementAndGet();
        }
        if (clauses.get(clauses.size() - 1) instanceof CypherReturnClause) {
            return scope;
        }
        scope.run();
        return VertexiumCypherScope.newEmpty();
    }

    private VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, ImmutableList<CypherClause> clauses, AtomicInteger clauseIndex, VertexiumCypherScope previousScope) {
        VertexiumCypherScope results;
        CypherClause clause = (CypherClause)clauses.get(clauseIndex.get());
        if (clause instanceof CypherCreateClause) {
            results = ctx.getCreateClauseExecutor().execute(ctx, (CypherCreateClause)clause, previousScope);
        } else if (clause instanceof CypherReturnClause) {
            results = ctx.getReturnClauseExecutor().execute(ctx, (CypherReturnClause)clause, previousScope);
        } else if (clause instanceof CypherMatchClause) {
            List<CypherMatchClause> matchClauses = this.getSimilarClauses(clauses, clauseIndex.get(), CypherMatchClause.class);
            results = ctx.getMatchClauseExecutor().execute(ctx, matchClauses, previousScope);
            clauseIndex.addAndGet(matchClauses.size() - 1);
        } else if (clause instanceof CypherUnwindClause) {
            List<CypherUnwindClause> unwindClauses = this.getSimilarClauses(clauses, clauseIndex.get(), CypherUnwindClause.class);
            results = ctx.getUnwindClauseExecutor().execute(ctx, unwindClauses, previousScope);
            clauseIndex.addAndGet(unwindClauses.size() - 1);
        } else if (clause instanceof CypherWithClause) {
            results = ctx.getWithClauseExecutor().execute(ctx, (CypherWithClause)clause, previousScope);
        } else if (clause instanceof CypherMergeClause) {
            results = ctx.getMergeClauseExecutor().execute(ctx, (CypherMergeClause)clause, previousScope);
        } else if (clause instanceof CypherDeleteClause) {
            results = ctx.getDeleteClauseExecutor().execute(ctx, (CypherDeleteClause)clause, previousScope);
        } else if (clause instanceof CypherSetClause) {
            results = ctx.getSetClauseExecutor().execute(ctx, (CypherSetClause)clause, previousScope);
        } else if (clause instanceof CypherRemoveClause) {
            results = ctx.getRemoveClauseExecutor().execute(ctx, (CypherRemoveClause)clause, previousScope);
        } else {
            throw new VertexiumException("clause not implemented \"" + clause.getClass().getName() + "\": " + clause);
        }
        return results;
    }

    private <T extends CypherClause> List<T> getSimilarClauses(ImmutableList<CypherClause> clauses, int clauseIndex, Class<T> clazz) {
        ArrayList<CypherClause> matchClauses = new ArrayList<CypherClause>();
        matchClauses.add((CypherClause)clauses.get(clauseIndex));
        while (clauseIndex + 1 < clauses.size() && clazz.isInstance(clauses.get(clauseIndex + 1))) {
            matchClauses.add((CypherClause)clauses.get(clauseIndex + 1));
            ++clauseIndex;
        }
        return matchClauses;
    }
}

