/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAllLiteral;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherFunctionInvocation;
import org.vertexium.cypher.ast.model.CypherLimit;
import org.vertexium.cypher.ast.model.CypherLookup;
import org.vertexium.cypher.ast.model.CypherOrderBy;
import org.vertexium.cypher.ast.model.CypherPatternComprehension;
import org.vertexium.cypher.ast.model.CypherReturnBody;
import org.vertexium.cypher.ast.model.CypherReturnClause;
import org.vertexium.cypher.ast.model.CypherReturnItem;
import org.vertexium.cypher.ast.model.CypherSkip;
import org.vertexium.cypher.ast.model.CypherSortItem;
import org.vertexium.cypher.ast.model.CypherVariable;
import org.vertexium.cypher.executor.ExpressionExecutor;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.cypher.functions.CypherFunction;
import org.vertexium.cypher.functions.aggregate.AggregationFunction;
import org.vertexium.cypher.utils.ObjectUtils;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ReturnClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ReturnClauseExecutor.class);
    private final ExpressionExecutor expressionExecutor;

    public ReturnClauseExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherReturnClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        return this.execute(ctx, clause.isDistinct(), clause.getReturnBody(), scope);
    }

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, boolean distinct, CypherReturnBody returnBody, VertexiumCypherScope scope) {
        List<CypherReturnItem> returnItems = returnBody.getReturnItems().stream().flatMap(ri -> {
            if (ri.getExpression() instanceof CypherAllLiteral) {
                return this.getAllFieldNamesAsReturnItems(scope);
            }
            return Stream.of(ri);
        }).collect(Collectors.toList());
        LinkedHashSet<String> columnNames = this.getColumnNames(returnItems);
        Stream<VertexiumCypherScope.Item> rows = scope.stream();
        long aggregationCount = this.aggregationCount(ctx, returnItems);
        if (returnItems.size() > 0 && aggregationCount == (long)returnItems.size()) {
            rows = Stream.of(this.getReturnRow(ctx, returnItems, null, scope));
        } else if (aggregationCount > 0L && this.isGroupable(returnItems.get(0))) {
            Map<Optional<?>, VertexiumCypherScope> groups = this.groupBy(ctx, returnItems.get(0), rows);
            rows = groups.entrySet().stream().map(group -> this.getReturnRow(ctx, returnItems, (Optional)group.getKey(), (ExpressionScope)group.getValue()));
        } else {
            rows = rows.map(row -> this.getReturnRow(ctx, returnItems, null, (ExpressionScope)row));
        }
        if (distinct) {
            rows = rows.distinct();
        }
        VertexiumCypherScope results = VertexiumCypherScope.newItemsScope(rows, columnNames, scope);
        return this.applyReturnBody(ctx, returnBody, results);
    }

    private boolean isGroupable(CypherReturnItem cypherReturnItem) {
        CypherAstBase expression = cypherReturnItem.getExpression();
        if (expression instanceof CypherVariable || expression instanceof CypherLookup || expression instanceof CypherPatternComprehension) {
            return true;
        }
        if (expression instanceof CypherFunctionInvocation) {
            return false;
        }
        return false;
    }

    private VertexiumCypherScope.Item getReturnRow(VertexiumCypherQueryContext ctx, List<CypherReturnItem> returnItems, Optional<?> firstItemValue, ExpressionScope scope) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (int i = 0; i < returnItems.size(); ++i) {
            CypherReturnItem returnItem = returnItems.get(i);
            List value = i == 0 && firstItemValue != null ? firstItemValue.orElse(null) : this.expressionExecutor.executeExpression(ctx, returnItem.getExpression(), scope);
            if (value instanceof Stream) {
                value = ((Stream)((Object)value)).collect(Collectors.toList());
            }
            value = this.expandResultMapSubItems(ctx, value, scope);
            values.put(returnItem.getResultColumnName(), value);
        }
        return VertexiumCypherScope.newMapItem(values, scope);
    }

    private LinkedHashSet<String> getColumnNames(Iterable<CypherReturnItem> returnItems) {
        return (LinkedHashSet)StreamUtils.stream((Iterable[])new Iterable[]{returnItems}).map(CypherReturnItem::getResultColumnName).collect(StreamUtils.toLinkedHashSet());
    }

    private Map<Optional<?>, VertexiumCypherScope> groupBy(VertexiumCypherQueryContext ctx, CypherReturnItem returnItem, Stream<VertexiumCypherScope.Item> rows) {
        Set<Map.Entry<Optional, List<VertexiumCypherScope.Item>>> results = rows.collect(Collectors.groupingBy(row -> Optional.ofNullable(ctx.getExpressionExecutor().executeExpression(ctx, returnItem.getExpression(), (ExpressionScope)row)))).entrySet();
        return results.stream().collect(Collectors.toMap(Map.Entry::getKey, o -> {
            List items = (List)o.getValue();
            VertexiumCypherScope parentScope = ((VertexiumCypherScope.Item)items.get(0)).getParentCypherScope();
            return VertexiumCypherScope.newItemsScope(items.stream(), parentScope);
        }));
    }

    private long aggregationCount(VertexiumCypherQueryContext ctx, Iterable<CypherReturnItem> returnItems) {
        return StreamUtils.stream((Iterable[])new Iterable[]{returnItems}).filter(ri -> this.hasAggregations(ctx, (CypherAstBase)ri)).count();
    }

    private boolean hasAggregations(VertexiumCypherQueryContext ctx, CypherAstBase ri) {
        CypherFunction fn;
        if (ri == null) {
            return false;
        }
        if (ri instanceof CypherFunctionInvocation && (fn = ctx.getFunction(((CypherFunctionInvocation)ri).getFunctionName())) != null && fn instanceof AggregationFunction) {
            return true;
        }
        return ri.getChildren().anyMatch(child -> this.hasAggregations(ctx, (CypherAstBase)child));
    }

    private Stream<CypherReturnItem> getAllFieldNamesAsReturnItems(VertexiumCypherScope scope) {
        return scope.getColumnNames().stream().map(n -> new CypherReturnItem((String)n, new CypherVariable((String)n), (String)n));
    }

    private Object expandResultMapSubItems(VertexiumCypherQueryContext ctx, Object value, ExpressionScope scope) {
        if (value instanceof Map) {
            Map map = (Map)value;
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof CypherAstBase) {
                    CypherAstBase entryValue = (CypherAstBase)entry.getValue();
                    Object newEntryValue = this.expressionExecutor.executeExpression(ctx, entryValue, scope);
                    newEntryValue = this.expandResultMapSubItems(ctx, newEntryValue, scope);
                    result.put(entry.getKey(), newEntryValue);
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
        return value;
    }

    public VertexiumCypherScope applyReturnBody(VertexiumCypherQueryContext ctx, CypherReturnBody returnBody, VertexiumCypherScope results) {
        Stream<VertexiumCypherScope.Item> rows = results.stream();
        if (returnBody.getOrder() != null) {
            rows = this.applyOrderByToResults(ctx, rows, returnBody.getOrder());
        }
        if (returnBody.getSkip() != null) {
            rows = this.applySkipToResults(ctx, rows, returnBody.getSkip(), results);
        }
        if (returnBody.getLimit() != null) {
            rows = this.applyLimitToResults(ctx, rows, returnBody.getLimit(), results);
        }
        return VertexiumCypherScope.newItemsScope(rows, results.getColumnNames(), results.getParentScope());
    }

    private Stream<VertexiumCypherScope.Item> applyOrderByToResults(VertexiumCypherQueryContext ctx, Stream<VertexiumCypherScope.Item> results, CypherOrderBy orderByClause) {
        List<CypherSortItem> sortItems = orderByClause.getSortItems();
        return results.sorted((o1, o2) -> {
            for (CypherSortItem sortItem : sortItems) {
                Object v2;
                Object v1 = this.getOrderByValue(ctx, sortItem, (VertexiumCypherScope.Item)o1);
                int i = ObjectUtils.compare(v1, v2 = this.getOrderByValue(ctx, sortItem, (VertexiumCypherScope.Item)o2));
                if (i == 0) continue;
                return i;
            }
            return 0;
        });
    }

    private Object getOrderByValue(VertexiumCypherQueryContext ctx, CypherSortItem sortItem, VertexiumCypherScope.Item scope) {
        Iterator iterator;
        HashSet resultsSet;
        Object value = scope.getByName(sortItem.getExpression().toString(), false);
        if (value != null) {
            return value;
        }
        Object results = ctx.getExpressionExecutor().executeExpression(ctx, sortItem.getExpression(), scope);
        if (results instanceof Collection && ((Collection)results).size() > 0 && (resultsSet = new HashSet((Collection)results)).size() == 1 && (iterator = resultsSet.iterator()).hasNext()) {
            Object item = iterator.next();
            return item;
        }
        return results;
    }

    private Stream<VertexiumCypherScope.Item> applyLimitToResults(VertexiumCypherQueryContext ctx, Stream<VertexiumCypherScope.Item> results, CypherLimit limitClause, VertexiumCypherScope scope) {
        Object limitObj = ctx.getExpressionExecutor().executeExpression(ctx, limitClause.getExpression(), scope);
        if (!(limitObj instanceof Integer) && !(limitObj instanceof Long)) {
            throw new VertexiumException("limit with a none integer not supported: " + limitObj);
        }
        int limit = ((Number)limitObj).intValue();
        if (limit < 0) {
            limit = 0;
        }
        results = results.limit(limit);
        return results;
    }

    private Stream<VertexiumCypherScope.Item> applySkipToResults(VertexiumCypherQueryContext ctx, Stream<VertexiumCypherScope.Item> results, CypherSkip skipClause, VertexiumCypherScope scope) {
        Object skipObj = ctx.getExpressionExecutor().executeExpression(ctx, skipClause.getExpression(), scope);
        if (!(skipObj instanceof Integer) && !(skipObj instanceof Long)) {
            throw new VertexiumException("skip with a none integer not supported: " + skipObj);
        }
        int skip = ((Number)skipObj).intValue();
        results = results.skip(skip);
        return results;
    }
}

