/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.Element;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherLabelName;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherLiteral;
import org.vertexium.cypher.ast.model.CypherLookup;
import org.vertexium.cypher.ast.model.CypherSetClause;
import org.vertexium.cypher.ast.model.CypherSetItem;
import org.vertexium.cypher.ast.model.CypherSetNodeLabels;
import org.vertexium.cypher.ast.model.CypherSetProperty;
import org.vertexium.cypher.ast.model.CypherSetVariable;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.mutation.ElementMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class SetClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(SetClauseExecutor.class);

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherSetClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        scope.run();
        scope.stream().forEach(item -> this.execute(ctx, clause, (VertexiumCypherScope.Item)item));
        return scope;
    }

    public void execute(VertexiumCypherQueryContext ctx, CypherSetClause clause, VertexiumCypherScope.Item item) {
        clause.getSetItems().forEach(setItem -> {
            if (setItem instanceof CypherSetNodeLabels) {
                this.executeSetNodeLabels(ctx, (CypherSetNodeLabels)setItem, item);
            } else if (setItem instanceof CypherSetProperty) {
                this.executeSetProperty(ctx, (CypherSetProperty)setItem, item);
            } else if (setItem instanceof CypherSetVariable) {
                this.executeSetVariable(ctx, (CypherSetVariable)setItem, item);
            } else {
                throw new VertexiumCypherTypeErrorException(setItem, CypherSetNodeLabels.class, CypherSetProperty.class, CypherSetVariable.class);
            }
        });
    }

    private void executeSetVariable(VertexiumCypherQueryContext ctx, CypherSetVariable setItem, VertexiumCypherScope.Item item) {
        Object left = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)setItem.getLeft(), item);
        VertexiumCypherTypeErrorException.assertType(left, Element.class, null);
        if (left == null) {
            return;
        }
        Object values = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)setItem.getRight(), item);
        CypherSetItem.Op op = setItem.getOp();
        if (values instanceof Stream) {
            values = ((Stream)values).collect(Collectors.toList());
        }
        if (values instanceof List && values.size() == 1) {
            values = values.get(0);
        }
        VertexiumCypherTypeErrorException.assertType(values, Map.class, Element.class);
        if (values instanceof Element) {
            values = ctx.getElementPropertiesAsMap((Element)values);
        }
        Element element = (Element)left;
        Map valuesMap = (Map)values;
        ExistingElementMutation m = element.prepareMutation();
        if (op == CypherSetItem.Op.EQUAL) {
            for (Property property : element.getProperties()) {
                if (ctx.isLabelProperty(property) || valuesMap.containsKey(property.getName())) continue;
                ctx.removeProperty((ElementMutation<Element>)m, property.getName());
            }
        }
        for (Map.Entry entry : valuesMap.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof CypherLiteral) {
                value = ((CypherLiteral)value).getValue();
            }
            if (value == null) {
                ctx.removeProperty((ElementMutation<Element>)m, propertyName);
                continue;
            }
            ctx.setProperty(m, propertyName, value);
        }
        ctx.saveElement(m);
    }

    private void executeSetProperty(VertexiumCypherQueryContext ctx, CypherSetProperty setItem, VertexiumCypherScope.Item item) {
        Object left = ctx.getExpressionExecutor().executeExpression(ctx, ((CypherLookup)setItem.getLeft()).getAtom(), item);
        VertexiumCypherTypeErrorException.assertType(left, Element.class, null);
        if (left == null) {
            return;
        }
        String propertyName = ((CypherLookup)setItem.getLeft()).getProperty();
        Object value = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)setItem.getRight(), item);
        Element element = (Element)left;
        ExistingElementMutation m = element.prepareMutation();
        switch (setItem.getOp()) {
            case EQUAL: {
                if (value == null) {
                    ctx.removeProperty((ElementMutation<Element>)m, propertyName);
                    break;
                }
                ctx.setProperty(m, propertyName, value);
                break;
            }
            default: {
                throw new VertexiumCypherNotImplemented("" + setItem);
            }
        }
        ctx.saveElement(m);
    }

    private void executeSetNodeLabels(VertexiumCypherQueryContext ctx, CypherSetNodeLabels setItem, VertexiumCypherScope.Item item) {
        Object left = ctx.getExpressionExecutor().executeExpression(ctx, (CypherAstBase)setItem.getLeft(), item);
        VertexiumCypherTypeErrorException.assertType(left, Vertex.class, null);
        if (left == null) {
            return;
        }
        Vertex vertex = (Vertex)left;
        ExistingElementMutation m = vertex.prepareMutation();
        for (CypherLabelName labelName : (CypherListLiteral)setItem.getRight()) {
            ctx.setLabelProperty(m, (String)labelName.getValue());
        }
        ctx.saveVertex((ElementMutation<Vertex>)m);
    }
}

