/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.VertexiumException;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherUnwindClause;
import org.vertexium.cypher.executor.ExpressionExecutor;
import org.vertexium.cypher.executor.ExpressionScope;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class UnwindClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(UnwindClauseExecutor.class);
    private final ExpressionExecutor expressionExecutor;

    public UnwindClauseExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, List<CypherUnwindClause> clauses, VertexiumCypherScope scope) {
        ArrayList<VertexiumCypherScope> allResults = new ArrayList<VertexiumCypherScope>();
        VertexiumCypherScope accumulatorScope = scope;
        for (CypherUnwindClause clause : clauses) {
            ArrayList<VertexiumCypherScope.Item> clauseResults = new ArrayList<VertexiumCypherScope.Item>();
            accumulatorScope.stream().forEach(item -> {
                List items = this.execute(ctx, clause, (ExpressionScope)item).collect(Collectors.toList());
                clauseResults.addAll(items);
            });
            accumulatorScope = VertexiumCypherScope.newItemsScope(clauseResults, scope);
            allResults.add(accumulatorScope);
        }
        return accumulatorScope;
    }

    private Stream<VertexiumCypherScope.Item> execute(VertexiumCypherQueryContext ctx, CypherUnwindClause clause, ExpressionScope scope) {
        Stream stream;
        LOGGER.debug("execute: %s", new Object[]{clause});
        Object exprResult = this.expressionExecutor.executeExpression(ctx, clause.getExpression(), scope);
        if (exprResult == null) {
            return Stream.of(new VertexiumCypherScope.Item[0]);
        }
        if (exprResult instanceof Stream) {
            stream = (Stream)exprResult;
        } else if (exprResult instanceof Collection) {
            Collection collection = (Collection)exprResult;
            stream = collection.stream();
        } else {
            throw new VertexiumException("unhandled data type: " + exprResult.getClass().getName());
        }
        return stream.map(o -> VertexiumCypherScope.newMapItem(clause.getName(), o, scope));
    }
}

