/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vertexium.cypher.VertexiumCypherQueryContext;
import org.vertexium.cypher.VertexiumCypherScope;
import org.vertexium.cypher.ast.model.CypherWithClause;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class WithClauseExecutor {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(WithClauseExecutor.class);

    public VertexiumCypherScope execute(VertexiumCypherQueryContext ctx, CypherWithClause clause, VertexiumCypherScope scope) {
        LOGGER.debug("execute: %s", new Object[]{clause});
        VertexiumCypherScope results = ctx.getReturnClauseExecutor().execute(ctx, clause.isDistinct(), clause.getReturnBody(), scope);
        Stream<VertexiumCypherScope.Item> rows = results.stream();
        if (clause.getWhere() != null) {
            rows = ctx.getExpressionExecutor().applyWhereToResults(ctx, rows, clause.getWhere());
        }
        List<VertexiumCypherScope.Item> rowsList = rows.collect(Collectors.toList());
        return VertexiumCypherScope.newItemsScope(rowsList, results.getColumnNames(), null);
    }
}

