/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor.models.match;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherRangeLiteral;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;

public abstract class MatchConstraint<TCypherElementPattern extends CypherElementPattern, TConnected extends MatchConstraint> {
    private final String name;
    private final String hashName;
    private final List<TConnected> connectedConstraints = new ArrayList<TConnected>();
    private final List<TCypherElementPattern> patterns;
    private boolean optional;

    protected MatchConstraint(String name, List<TCypherElementPattern> patterns, boolean optional) {
        this.name = name;
        this.hashName = name == null ? UUID.randomUUID().toString() : name;
        this.patterns = patterns;
        this.optional = optional;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public List<TConnected> getConnectedConstraints() {
        return this.connectedConstraints;
    }

    public void addConnectedConstraint(TConnected constraint) {
        Preconditions.checkNotNull(constraint, (Object)"connected constraint cannot be null");
        this.connectedConstraints.add(constraint);
    }

    public List<TCypherElementPattern> getPatterns() {
        return this.patterns;
    }

    public static <TCypherElementPattern extends CypherElementPattern, TConnected extends MatchConstraint> void merge(MatchConstraint<TCypherElementPattern, TConnected> src, MatchConstraint<TCypherElementPattern, TConnected> dest) {
        dest.connectedConstraints.addAll(src.getConnectedConstraints());
        for (MatchConstraint connectedConstraint : dest.connectedConstraints) {
            if (!connectedConstraint.getConnectedConstraints().contains(src)) continue;
            connectedConstraint.getConnectedConstraints().remove(src);
            connectedConstraint.getConnectedConstraints().add(dest);
        }
        dest.patterns.addAll(src.patterns);
        dest.setOptional(src.isOptional() && dest.isOptional());
    }

    public String toString() {
        return "MatchConstraint{name='" + this.name + '\'' + ", hashName='" + this.hashName + '\'' + ", patterns=" + this.patterns + ", optional=" + this.optional + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchConstraint that = (MatchConstraint)o;
        return this.hashName.equals(that.hashName);
    }

    public int hashCode() {
        return this.hashName.hashCode();
    }

    public boolean hasZeroRangePattern() {
        for (CypherElementPattern elementPattern : this.getPatterns()) {
            Integer from;
            CypherRangeLiteral range;
            if (!(elementPattern instanceof CypherRelationshipPattern) || (range = ((CypherRelationshipPattern)elementPattern).getRange()) == null || (from = range.getFrom()) == null || from != 0) continue;
            return true;
        }
        return false;
    }

    public int getConstraintCount() {
        return this.getPatterns().stream().map(CypherElementPattern::getConstraintCount).reduce(0, (i1, i2) -> i1 + i2);
    }
}

