/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor.models.match;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.vertexium.cypher.executor.models.match.MatchConstraint;

public class PatternPartMatchConstraint {
    private final Map<String, List<MatchConstraint>> namedPaths;
    private final LinkedHashSet<MatchConstraint> matchConstraints;

    public PatternPartMatchConstraint(Map<String, List<MatchConstraint>> namedMatchConstraints, LinkedHashSet<MatchConstraint> matchConstraints) {
        this.namedPaths = namedMatchConstraints;
        this.matchConstraints = matchConstraints;
    }

    public PatternPartMatchConstraint(String pathName, LinkedHashSet<MatchConstraint> matchConstraints) {
        this.namedPaths = new HashMap<String, List<MatchConstraint>>();
        if (pathName != null) {
            this.namedPaths.put(pathName, Lists.newArrayList(matchConstraints));
        }
        this.matchConstraints = matchConstraints;
    }

    public Map<String, List<MatchConstraint>> getNamedPaths() {
        return this.namedPaths;
    }

    public LinkedHashSet<MatchConstraint> getMatchConstraints() {
        return this.matchConstraints;
    }

    public Set<String> getPartNames() {
        return this.getMatchConstraints().stream().map(MatchConstraint::getName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternPartMatchConstraint that = (PatternPartMatchConstraint)o;
        if (this.namedPaths != null ? !this.namedPaths.equals(that.namedPaths) : that.namedPaths != null) {
            return false;
        }
        return this.matchConstraints != null ? this.matchConstraints.equals(that.matchConstraints) : that.matchConstraints == null;
    }

    public int hashCode() {
        int result = this.namedPaths != null ? this.namedPaths.hashCode() : 0;
        result = 31 * result + (this.matchConstraints != null ? this.matchConstraints.hashCode() : 0);
        return result;
    }
}

