/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor.models.match;

import org.vertexium.cypher.ast.model.CypherRangeLiteral;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.exceptions.VertexiumCypherNotImplemented;

public class RelationshipMatchRange {
    private final boolean rangeSet;
    private final Integer from;
    private final Integer to;

    public RelationshipMatchRange(CypherRelationshipPattern relationshipPattern) {
        CypherRangeLiteral range = relationshipPattern.getRange();
        boolean bl = this.rangeSet = range != null;
        if (this.rangeSet) {
            this.from = range.getFrom() == null ? 1 : range.getFrom();
            this.to = range.getTo();
        } else {
            this.from = null;
            this.to = null;
        }
    }

    public RelationshipMatchRange merge(CypherRelationshipPattern relationshipPattern) {
        RelationshipMatchRange other = new RelationshipMatchRange(relationshipPattern);
        if (this.equals(other)) {
            return other;
        }
        throw new VertexiumCypherNotImplemented("Cannot merge differing range set " + this + " != " + other);
    }

    public boolean isIn(int i) {
        return !this.isBefore(i) && !this.isAfter(i);
    }

    public boolean isRangeSet() {
        return this.rangeSet;
    }

    public boolean isBefore(int i) {
        return this.from != null && i < this.from;
    }

    public boolean isAfter(int i) {
        return this.to != null && i > this.to;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipMatchRange that = (RelationshipMatchRange)o;
        if (this.rangeSet != that.rangeSet) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        return this.to != null ? this.to.equals(that.to) : that.to == null;
    }

    public int hashCode() {
        int result = this.rangeSet ? 1 : 0;
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RelationshipMatchRange{from=" + this.from + ", to=" + this.to + '}';
    }
}

