/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cypher.executor.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.vertexium.cypher.ast.model.CypherAstBase;
import org.vertexium.cypher.ast.model.CypherElementPattern;
import org.vertexium.cypher.ast.model.CypherListLiteral;
import org.vertexium.cypher.ast.model.CypherMatchClause;
import org.vertexium.cypher.ast.model.CypherNodePattern;
import org.vertexium.cypher.ast.model.CypherPatternPart;
import org.vertexium.cypher.ast.model.CypherRelationshipPattern;
import org.vertexium.cypher.exceptions.VertexiumCypherTypeErrorException;
import org.vertexium.cypher.executor.models.match.MatchConstraint;
import org.vertexium.cypher.executor.models.match.MatchConstraints;
import org.vertexium.cypher.executor.models.match.NodeMatchConstraint;
import org.vertexium.cypher.executor.models.match.PatternPartMatchConstraint;
import org.vertexium.cypher.executor.models.match.RelationshipMatchConstraint;

public class MatchConstraintBuilder {
    public MatchConstraints getMatchConstraints(List<CypherMatchClause> matchClauses) {
        MatchConstraints matchConstraints = null;
        for (CypherMatchClause matchClaus : matchClauses) {
            MatchConstraints newMatchConstraints = this.matchClauseToConstraints(matchClaus);
            if (matchConstraints == null) {
                matchConstraints = newMatchConstraints;
                continue;
            }
            matchConstraints = this.mergeMatchConstraints(matchConstraints, newMatchConstraints);
        }
        LinkedHashSet<PatternPartMatchConstraint> collapseConstraints = this.collapseConstraints(new LinkedList<PatternPartMatchConstraint>(matchConstraints.getPatternPartMatchConstraints()));
        return new MatchConstraints(collapseConstraints, matchConstraints.getWhereExpressions());
    }

    private MatchConstraints mergeMatchConstraints(MatchConstraints matchConstraintsA, MatchConstraints matchConstraintsB) {
        LinkedHashSet<PatternPartMatchConstraint> mergedConstraints = new LinkedHashSet<PatternPartMatchConstraint>();
        for (PatternPartMatchConstraint patternPartMatchConstraintA : matchConstraintsA.getPatternPartMatchConstraints()) {
            for (PatternPartMatchConstraint patternPartMatchConstraintB : matchConstraintsB.getPatternPartMatchConstraints()) {
                if (this.patternPartMatchConstraintHasOverlap(patternPartMatchConstraintA, patternPartMatchConstraintB)) {
                    mergedConstraints.add(this.mergePatternPartMatchConstraint(patternPartMatchConstraintA, patternPartMatchConstraintB));
                    continue;
                }
                mergedConstraints.add(patternPartMatchConstraintA);
                mergedConstraints.add(patternPartMatchConstraintB);
            }
        }
        ArrayList<CypherAstBase> whereExpressions = new ArrayList<CypherAstBase>();
        whereExpressions.addAll(matchConstraintsA.getWhereExpressions());
        whereExpressions.addAll(matchConstraintsB.getWhereExpressions());
        return new MatchConstraints(mergedConstraints, whereExpressions);
    }

    private LinkedHashSet<PatternPartMatchConstraint> collapseConstraints(LinkedList<PatternPartMatchConstraint> constraints) {
        LinkedHashSet<PatternPartMatchConstraint> results = new LinkedHashSet<PatternPartMatchConstraint>();
        while (constraints.size() > 0) {
            PatternPartMatchConstraint constraint = constraints.removeFirst();
            Optional<PatternPartMatchConstraint> overlappingConstraint = constraints.stream().filter(c -> this.patternPartMatchConstraintHasOverlap(constraint, (PatternPartMatchConstraint)c)).findFirst();
            if (overlappingConstraint.isPresent()) {
                constraints.remove(overlappingConstraint.get());
                constraints.add(this.mergePatternPartMatchConstraint(constraint, overlappingConstraint.get()));
                continue;
            }
            results.add(constraint);
        }
        return results;
    }

    private PatternPartMatchConstraint mergePatternPartMatchConstraint(PatternPartMatchConstraint patternPartMatchConstraintA, PatternPartMatchConstraint patternPartMatchConstraintB) {
        LinkedHashSet<MatchConstraint> matchConstraints = new LinkedHashSet<MatchConstraint>();
        matchConstraints.addAll(patternPartMatchConstraintB.getMatchConstraints());
        for (MatchConstraint matchConstraintA : patternPartMatchConstraintA.getMatchConstraints()) {
            boolean foundMatch = false;
            if (matchConstraintA.getName() != null) {
                for (MatchConstraint matchConstraintB : patternPartMatchConstraintB.getMatchConstraints()) {
                    if (!matchConstraintA.getName().equals(matchConstraintB.getName())) continue;
                    MatchConstraint.merge(matchConstraintA, matchConstraintB);
                    foundMatch = true;
                }
            }
            if (foundMatch) continue;
            matchConstraints.add(matchConstraintA);
        }
        HashMap<String, List<MatchConstraint>> namedMatchConstraints = new HashMap<String, List<MatchConstraint>>();
        namedMatchConstraints.putAll(patternPartMatchConstraintA.getNamedPaths());
        namedMatchConstraints.putAll(patternPartMatchConstraintB.getNamedPaths());
        return new PatternPartMatchConstraint(namedMatchConstraints, matchConstraints);
    }

    private boolean patternPartMatchConstraintHasOverlap(PatternPartMatchConstraint patternPartMatchConstraint, PatternPartMatchConstraint newPatternPartMatchConstraint) {
        Set<String> partNames = patternPartMatchConstraint.getPartNames();
        Set<String> newPartNames = newPatternPartMatchConstraint.getPartNames();
        for (String newPartName : newPartNames) {
            if (!partNames.contains(newPartName)) continue;
            return true;
        }
        return false;
    }

    private MatchConstraints matchClauseToConstraints(CypherMatchClause cypherMatchClause) {
        LinkedList<PatternPartMatchConstraint> ll = new LinkedList<PatternPartMatchConstraint>(cypherMatchClause.getPatternParts().stream().map(pp -> this.patternPartToConstraints((CypherPatternPart)pp, cypherMatchClause.isOptional())).collect(Collectors.toList()));
        LinkedHashSet<PatternPartMatchConstraint> patternPartMatchConstraints = this.collapseConstraints(ll);
        ArrayList whereExpressions = cypherMatchClause.getWhereExpression() == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new CypherAstBase[]{cypherMatchClause.getWhereExpression()});
        return new MatchConstraints(patternPartMatchConstraints, whereExpressions);
    }

    public PatternPartMatchConstraint patternPartToConstraints(CypherPatternPart patternPart, boolean optional) {
        String pathName = patternPart.getName();
        CypherListLiteral<CypherElementPattern> elementPatterns = patternPart.getElementPatterns();
        LinkedHashSet<MatchConstraint> allConstraints = new LinkedHashSet<MatchConstraint>();
        NodeMatchConstraint firstMatchConstraint = null;
        MatchConstraint previousConstraint = null;
        for (CypherElementPattern elementPattern : elementPatterns) {
            if (elementPattern instanceof CypherNodePattern) {
                Optional<NodeMatchConstraint> existingNodeMatchConstraint = allConstraints.stream().filter(c -> c.getName() != null && c.getName().equals(elementPattern.getName())).map(c -> (NodeMatchConstraint)c).findFirst();
                NodeMatchConstraint nodeMatchConstraint = existingNodeMatchConstraint.orElseGet(() -> new NodeMatchConstraint(elementPattern.getName(), Lists.newArrayList(), optional));
                nodeMatchConstraint.getPatterns().add((CypherNodePattern)elementPattern);
                allConstraints.add(nodeMatchConstraint);
                if (firstMatchConstraint == null) {
                    firstMatchConstraint = nodeMatchConstraint;
                }
                if (previousConstraint != null) {
                    nodeMatchConstraint.addConnectedConstraint(previousConstraint);
                    previousConstraint.addConnectedConstraint(nodeMatchConstraint);
                }
                previousConstraint = nodeMatchConstraint;
                continue;
            }
            if (elementPattern instanceof CypherRelationshipPattern) {
                RelationshipMatchConstraint relationshipMatchConstraint = new RelationshipMatchConstraint(elementPattern.getName(), Lists.newArrayList((Object[])new CypherRelationshipPattern[]{(CypherRelationshipPattern)elementPattern}), optional);
                allConstraints.add(relationshipMatchConstraint);
                if (previousConstraint != null) {
                    relationshipMatchConstraint.addConnectedConstraint((NodeMatchConstraint)previousConstraint);
                    ((NodeMatchConstraint)previousConstraint).addConnectedConstraint(relationshipMatchConstraint);
                }
                previousConstraint = relationshipMatchConstraint;
                continue;
            }
            throw new VertexiumCypherTypeErrorException(elementPattern, CypherNodePattern.class, CypherRelationshipPattern.class);
        }
        return new PatternPartMatchConstraint(pathName, allConstraints);
    }
}

